/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;

public class ExportData
extends FreeColObject {
    private int highLevel = 90;
    private int lowLevel = 10;
    private int exportLevel = 50;
    private boolean exported = false;

    public ExportData() {
    }

    public ExportData(GoodsType goodsType) {
        this.setId(goodsType.getId());
    }

    public ExportData(GoodsType goodsType, boolean exported, int lowLevel, int highLevel, int exportLevel) {
        this.setId(goodsType.getId());
        this.exported = exported;
        this.lowLevel = lowLevel;
        this.highLevel = highLevel;
        this.exportLevel = exportLevel;
    }

    public ExportData(GoodsType goodsType, boolean exported, int exportLevel) {
        this(goodsType, exported, 0, 100, exportLevel);
    }

    public ExportData(GoodsType goodsType, ExportData template) {
        this.setId(goodsType.getId());
        this.exported = template.exported;
        this.lowLevel = template.lowLevel;
        this.highLevel = template.highLevel;
        this.exportLevel = template.exportLevel;
    }

    public final int getHighLevel() {
        return this.highLevel;
    }

    public final void setHighLevel(int newHighLevel) {
        this.highLevel = newHighLevel;
    }

    public final int getLowLevel() {
        return this.lowLevel;
    }

    public final void setLowLevel(int newLowLevel) {
        this.lowLevel = newLowLevel;
    }

    public final int getExportLevel() {
        return this.exportLevel;
    }

    public final void setExportLevel(int newExportLevel) {
        this.exportLevel = newExportLevel;
    }

    public final boolean isExported() {
        return this.exported;
    }

    public final void setExported(boolean newExport) {
        this.exported = newExport;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(ExportData.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("exported", Boolean.toString(this.exported));
        out.writeAttribute("highLevel", Integer.toString(this.highLevel));
        out.writeAttribute("lowLevel", Integer.toString(this.lowLevel));
        out.writeAttribute("exportLevel", Integer.toString(this.exportLevel));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.exported = Boolean.parseBoolean(in.getAttributeValue(null, "exported"));
        this.highLevel = Integer.parseInt(in.getAttributeValue(null, "highLevel"));
        this.lowLevel = Integer.parseInt(in.getAttributeValue(null, "lowLevel"));
        this.exportLevel = Integer.parseInt(in.getAttributeValue(null, "exportLevel"));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "exportData";
    }
}

