/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event
extends FreeColGameObjectType {
    private String value;
    private int scoreValue = 0;
    private Map<String, Limit> limits;

    public Event(String id, Specification specification) {
        super(id, specification);
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String newValue) {
        this.value = newValue;
    }

    public final Collection<Limit> getLimits() {
        return this.limits.values();
    }

    public final Limit getLimit(String id) {
        return this.limits.get(id);
    }

    public final int getScoreValue() {
        return this.scoreValue;
    }

    public final void setScoreValue(int newScoreValue) {
        this.scoreValue = newScoreValue;
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, Event.getXMLElementTagName());
    }

    @Override
    public void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.value != null) {
            out.writeAttribute("value", this.value);
        }
        if (this.scoreValue != 0) {
            out.writeAttribute("scoreValue", Integer.toString(this.scoreValue));
        }
    }

    @Override
    public void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.limits != null) {
            for (Limit limit : this.limits.values()) {
                limit.toXMLImpl(out);
            }
        }
    }

    @Override
    public void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.value = in.getAttributeValue(null, "value");
        this.scoreValue = this.getAttribute(in, "scoreValue", 0);
    }

    @Override
    public void readChild(XMLStreamReader in) throws XMLStreamException {
        if (Limit.getXMLElementTagName().equals(in.getLocalName())) {
            if (this.limits == null) {
                this.limits = new HashMap<String, Limit>();
            }
            Limit limit = new Limit(this.getSpecification());
            limit.readFromXML(in);
            this.limits.put(limit.getId(), limit);
        } else {
            super.readChild(in);
        }
    }

    public static String getXMLElementTagName() {
        return "event";
    }
}

