/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.UnitTradeItem;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiplomaticTrade
extends FreeColObject {
    private List<TradeItem> items;
    private final Game game;
    private Player sender;
    private Player recipient;
    private TradeStatus status;

    public DiplomaticTrade(Game game, Player sender, Player recipient) {
        this(game, sender, recipient, new ArrayList<TradeItem>());
    }

    public DiplomaticTrade(Game game, Player sender, Player recipient, List<TradeItem> items) {
        this.game = game;
        this.sender = sender;
        this.recipient = recipient;
        this.items = items;
        this.status = TradeStatus.PROPOSE_TRADE;
    }

    public DiplomaticTrade(Game game, Element element) {
        this.game = game;
        this.readFromXMLElement(element);
    }

    public TradeStatus getStatus() {
        return this.status;
    }

    public void setStatus(TradeStatus status) {
        this.status = status;
    }

    public final Player getSender() {
        return this.sender;
    }

    public final void setSender(Player newSender) {
        this.sender = newSender;
    }

    public final Player getRecipient() {
        return this.recipient;
    }

    public final void setRecipient(Player newRecipient) {
        this.recipient = newRecipient;
    }

    public void add(TradeItem newItem) {
        if (newItem.isUnique()) {
            this.removeType(newItem);
        }
        this.items.add(newItem);
    }

    public void remove(TradeItem newItem) {
        this.items.remove(newItem);
    }

    public void remove(int index) {
        this.items.remove(index);
    }

    public void removeType(TradeItem someItem) {
        Iterator<TradeItem> itemIterator = this.items.iterator();
        while (itemIterator.hasNext()) {
            if (itemIterator.next().getClass() != someItem.getClass()) continue;
            itemIterator.remove();
        }
    }

    public List<TradeItem> getTradeItems() {
        return this.items;
    }

    public Iterator<TradeItem> iterator() {
        return this.items.iterator();
    }

    public Player.Stance getStance() {
        for (TradeItem item : this.items) {
            if (!(item instanceof StanceTradeItem)) continue;
            return ((StanceTradeItem)item).getStance();
        }
        return null;
    }

    public List<Goods> getGoodsGivenBy(Player player) {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (TradeItem item : this.items) {
            if (!(item instanceof GoodsTradeItem) || player != item.getSource()) continue;
            goodsList.add(((GoodsTradeItem)item).getGoods());
        }
        return goodsList;
    }

    public List<Colony> getColoniesGivenBy(Player player) {
        ArrayList<Colony> colonyList = new ArrayList<Colony>();
        for (TradeItem item : this.items) {
            if (!(item instanceof ColonyTradeItem) || player != item.getSource()) continue;
            colonyList.add(((ColonyTradeItem)item).getColony());
        }
        return colonyList;
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String senderString = in.getAttributeValue(null, "sender");
        this.sender = (Player)this.game.getFreeColGameObject(senderString);
        String recipientString = in.getAttributeValue(null, "recipient");
        this.recipient = (Player)this.game.getFreeColGameObject(recipientString);
        this.status = Enum.valueOf(TradeStatus.class, in.getAttributeValue(null, "status"));
        this.items = new ArrayList<TradeItem>();
        while (in.hasNext()) {
            TradeItem item;
            if (in.next() != 1) continue;
            if (in.getLocalName().equals(StanceTradeItem.getXMLElementTagName())) {
                item = new StanceTradeItem(this.game, in);
            } else if (in.getLocalName().equals(GoodsTradeItem.getXMLElementTagName())) {
                item = new GoodsTradeItem(this.game, in);
            } else if (in.getLocalName().equals(GoldTradeItem.getXMLElementTagName())) {
                item = new GoldTradeItem(this.game, in);
            } else if (in.getLocalName().equals(ColonyTradeItem.getXMLElementTagName())) {
                item = new ColonyTradeItem(this.game, in);
            } else if (in.getLocalName().equals(UnitTradeItem.getXMLElementTagName())) {
                item = new UnitTradeItem(this.game, in);
            } else {
                logger.warning("Unknown TradeItem: " + in.getLocalName());
                continue;
            }
            this.items.add(item);
        }
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(DiplomaticTrade.getXMLElementTagName());
        out.writeAttribute("sender", this.sender.getId());
        out.writeAttribute("recipient", this.recipient.getId());
        out.writeAttribute("status", this.status.toString());
        for (TradeItem item : this.items) {
            item.toXML(out);
        }
        out.writeEndElement();
    }

    public static String getXMLElementTagName() {
        return "diplomaticTrade";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TradeStatus {
        PROPOSE_TRADE,
        ACCEPT_TRADE,
        REJECT_TRADE;

    }
}

