/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildableType
extends FreeColGameObjectType {
    public static final String NOTHING = "model.buildableType.nothing";
    private int populationRequired = 1;
    private List<Limit> limits;
    private List<AbstractGoods> goodsRequired = new ArrayList<AbstractGoods>();
    private final Map<String, Boolean> requiredAbilities = new HashMap<String, Boolean>();

    public BuildableType(String id, Specification specification) {
        super(id, specification);
    }

    public final List<AbstractGoods> getGoodsRequired() {
        return this.goodsRequired;
    }

    public final int getAmountRequiredOf(GoodsType type) {
        for (AbstractGoods goods : this.goodsRequired) {
            if (goods.getType() != type) continue;
            return goods.getAmount();
        }
        return 0;
    }

    public final void setGoodsRequired(List<AbstractGoods> newGoodsRequired) {
        this.goodsRequired = newGoodsRequired;
    }

    public boolean needsGoodsToBuild() {
        return !this.goodsRequired.isEmpty();
    }

    public int getPopulationRequired() {
        return this.populationRequired;
    }

    public void setPopulationRequired(int newPopulationRequired) {
        this.populationRequired = newPopulationRequired;
    }

    public final List<Limit> getLimits() {
        return this.limits;
    }

    public final void setLimits(List<Limit> newLimits) {
        this.limits = newLimits;
    }

    public Map<String, Boolean> getAbilitiesRequired() {
        return this.requiredAbilities;
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String childName = in.getLocalName();
        if (Limit.getXMLElementTagName().equals(childName)) {
            if (this.limits == null) {
                this.limits = new ArrayList<Limit>();
            }
            Limit limit = new Limit(this.getSpecification());
            limit.readFromXML(in);
            if (limit.getLeftHandSide().getType() == null) {
                limit.getLeftHandSide().setType(this.getId());
            }
            this.limits.add(limit);
        } else if ("required-ability".equals(childName)) {
            String abilityId = in.getAttributeValue(null, "id");
            boolean value = BuildableType.getAttribute(in, "value", true);
            this.getAbilitiesRequired().put(abilityId, value);
            this.getSpecification().addAbility(abilityId);
            in.nextTag();
        } else if ("required-goods".equals(childName)) {
            GoodsType type = this.getSpecification().getGoodsType(in.getAttributeValue(null, "id"));
            int amount = this.getAttribute(in, "value", 0);
            AbstractGoods requiredGoods = new AbstractGoods(type, amount);
            if (amount > 0) {
                type.setBuildingMaterial(true);
                if (this.getGoodsRequired() == null) {
                    this.setGoodsRequired(new ArrayList<AbstractGoods>());
                }
                this.getGoodsRequired().add(requiredGoods);
            }
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.populationRequired > 1) {
            out.writeAttribute("required-population", Integer.toString(this.populationRequired));
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.limits != null) {
            for (Limit limit : this.limits) {
                limit.toXMLImpl(out);
            }
        }
        for (Map.Entry entry : this.getAbilitiesRequired().entrySet()) {
            out.writeStartElement("required-ability");
            out.writeAttribute("id", (String)entry.getKey());
            out.writeAttribute("value", Boolean.toString((Boolean)entry.getValue()));
            out.writeEndElement();
        }
        if (this.getGoodsRequired() != null) {
            for (AbstractGoods abstractGoods : this.getGoodsRequired()) {
                out.writeStartElement("required-goods");
                out.writeAttribute("id", abstractGoods.getType().getId());
                out.writeAttribute("value", Integer.toString(abstractGoods.getAmount()));
                out.writeEndElement();
            }
        }
    }
}

