/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Specification;
import org.w3c.dom.Element;

public final class Ability
extends Feature {
    public static final String ADD_TAX_TO_BELLS = "model.ability.addTaxToBells";
    private boolean value = true;

    public Ability(String id) {
        this(id, null, true);
    }

    public Ability(String id, boolean value) {
        this(id, null, value);
    }

    public Ability(String id, FreeColGameObjectType source, boolean value) {
        this.setId(id);
        this.setSource(source);
        this.value = value;
    }

    public Ability(Ability template) {
        super.copy(template);
        this.value = template.value;
    }

    public Ability(Element element) {
        this.readFromXMLElement(element);
    }

    public Ability(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.readFromXMLImpl(in, specification);
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean newValue) {
        this.value = newValue;
    }

    public int hashCode() {
        int hash = super.hashCode();
        return hash += this.value ? 1 : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Ability) {
            return super.equals(o) && this.value == ((Ability)o).value;
        }
        return false;
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, "ability");
    }

    public void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        super.readAttributes(in, specification);
        this.value = Ability.getAttribute(in, "value", true);
    }

    public void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("value", String.valueOf(this.value));
    }

    public static String getXMLElementTagName() {
        return "ability";
    }

    public String toString() {
        return this.getId() + (this.getSource() == null ? " " : " (" + this.getSource().getId() + ") ") + " " + this.value;
    }
}

