/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColTcFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mods {
    private static final Logger logger = Logger.getLogger(Mods.class.getName());
    public static final FileFilter MOD_FILTER = new FileFilter(){

        public boolean accept(File f) {
            String name = f.getName();
            if (".".equals(f.getName().substring(0, 1))) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            for (String ending : FreeColModFile.FILE_ENDINGS) {
                if (!name.endsWith(ending)) continue;
                return true;
            }
            return false;
        }
    };

    public static FreeColModFile getModFile(File file) {
        try {
            FreeColModFile fcmf = new FreeColModFile(file);
            return fcmf.getModDescriptor() == null ? null : fcmf;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static List<FreeColModFile> getDirectoryMods(File directory) {
        ArrayList<FreeColModFile> mods = new ArrayList<FreeColModFile>();
        if (directory != null && directory.isDirectory()) {
            for (File f : directory.listFiles(MOD_FILTER)) {
                FreeColModFile fcmf = Mods.getModFile(f);
                if (fcmf != null) {
                    mods.add(fcmf);
                    continue;
                }
                logger.warning("Failed to load mod from: " + f.getName());
            }
        }
        return mods;
    }

    public static List<FreeColModFile> getAllMods() {
        List<FreeColModFile> mods = Mods.getDirectoryMods(FreeCol.getUserModsDirectory());
        mods.addAll(Mods.getDirectoryMods(FreeCol.getStandardModsDirectory()));
        return mods;
    }

    public static List<FreeColTcFile> getRuleSets() {
        ArrayList<FreeColTcFile> result = new ArrayList<FreeColTcFile>();
        File directory = FreeColTcFile.getRulesDirectory();
        for (File dir : directory.listFiles()) {
            File modDescription;
            if (!dir.isDirectory() || !(modDescription = new File(dir, "mod.xml")).exists()) continue;
            result.add(new FreeColTcFile(dir));
        }
        return result;
    }
}

