/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import java.io.IOException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.resources.ResourceFactory;
import net.sf.freecol.common.resources.ResourceMapping;

public class FreeColTcFile
extends FreeColModFile {
    public static final String DIRECTORY = "rules";

    public FreeColTcFile(File file) {
        super(file);
    }

    public FreeColTcFile(String id) {
        super(new File(FreeColTcFile.getRulesDirectory(), id));
    }

    public ResourceMapping getResourceMapping() {
        ResourceMapping result;
        try {
            FreeColModFile.ModDescriptor info = this.getModDescriptor();
            if (info.getParent() != null) {
                FreeColTcFile parentTcData = new FreeColTcFile(info.getParent());
                result = parentTcData.getResourceMapping();
            } else {
                result = new ResourceMapping();
            }
            result.addAll(this.createRiverMapping());
            result.addAll(super.getResourceMapping());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    protected String[] getFileEndings() {
        return new String[]{".ftc", ".zip"};
    }

    public ResourceMapping createRiverMapping() {
        String path;
        ResourceMapping map = new ResourceMapping();
        String pathPrefix = "resources/images/river/";
        for (int index = 0; index < 81; ++index) {
            path = pathPrefix + "river" + index + ".png";
            map.add("river" + index, ResourceFactory.createResource(this.getURI(path)));
        }
        for (Map.Direction d : Map.Direction.longSides) {
            String key = "delta_" + (Object)((Object)d) + "_small";
            path = pathPrefix + key + ".png";
            map.add(key, ResourceFactory.createResource(this.getURI(path)));
            key = "delta_" + (Object)((Object)d) + "_large";
            path = pathPrefix + key + ".png";
            map.add(key, ResourceFactory.createResource(this.getURI(path)));
        }
        return map;
    }

    public static File getRulesDirectory() {
        return new File(FreeCol.getDataDirectory(), DIRECTORY);
    }
}

