/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.model.Specification;

public class FreeColModFile
extends FreeColDataFile {
    public static final String SPECIFICATION_FILE = "specification.xml";
    public static final String MOD_DESCRIPTOR_FILE = "mod.xml";
    public static final String[] FILE_ENDINGS = new String[]{".fmd", ".zip"};
    private String id;
    private final ModInfo modInfo;

    public FreeColModFile(File file) {
        super(file);
        this.id = file.getName();
        this.modInfo = new ModInfo(this.id);
    }

    public InputStream getSpecificationInputStream() throws IOException {
        return this.getInputStream(SPECIFICATION_FILE);
    }

    public Specification getSpecification() throws IOException {
        BufferedInputStream si = this.getInputStream(SPECIFICATION_FILE);
        Specification specification = new Specification(si);
        ((InputStream)si).close();
        return specification;
    }

    protected ModDescriptor getModDescriptor() throws IOException {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader in = null;
        try {
            ModDescriptor mi;
            in = xif.createXMLStreamReader(this.getModDescriptorInputStream());
            in.nextTag();
            ModDescriptor modDescriptor = mi = new ModDescriptor(in);
            return modDescriptor;
        }
        catch (XMLStreamException e) {
            IOException e2 = new IOException("XMLStreamException.");
            e2.initCause(e);
            throw e2;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private InputStream getModDescriptorInputStream() throws IOException {
        return this.getInputStream(MOD_DESCRIPTOR_FILE);
    }

    protected String[] getFileEndings() {
        return FILE_ENDINGS;
    }

    public String getId() {
        return this.id;
    }

    public ModInfo getModInfo() {
        return this.modInfo;
    }

    protected static class ModDescriptor {
        private final String parent;

        protected ModDescriptor(XMLStreamReader in) throws XMLStreamException {
            this.parent = in.getAttributeValue(null, "parent");
        }

        public String getParent() {
            return this.parent;
        }
    }

    public static class ModInfo {
        private final String id;

        private ModInfo(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return Messages.message("mod." + this.getId() + ".name");
        }

        public String getShortDescription() {
            return Messages.message("mod." + this.getId() + ".shortDescription");
        }

        public String toString() {
            return this.getName();
        }
    }
}

