/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.sound;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import net.sf.freecol.client.gui.sound.Playlist;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.PercentageOption;

public class SoundPlayer {
    private static final Logger logger = Logger.getLogger(SoundPlayer.class.getName());
    public static final int STANDARD_DELAY = 2000;
    private static final int MAXIMUM_FADE_MS = 7000;
    private static final int FADE_UPDATE_MS = 5;
    private ThreadGroup soundPlayerThreads = new ThreadGroup("soundPlayerThreads");
    private boolean soundPaused = false;
    private boolean soundStopped = true;
    private boolean fadeOut = false;
    private boolean multipleSounds;
    private SoundPlayerThread currentSoundPlayerThread;
    private boolean defaultPlayContinues;
    private final int defaultRepeatMode;
    private final int defaultPickMode;
    private Mixer mixer;
    private PercentageOption volume;

    public SoundPlayer(AudioMixerOption mixerOption, PercentageOption volume) {
        if (mixerOption == null) {
            throw new NullPointerException();
        }
        if (volume == null) {
            throw new NullPointerException();
        }
        this.volume = volume;
        this.multipleSounds = false;
        this.defaultPlayContinues = false;
        this.defaultRepeatMode = 1;
        this.defaultPickMode = 0;
        mixerOption.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                AudioMixerOption.MixerWrapper wrap = (AudioMixerOption.MixerWrapper)e.getNewValue();
                try {
                    SoundPlayer.this.mixer = AudioSystem.getMixer(wrap.getMixerInfo());
                }
                catch (Exception ex) {
                    logger.warning("** Audio Mixer unavailable: " + wrap);
                }
            }
        });
        this.mixer = AudioSystem.getMixer(mixerOption.getValue().getMixerInfo());
    }

    public Mixer getCurrentMixer() {
        return this.mixer;
    }

    public void play(Playlist playlist) {
        this.play(playlist, this.defaultPlayContinues, this.defaultRepeatMode, this.defaultPickMode, 0);
    }

    public void play(Playlist playlist, int delay) {
        this.play(playlist, this.defaultPlayContinues, this.defaultRepeatMode, this.defaultPickMode, delay);
    }

    public void playOnce(File file) {
        this.play(new Playlist(file), false, this.defaultRepeatMode, this.defaultPickMode, 0);
    }

    public void playOnce(Playlist playlist) {
        this.play(playlist, false, this.defaultRepeatMode, this.defaultPickMode, 0);
    }

    public void playOnce(Playlist playlist, int delay) {
        this.play(playlist, false, this.defaultRepeatMode, this.defaultPickMode, delay);
    }

    public void play(Playlist playlist, boolean playContinues, int repeatMode, int pickMode, int delay) {
        if (playlist != null) {
            this.currentSoundPlayerThread = new SoundPlayerThread(playlist, playContinues, repeatMode, pickMode, delay);
            this.currentSoundPlayerThread.start();
        } else {
            this.currentSoundPlayerThread = null;
        }
    }

    public void stop() {
        this.soundStopped = true;
        this.soundPaused = false;
    }

    public boolean isStopped() {
        return this.soundStopped;
    }

    public void pause() {
        this.soundPaused = true;
    }

    public void fade() {
        this.fadeOut = true;
    }

    public boolean isPaused() {
        return this.soundPaused;
    }

    class SoundPlayerThread
    extends Thread {
        private Playlist playlist;
        private boolean playContinues;
        private int repeatMode;
        private int pickMode;
        private boolean repeatSound;
        private int delay;

        public SoundPlayerThread(Playlist playlist, boolean playContinues, int repeatMode, int pickMode, int delay) {
            super(SoundPlayer.this.soundPlayerThreads, "FreeColClient:SoundPlayer");
            this.playlist = playlist;
            this.playContinues = playContinues;
            this.repeatMode = repeatMode;
            this.pickMode = pickMode;
            this.delay = delay;
        }

        private boolean shouldStopThread() {
            return !SoundPlayer.this.multipleSounds && SoundPlayer.this.currentSoundPlayerThread != this || SoundPlayer.this.fadeOut;
        }

        public void run() {
            this.playlist.setRepeatMode(this.repeatMode);
            this.playlist.setPickMode(this.pickMode);
            SoundPlayer.this.soundPaused = false;
            SoundPlayer.this.soundStopped = false;
            SoundPlayer.this.fadeOut = false;
            if (this.delay != 0) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            do {
                this.playSound(this.playlist.next());
                try {
                    Thread.sleep(222L);
                }
                catch (Exception e) {
                    break;
                }
            } while (this.playContinues && this.playlist.hasNext() && !SoundPlayer.this.soundStopped && !this.shouldStopThread());
        }

        public void playSound(File file) {
            try {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                bis.mark(1000);
                bis.skip(1L);
                bis.reset();
                AudioInputStream in = AudioSystem.getAudioInputStream(bis);
                if (in != null) {
                    AudioFormat baseFormat = in.getFormat();
                    AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), baseFormat.isBigEndian());
                    AudioInputStream din = AudioSystem.getAudioInputStream(decodedFormat, in);
                    this.rawplay(decodedFormat, din);
                    din.close();
                    in.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not play audio file: " + file.getName(), e);
            }
        }

        private void updateVolume(FloatControl c, int volume) {
            float gain = 20.0f * (float)Math.log10((double)volume / 100.0);
            c.setValue(gain);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rawplay(AudioFormat targetFormat, AudioInputStream din) throws IOException, LineUnavailableException {
            SourceDataLine line;
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, targetFormat);
            try {
                line = (SourceDataLine)SoundPlayer.this.mixer.getLine(info);
            }
            catch (IllegalArgumentException e) {
                throw new LineUnavailableException(e.toString());
            }
            if (line == null) {
                return;
            }
            line.open(targetFormat);
            line.start();
            FloatControl control = null;
            PropertyChangeListener pcl = null;
            if (line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                try {
                    control = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (control != null) {
                    final FloatControl c = control;
                    pcl = new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent e) {
                            int v = (Integer)e.getNewValue();
                            SoundPlayerThread.this.updateVolume(c, v);
                        }
                    };
                    SoundPlayer.this.volume.addPropertyChangeListener(pcl);
                    this.updateVolume(control, SoundPlayer.this.volume.getValue());
                }
            }
            byte[] data = new byte[8192];
            int read = 0;
            try {
                while (!SoundPlayer.this.soundStopped && !this.shouldStopThread()) {
                    try {
                        while (SoundPlayer.this.soundPaused) {
                            Thread.sleep(10L);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if ((read = din.read(data, 0, data.length)) < 0) {
                        break;
                    }
                    if (read <= 0) continue;
                    line.write(data, 0, read);
                }
            }
            finally {
                if (pcl != null) {
                    SoundPlayer.this.volume.removePropertyChangeListener(pcl);
                }
            }
            if (!SoundPlayer.this.soundStopped && control != null) {
                long ms = System.currentTimeMillis() + 5L;
                long fadeStop = System.currentTimeMillis() + 7000L;
                while (!SoundPlayer.this.soundStopped && System.currentTimeMillis() < fadeStop && (read = din.read(data, 0, data.length)) >= 0) {
                    if (read > 0) {
                        line.write(data, 0, read);
                    }
                    if (System.currentTimeMillis() <= ms) continue;
                    float currentGain = control.getValue();
                    float newGain = currentGain - 1.0f;
                    if (newGain < control.getMinimum()) {
                        newGain = control.getMinimum();
                    }
                    control.setValue(newGain);
                    ms = System.currentTimeMillis() + 5L;
                }
            }
            line.drain();
            line.stop();
            line.close();
        }
    }
}

