/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.networking.StatisticsMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatisticsPanel
extends FreeColPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(StatisticsPanel.class.getName());

    public StatisticsPanel(Canvas parent) {
        super(parent, new BorderLayout());
        StatisticsMessage serverStatistics = this.getController().getServerStatistics();
        StatisticsMessage clientStatistics = new StatisticsMessage(this.getGame(), null);
        JPanel header = new JPanel();
        this.add((Component)header, "North");
        header.add((Component)new JLabel("Statistics"), Float.valueOf(0.5f));
        JPanel statsPanel = new JPanel(new GridLayout(1, 2));
        JScrollPane scrollPane = new JScrollPane(statsPanel, 20, 31);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
        statsPanel.add(this.displayStatsMessage("Client", clientStatistics));
        statsPanel.add(this.displayStatsMessage("Server", serverStatistics));
        this.add((Component)this.okButton, "South");
        this.setSize(this.getPreferredSize());
    }

    private JPanel displayStatsMessage(String title, StatisticsMessage statistics) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(title));
        Box b = new Box(1);
        panel.add(b);
        b.add(this.createStatsTable("Memory", statistics.getMemoryStatistics()));
        b.add(this.createStatsTable("Game", statistics.getGameStatistics()));
        if (statistics.getAIStatistics() != null) {
            b.add(this.createStatsTable("AI", statistics.getAIStatistics()));
        } else {
            b.add(new JLabel());
        }
        return panel;
    }

    private JPanel createStatsTable(String title, HashMap<String, Long> data) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JLabel(title), "North");
        StatisticsModel model = new StatisticsModel();
        model.setData(data);
        JTable table = new JTable(model);
        table.setAutoCreateColumnsFromModel(true);
        table.setAutoResizeMode(4);
        JScrollPane scrollPane = new JScrollPane(table);
        table.addNotify();
        scrollPane.getViewport().setOpaque(false);
        scrollPane.getColumnHeader().setOpaque(false);
        panel.add((Component)scrollPane, "Center");
        panel.setPreferredSize(new Dimension(300, (data.size() + 2) * 17));
        return panel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StatisticsModel
    extends AbstractTableModel {
        private static final int NAME_COLUMN = 0;
        private static final int VALUE_COLUMN = 1;
        private final String[] columnNames = new String[]{"Name", "Value"};
        private Object[][] data = null;

        public void setData(HashMap<String, Long> statsData) {
            this.data = new Object[2][statsData.size()];
            int i = 0;
            for (String s : statsData.keySet()) {
                this.data[0][i] = s;
                this.data[1][i] = statsData.get(s);
                ++i;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.data[0].length;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this.getRowCount() && column < this.getColumnCount() && row >= 0 && column >= 0) {
                switch (column) {
                    case 0: {
                        return this.data[0][row];
                    }
                    case 1: {
                        return this.data[1][row];
                    }
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }
    }
}

