/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectDestinationDialog
extends FreeColDialog<Location>
implements ActionListener,
ChangeListener,
ItemListener {
    private static final Logger logger = Logger.getLogger(SelectDestinationDialog.class.getName());
    private static boolean showOnlyMyColonies = true;
    private static Comparator<Destination> destinationComparator = null;
    private final JCheckBox onlyMyColoniesBox;
    private final JComboBox comparatorBox;
    private final JList destinationList;
    private final List<Destination> destinations = new ArrayList<Destination>();

    public SelectDestinationDialog(Canvas parent, Unit unit) {
        super(parent);
        final Settlement inSettlement = unit.getSettlement();
        ArrayList<GoodsType> goodsTypeList = new ArrayList<GoodsType>();
        for (Goods goods : unit.getGoodsList()) {
            goodsTypeList.add(goods.getType());
        }
        final ArrayList<GoodsType> goodsTypes = goodsTypeList;
        this.getGame().getMap().search(unit, unit.getTile(), new GoalDecider(){

            public PathNode getGoal() {
                return null;
            }

            public boolean check(Unit u, PathNode p) {
                Settlement settlement = p.getTile().getSettlement();
                if (settlement != null && settlement != inSettlement) {
                    String extras = settlement.getOwner() != u.getOwner() ? SelectDestinationDialog.this.getExtras(u, settlement, goodsTypes) : "";
                    SelectDestinationDialog.this.destinations.add(new Destination(settlement, p.getTurns(), extras));
                }
                return false;
            }

            public boolean hasSubGoals() {
                return false;
            }
        }, CostDeciders.avoidIllegal(), Integer.MAX_VALUE);
        if (destinationComparator == null) {
            destinationComparator = new DestinationComparator(this.getMyPlayer());
        }
        Collections.sort(this.destinations, destinationComparator);
        if (unit.isNaval() && unit.getOwner().canMoveToEurope()) {
            int turns;
            PathNode path = unit.findPathToEurope();
            int n = path != null ? unit.getSailTurns() + path.getTotalTurns() : (turns = unit.getTile() != null && (unit.getTile().canMoveToEurope() || unit.getTile().isAdjacentToMapEdge()) ? unit.getSailTurns() : -1);
            if (turns >= 0) {
                Europe europe = this.getMyPlayer().getEurope();
                this.destinations.add(0, new Destination(europe, turns, this.getExtras(unit, europe, goodsTypes)));
            }
        }
        MigLayout layout = new MigLayout("wrap 1, fill", "[align center]", "");
        this.setLayout((LayoutManager)layout);
        JLabel header = new JLabel(Messages.message("selectDestination.text"));
        header.setFont(smallHeaderFont);
        this.add(header);
        DefaultListModel model = new DefaultListModel();
        this.destinationList = new JList(model);
        this.filterDestinations();
        this.destinationList.setCellRenderer(new LocationRenderer());
        this.destinationList.setFixedCellHeight(48);
        AbstractAction selectAction = new AbstractAction(Messages.message("ok")){

            public void actionPerformed(ActionEvent e) {
                Destination d = (Destination)SelectDestinationDialog.this.destinationList.getSelectedValue();
                if (d != null) {
                    SelectDestinationDialog.this.setResponse(d.location);
                }
                SelectDestinationDialog.this.getCanvas().remove(SelectDestinationDialog.this);
            }
        };
        AbstractAction quitAction = new AbstractAction(Messages.message("selectDestination.cancel")){

            public void actionPerformed(ActionEvent e) {
                SelectDestinationDialog.this.getCanvas().remove(SelectDestinationDialog.this);
            }
        };
        this.destinationList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "select");
        this.destinationList.getActionMap().put("select", selectAction);
        this.destinationList.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "quit");
        this.destinationList.getActionMap().put("quit", quitAction);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Destination d = (Destination)SelectDestinationDialog.this.destinationList.getSelectedValue();
                    if (d != null) {
                        SelectDestinationDialog.this.setResponse(d.location);
                    }
                    SelectDestinationDialog.this.getCanvas().remove(SelectDestinationDialog.this);
                }
            }
        };
        this.destinationList.addMouseListener(mouseListener);
        JScrollPane listScroller = new JScrollPane(this.destinationList);
        listScroller.setPreferredSize(new Dimension(250, 250));
        this.add((Component)listScroller, "newline 30, growx, growy");
        this.onlyMyColoniesBox = new JCheckBox(Messages.message("selectDestination.onlyMyColonies"), showOnlyMyColonies);
        this.onlyMyColoniesBox.addChangeListener(this);
        this.add((Component)this.onlyMyColoniesBox, "left");
        this.comparatorBox = new JComboBox<String>(new String[]{Messages.message("selectDestination.sortByOwner"), Messages.message("selectDestination.sortByName"), Messages.message("selectDestination.sortByDistance")});
        this.comparatorBox.addItemListener(this);
        if (destinationComparator instanceof DestinationComparator) {
            this.comparatorBox.setSelectedIndex(0);
        } else if (destinationComparator instanceof NameComparator) {
            this.comparatorBox.setSelectedIndex(1);
        } else if (destinationComparator instanceof DistanceComparator) {
            this.comparatorBox.setSelectedIndex(2);
        }
        this.add((Component)this.comparatorBox, "left");
        this.cancelButton.setAction(quitAction);
        this.okButton.setAction(selectAction);
        this.add((Component)this.okButton, "newline 30, split 2, tag ok");
        this.add((Component)this.cancelButton, "tag cancel");
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void requestFocus() {
        this.destinationList.requestFocus();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        showOnlyMyColonies = this.onlyMyColoniesBox.isSelected();
        this.filterDestinations();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        switch (this.comparatorBox.getSelectedIndex()) {
            default: {
                destinationComparator = new DestinationComparator(this.getMyPlayer());
                break;
            }
            case 1: {
                destinationComparator = new NameComparator();
                break;
            }
            case 2: {
                destinationComparator = new DistanceComparator();
            }
        }
        Collections.sort(this.destinations, destinationComparator);
        this.filterDestinations();
    }

    private String getExtras(Unit unit, Location loc, List<GoodsType> goodsTypes) {
        IndianSettlement indianSettlement;
        UnitType skill;
        if (loc instanceof Europe && !goodsTypes.isEmpty()) {
            Market market = unit.getOwner().getMarket();
            ArrayList<String> sales = new ArrayList<String>();
            for (GoodsType goodsType : goodsTypes) {
                sales.add(Messages.message(goodsType.getNameKey()) + " " + Integer.toString(market.getSalePrice(goodsType, 1)));
            }
            if (!sales.isEmpty()) {
                return "[" + Utils.join(", ", sales) + "]";
            }
        } else if (loc instanceof Settlement && !goodsTypes.isEmpty()) {
            ArrayList<String> sales = new ArrayList<String>();
            for (GoodsType goodsType : goodsTypes) {
                String sale = unit.getOwner().getLastSaleString((Settlement)loc, goodsType);
                if (sale == null) continue;
                sales.add(Messages.message(goodsType.getNameKey()) + " " + sale);
            }
            if (!sales.isEmpty()) {
                return "[" + Utils.join(", ", sales) + "]";
            }
        } else if (loc instanceof IndianSettlement && (skill = (indianSettlement = (IndianSettlement)loc).getLearnableSkill()) != null && unit.getType().canBeUpgraded(skill, UnitTypeChange.ChangeType.NATIVES)) {
            return "[" + Messages.message(skill.getNameKey()) + "]";
        }
        return "";
    }

    private void filterDestinations() {
        DefaultListModel model = (DefaultListModel)this.destinationList.getModel();
        Object selected = this.destinationList.getSelectedValue();
        model.clear();
        for (Destination d : this.destinations) {
            if (showOnlyMyColonies) {
                if (!(d.location instanceof Europe) && (!(d.location instanceof Colony) || ((Colony)d.location).getOwner() != this.getMyPlayer())) continue;
                model.addElement(d);
                continue;
            }
            model.addElement(d);
        }
        this.destinationList.setSelectedValue(selected, true);
        if (this.destinationList.getSelectedIndex() == -1) {
            this.destinationList.setSelectedIndex(0);
        }
    }

    public int compareNames(Location dest1, Location dest2) {
        String name1 = "";
        if (dest1 instanceof Settlement) {
            name1 = ((Settlement)dest1).getName();
        } else if (dest1 instanceof Europe) {
            return -1;
        }
        String name2 = "";
        if (dest2 instanceof Settlement) {
            name2 = ((Settlement)dest2).getName();
        } else if (dest2 instanceof Europe) {
            return 1;
        }
        return name1.compareTo(name2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DistanceComparator
    implements Comparator<Destination> {
        private DistanceComparator() {
        }

        @Override
        public int compare(Destination choice1, Destination choice2) {
            int result = choice1.turns - choice2.turns;
            if (result == 0) {
                return SelectDestinationDialog.this.compareNames(choice1.location, choice2.location);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NameComparator
    implements Comparator<Destination> {
        private NameComparator() {
        }

        @Override
        public int compare(Destination choice1, Destination choice2) {
            return SelectDestinationDialog.this.compareNames(choice1.location, choice2.location);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DestinationComparator
    implements Comparator<Destination> {
        private Player owner;

        public DestinationComparator(Player player) {
            this.owner = player;
        }

        @Override
        public int compare(Destination choice1, Destination choice2) {
            Location dest1 = choice1.location;
            Location dest2 = choice2.location;
            int score1 = 100;
            if (dest1 instanceof Europe) {
                score1 = 10;
            } else if (dest1 instanceof Colony) {
                score1 = ((Colony)dest1).getOwner() == this.owner ? 20 : 30;
            } else if (dest1 instanceof IndianSettlement) {
                score1 = 40;
            }
            int score2 = 100;
            if (dest2 instanceof Europe) {
                score2 = 10;
            } else if (dest2 instanceof Colony) {
                score2 = ((Colony)dest2).getOwner() == this.owner ? 20 : 30;
            } else if (dest2 instanceof IndianSettlement) {
                score2 = 40;
            }
            if (score1 == score2) {
                return SelectDestinationDialog.this.compareNames(dest1, dest2);
            }
            return score1 - score2;
        }
    }

    private class LocationRenderer
    extends FreeColComboBoxRenderer {
        private LocationRenderer() {
        }

        public void setLabelValues(JLabel label, Object value) {
            Destination d = (Destination)value;
            Location location = d.location;
            String name = "";
            if (location instanceof Europe) {
                Europe europe = (Europe)location;
                name = Messages.message(europe.getNameKey());
                label.setIcon(new ImageIcon(SelectDestinationDialog.this.getLibrary().getCoatOfArmsImage(europe.getOwner().getNation()).getScaledInstance(-1, 48, 4)));
            } else if (location instanceof Settlement) {
                Settlement settlement = (Settlement)location;
                name = settlement.getName();
                label.setIcon(new ImageIcon(SelectDestinationDialog.this.getLibrary().getSettlementImage(settlement).getScaledInstance(64, -1, 4)));
            }
            label.setText(Messages.message(StringTemplate.template("selectDestination.destinationTurns").addName("%location%", name).addAmount("%turns%", d.turns).addName("%extras%", d.extras)));
        }
    }

    private class Destination {
        public Location location;
        public int turns;
        public String extras;

        public Destination(Location location, int turns, String extras) {
            this.location = location;
            this.turns = turns;
            this.extras = extras;
        }
    }
}

