/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;

public final class ReportForeignAffairPanel
extends ReportPanel {
    public ReportForeignAffairPanel(Canvas parent) {
        super(parent, Messages.message("reportForeignAction.name"));
        this.reportPanel.removeAll();
        this.reportPanel.setLayout((LayoutManager)new MigLayout("wrap 2", "[]push[]"));
        for (Player enemy : this.getGame().getLiveEuropeanPlayers()) {
            NationSummary ns = this.getController().getNationSummary(enemy);
            if (ns == null) continue;
            JPanel enemyPanel = new JPanel((LayoutManager)new MigLayout("gapy 0", "[][]20[align right]0[]", ""));
            enemyPanel.setOpaque(false);
            JLabel coatLabel = new JLabel();
            ImageIcon coatOfArms = this.getLibrary().getCoatOfArmsImageIcon(enemy.getNation());
            if (coatOfArms != null) {
                coatLabel.setIcon(coatOfArms);
            }
            enemyPanel.add((Component)coatLabel, "spany, aligny top");
            enemyPanel.add((Component)this.localizedLabel(enemy.getNationName()), "wrap 12");
            enemyPanel.add((Component)new JLabel(Messages.message("report.stance")), "newline");
            enemyPanel.add(new JLabel(Messages.message(Messages.getStanceAsString(ns.getStance()))));
            enemyPanel.add((Component)new JLabel(Messages.message("report.numberOfColonies")), "newline");
            enemyPanel.add(new JLabel(ns.getNumberOfSettlements()));
            enemyPanel.add((Component)new JLabel(Messages.message("report.numberOfUnits")), "newline");
            enemyPanel.add(new JLabel(ns.getNumberOfUnits()));
            enemyPanel.add((Component)new JLabel(Messages.message("report.militaryStrength")), "newline");
            enemyPanel.add(new JLabel(ns.getMilitaryStrength()));
            enemyPanel.add((Component)new JLabel(Messages.message("report.navalStrength")), "newline");
            enemyPanel.add(new JLabel(ns.getNavalStrength()));
            enemyPanel.add((Component)new JLabel(Messages.message("goldTitle")), "newline");
            enemyPanel.add(new JLabel(Integer.toString(ns.getGold())));
            String s = ns.getFoundingFathers();
            if (s != null) {
                enemyPanel.add((Component)new JLabel(Messages.message("report.continentalCongress.title")), "newline 8");
                enemyPanel.add(new JLabel(s));
            }
            if ((s = ns.getTax()) != null) {
                enemyPanel.add((Component)new JLabel(Messages.message("tax")), "newline");
                enemyPanel.add(new JLabel(s));
                enemyPanel.add(new JLabel("%"));
            }
            if ((s = ns.getSoL()) != null) {
                enemyPanel.add((Component)new JLabel(Messages.message("report.sonsOfLiberty")), "newline");
                enemyPanel.add(new JLabel(s));
                enemyPanel.add(new JLabel("%"));
            }
            this.reportPanel.add(enemyPanel);
        }
        this.reportPanel.add((Component)ReportForeignAffairPanel.getDefaultTextArea(Messages.message("report.foreignAffairs.notice"), 40), "newline 20, span 8");
        this.reportPanel.doLayout();
    }
}

