/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public final class InfoPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(InfoPanel.class.getName());
    private static final int PANEL_WIDTH = 256;
    private static final int PANEL_HEIGHT = 128;
    private final EndTurnPanel endTurnPanel = new EndTurnPanel();
    private final UnitInfoPanel unitInfoPanel;
    private final TileInfoPanel tileInfoPanel = new TileInfoPanel();
    private final JPanel mapEditorPanel;

    public InfoPanel(FreeColClient freeColClient) {
        super(freeColClient.getCanvas());
        this.unitInfoPanel = new UnitInfoPanel();
        this.setLayout(null);
        int internalPanelTop = 0;
        int internalPanelHeight = 128;
        Image skin = ResourceManager.getImage("InfoPanel.skin");
        if (skin == null) {
            this.setSize(256, 128);
        } else {
            this.setBorder(null);
            this.setSize(skin.getWidth(null), skin.getHeight(null));
            this.setOpaque(false);
            internalPanelTop = 75;
            internalPanelHeight = 100;
        }
        this.mapEditorPanel = new JPanel(null);
        this.mapEditorPanel.setSize(130, 100);
        this.mapEditorPanel.setOpaque(false);
        this.add(this.unitInfoPanel, internalPanelTop, internalPanelHeight);
        this.add(this.endTurnPanel, internalPanelTop, internalPanelHeight);
        this.add(this.tileInfoPanel, internalPanelTop, internalPanelHeight);
        this.add(this.mapEditorPanel, internalPanelTop, internalPanelHeight);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GUI gui = InfoPanel.this.getClient().getGUI();
                Unit activeUnit = gui.getActiveUnit();
                if (activeUnit != null && activeUnit.getTile() != null) {
                    gui.setFocus(activeUnit.getTile());
                }
            }
        });
    }

    private void add(JPanel panel, int internalPanelTop, int internalPanelHeight) {
        panel.setVisible(false);
        panel.setLocation((this.getWidth() - panel.getWidth()) / 2, internalPanelTop + (internalPanelHeight - panel.getHeight()) / 2);
        this.add(panel);
    }

    public void update(Unit unit) {
        this.unitInfoPanel.update(unit);
    }

    public void update(MapEditorTransformPanel.MapTransform mapTransform) {
        JPanel p;
        if (mapTransform != null && (p = mapTransform.getDescriptionPanel()) != null) {
            p.setOpaque(false);
            Dimension d = p.getPreferredSize();
            p.setBounds(0, (this.mapEditorPanel.getHeight() - d.height) / 2, this.mapEditorPanel.getWidth(), d.height);
            this.mapEditorPanel.removeAll();
            this.mapEditorPanel.add((Component)p, "Center");
            this.mapEditorPanel.validate();
            this.mapEditorPanel.revalidate();
            this.mapEditorPanel.repaint();
        }
    }

    public void update(Tile tile) {
        this.tileInfoPanel.update(tile);
    }

    public Unit getUnit() {
        return this.unitInfoPanel.getUnit();
    }

    public Tile getTile() {
        return this.tileInfoPanel.getTile();
    }

    public void paintComponent(Graphics graphics) {
        int viewMode = this.getClient().getGUI().getViewMode().getView();
        if (!this.getClient().isMapEditor()) {
            if (this.mapEditorPanel.isVisible()) {
                this.mapEditorPanel.setVisible(false);
            }
            switch (viewMode) {
                case 0: {
                    if (this.unitInfoPanel.getUnit() != null) {
                        if (!this.unitInfoPanel.isVisible()) {
                            this.unitInfoPanel.setVisible(true);
                            this.endTurnPanel.setVisible(false);
                        }
                    } else if (this.getMyPlayer() != null && !this.getMyPlayer().hasNextActiveUnit() && !this.endTurnPanel.isVisible()) {
                        this.endTurnPanel.setVisible(true);
                        this.unitInfoPanel.setVisible(false);
                    }
                    this.tileInfoPanel.setVisible(false);
                    break;
                }
                case 1: {
                    this.unitInfoPanel.setVisible(false);
                    this.endTurnPanel.setVisible(false);
                    this.tileInfoPanel.setVisible(true);
                }
            }
        } else if (!this.mapEditorPanel.isVisible()) {
            this.mapEditorPanel.setVisible(true);
            this.unitInfoPanel.setVisible(false);
            this.endTurnPanel.setVisible(false);
            this.tileInfoPanel.setVisible(false);
        }
        Image skin = ResourceManager.getImage("InfoPanel.skin");
        if (skin != null) {
            graphics.drawImage(skin, 0, 0, null);
        }
        super.paintComponent(graphics);
    }

    public class EndTurnPanel
    extends JPanel {
        public EndTurnPanel() {
            super((LayoutManager)new MigLayout("wrap 1, center", "[center]", ""));
            String labelString = Messages.message("infoPanel.endTurnPanel.text");
            int width = this.getFontMetrics(this.getFont()).stringWidth(labelString);
            if (width > 150) {
                InfoPanel.this.getCanvas().getGUI();
                int index = GUI.getBreakingPoint(labelString);
                if (index > 0) {
                    this.add(new JLabel(labelString.substring(0, index)));
                    this.add(new JLabel(labelString.substring(index + 1)));
                } else {
                    this.add(new JLabel(labelString));
                }
            } else {
                this.add(new JLabel(labelString));
            }
            this.add(new JButton(InfoPanel.this.getClient().getActionManager().getFreeColAction("endTurnAction")));
            this.setOpaque(false);
            this.setSize(this.getPreferredSize());
        }
    }

    public class UnitInfoPanel
    extends JPanel {
        private Unit unit;

        public UnitInfoPanel() {
            super((LayoutManager)new MigLayout("wrap 6, fill, gap 0 0", "", ""));
            this.setSize(226, 100);
            this.setOpaque(false);
        }

        public void update(Unit unit) {
            this.unit = unit;
            this.removeAll();
            if (unit != null) {
                this.add((Component)new JLabel(InfoPanel.this.getLibrary().getUnitImageIcon(unit)), "spany, gapafter 5px");
                String name = Messages.message(Messages.getLabel(unit));
                int index = name.indexOf(" (");
                if (index < 0) {
                    this.add((Component)new JLabel(name), "span");
                } else {
                    this.add((Component)new JLabel(name.substring(0, index)), "span");
                    this.add((Component)new JLabel(name.substring(index + 1)), "span");
                }
                this.add((Component)new JLabel(Messages.message("moves") + " " + unit.getMovesAsString()), "span");
                if (unit.canCarryTreasure()) {
                    this.add((Component)new JLabel(unit.getTreasureAmount() + " " + Messages.message("gold")), "span");
                } else if (unit.isCarrier()) {
                    for (Goods goods : unit.getGoodsList()) {
                        JLabel goodsLabel = new JLabel(InfoPanel.this.getLibrary().getScaledGoodsImageIcon(goods.getType(), 0.66f));
                        goodsLabel.setToolTipText(Messages.message(StringTemplate.template("model.goods.goodsAmount").addAmount("%amount%", goods.getAmount()).add("%goods%", goods.getNameKey())));
                        this.add(goodsLabel);
                    }
                    for (Unit carriedUnit : unit.getUnitList()) {
                        ImageIcon unitIcon = InfoPanel.this.getLibrary().getUnitImageIcon(carriedUnit, 0.5);
                        JLabel unitLabel = new JLabel(unitIcon);
                        unitLabel.setToolTipText(Messages.message(carriedUnit.getLabel()));
                        this.add(unitLabel);
                    }
                } else {
                    for (EquipmentType equipment : unit.getEquipment().keySet()) {
                        for (AbstractGoods goods : equipment.getGoodsRequired()) {
                            int amount = goods.getAmount() * unit.getEquipment().getCount(equipment);
                            JLabel equipmentLabel = new JLabel(Integer.toString(amount), InfoPanel.this.getLibrary().getScaledGoodsImageIcon(goods.getType(), 0.66f), 0);
                            equipmentLabel.setToolTipText(Messages.message(StringTemplate.template("model.goods.goodsAmount").addAmount("%amount%", amount).add("%goods%", goods.getNameKey())));
                            this.add(equipmentLabel);
                        }
                    }
                }
            }
            this.revalidate();
            this.repaint();
        }

        public Unit getUnit() {
            return this.unit;
        }
    }

    public class TileInfoPanel
    extends JPanel {
        private Tile tile;
        private Font font;

        public TileInfoPanel() {
            super(null);
            this.font = new JLabel().getFont().deriveFont(9.0f);
            this.setSize(226, 100);
            this.setOpaque(false);
            this.setLayout((LayoutManager)new MigLayout("fill, wrap 2, gap 0 0", "", "[][][][][nogrid]"));
        }

        public void update(Tile tile) {
            this.tile = tile;
            this.removeAll();
            if (tile != null) {
                int width = InfoPanel.this.getLibrary().getTerrainImageWidth(tile.getType());
                int height = InfoPanel.this.getLibrary().getTerrainImageHeight(tile.getType());
                BufferedImage image = new BufferedImage(width, height, 2);
                InfoPanel.this.getClient().getGUI().displayTerrain(image.createGraphics(), tile);
                if (tile.isExplored()) {
                    StringTemplate items = StringTemplate.label(", ");
                    items.add(tile.getNameKey());
                    for (TileImprovement tileImprovement : tile.getCompletedTileImprovements()) {
                        items.add(tileImprovement.getType().getDescriptionKey());
                    }
                    this.add((Component)new JLabel(Messages.message(items)), "span, align center");
                    this.add((Component)new JLabel(new ImageIcon(image)), "span 1 3");
                    if (tile.getOwner() == null) {
                        this.add(new JLabel());
                    } else {
                        JLabel ownerLabel = InfoPanel.this.localizedLabel(tile.getOwner().getNationName());
                        ownerLabel.setFont(this.font);
                        this.add(ownerLabel);
                    }
                    int defenceBonus = (int)tile.getType().getFeatureContainer().applyModifier(100.0f, "model.modifier.defence") - 100;
                    JLabel defenceLabel = new JLabel(Messages.message("colopedia.terrain.defenseBonus") + " " + defenceBonus + "%");
                    defenceLabel.setFont(this.font);
                    this.add(defenceLabel);
                    JLabel moveLabel = new JLabel(Messages.message("colopedia.terrain.movementCost") + " " + String.valueOf(tile.getType().getBasicMoveCost() / 3));
                    moveLabel.setFont(this.font);
                    this.add(moveLabel);
                    List<AbstractGoods> production = tile.getType().getProduction();
                    for (AbstractGoods goods : production) {
                        JLabel goodsLabel = new JLabel(String.valueOf(tile.potential(goods.getType(), null)), InfoPanel.this.getLibrary().getScaledGoodsImageIcon(goods.getType(), 0.5), 4);
                        goodsLabel.setToolTipText(Messages.message(goods.getType().getNameKey()));
                        goodsLabel.setFont(this.font);
                        this.add(goodsLabel);
                    }
                } else {
                    this.add((Component)new JLabel(Messages.message("unexplored")), "span, align center");
                    this.add((Component)new JLabel(new ImageIcon(image)), "spany");
                }
                this.revalidate();
                this.repaint();
            }
        }

        public Tile getTile() {
            return this.tile;
        }
    }
}

