/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.event.ActionEvent;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.BooleanOptionUI;
import net.sf.freecol.client.gui.panel.OptionsDialog;

public final class GameOptionsDialog
extends OptionsDialog {
    public static final String OPTION_GROUP_ID = "gameOptions";

    public GameOptionsDialog(Canvas parent, boolean editable, boolean loadCustomOptions) {
        super(parent, editable);
        if (editable && loadCustomOptions) {
            this.loadCustomOptions();
        }
        this.initialize(this.getSpecification().getOptionGroup(OPTION_GROUP_ID), Messages.message(OPTION_GROUP_ID), null);
        if (editable && this.getClient().isSingleplayer()) {
            BooleanOptionUI comp = (BooleanOptionUI)this.getOptionUI().getOptionUI("model.option.victoryDefeatHumans");
            comp.setValue(false);
            comp.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
        String command = event.getActionCommand();
        if ("OK".equals(command) && !this.getClient().isMapEditor()) {
            this.getClient().getPreGameController().sendGameOptions();
        }
    }

    public String getDefaultFileName() {
        return "game_options.xml";
    }

    public String getOptionGroupId() {
        return OPTION_GROUP_ID;
    }
}

