/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventPanel
extends FreeColDialog<Boolean> {
    private static final Logger logger = Logger.getLogger(EventPanel.class.getName());

    public EventPanel(Canvas parent, Canvas.EventType type) {
        super(parent);
        this.setLayout((LayoutManager)new MigLayout("wrap 1", "[center]", "[]20"));
        String text = null;
        String image = null;
        switch (type) {
            case FIRST_LANDING: {
                image = "EventImage.firstLanding";
                text = Messages.message(StringTemplate.template("event.firstLanding").addName("%name%", Messages.getNewLandName(this.getMyPlayer())));
                break;
            }
            case MEETING_EUROPEANS: {
                image = "EventImage.meetingEuropeans";
                text = Messages.message("event.meetingEuropeans");
                break;
            }
            case MEETING_NATIVES: {
                image = "EventImage.meetingNatives";
                text = Messages.message("event.meetingNatives");
                break;
            }
            case MEETING_AZTEC: {
                image = "EventImage.meetingAztec";
                text = Messages.message("event.meetingAztec");
                break;
            }
            case MEETING_INCA: {
                image = "EventImage.meetingInca";
                text = Messages.message("event.meetingInca");
                break;
            }
            case DISCOVER_PACIFIC: {
                image = "EventImage.discoverPacific";
                text = Messages.message("model.region.pacific.discover");
                break;
            }
            default: {
                this.setResponse(Boolean.FALSE);
            }
        }
        JLabel header = new JLabel(text);
        header.setFont(mediumHeaderFont);
        JLabel imageLabel = new JLabel(new ImageIcon(ResourceManager.getImage(image)));
        this.add(header);
        this.add(imageLabel);
        this.add((Component)this.okButton, "tag ok");
        this.setSize(this.getPreferredSize());
    }
}

