/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChoiceDialog<T>
extends FreeColDialog<T> {
    private static final Logger logger = Logger.getLogger(ChoiceDialog.class.getName());
    private JList choiceList;

    public ChoiceDialog(Canvas parent, String text, String cancelText, List<ChoiceItem<T>> choices) {
        super(parent);
        MigLayout layout = new MigLayout("wrap 1, fill", "[align center]", "[]30[]30[]");
        this.setLayout((LayoutManager)layout);
        this.add(ChoiceDialog.getDefaultTextArea(text));
        DefaultListModel<ChoiceItem<T>> model = new DefaultListModel<ChoiceItem<T>>();
        for (ChoiceItem<T> item : choices) {
            model.addElement(item);
        }
        this.choiceList = new JList(model);
        JScrollPane listScroller = new JScrollPane(this.choiceList);
        listScroller.setPreferredSize(new Dimension(250, 250));
        AbstractAction selectAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ChoiceDialog.this.setResponse(((ChoiceItem)ChoiceDialog.this.choiceList.getSelectedValue()).getObject());
            }
        };
        AbstractAction quitAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ChoiceDialog.this.getCanvas().remove(ChoiceDialog.this);
            }
        };
        this.choiceList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "select");
        this.choiceList.getActionMap().put("select", selectAction);
        this.choiceList.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "quit");
        this.choiceList.getActionMap().put("quit", quitAction);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ChoiceDialog.this.setResponse(((ChoiceItem)ChoiceDialog.this.choiceList.getSelectedValue()).getObject());
                }
            }
        };
        this.choiceList.addMouseListener(mouseListener);
        this.add((Component)listScroller, "growx, growy");
        if (cancelText != null) {
            this.cancelButton.setText(cancelText);
            this.add((Component)this.okButton, "split 2, tag ok");
            this.add((Component)this.cancelButton, "tag cancel");
        } else {
            this.add((Component)this.okButton, "tag ok");
        }
        this.okButton.addActionListener(this);
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void requestFocus() {
        this.choiceList.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ChoiceItem item;
        String command = event.getActionCommand();
        if ("OK".equals(command) && (item = (ChoiceItem)this.choiceList.getSelectedValue()) != null) {
            this.setResponse(item.getObject());
        } else {
            super.actionPerformed(event);
        }
    }
}

