/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.PercentageOption;

public final class PercentageOptionUI
extends JSlider
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(PercentageOptionUI.class.getName());
    private final PercentageOption option;
    private int originalValue;

    public PercentageOptionUI(final PercentageOption option, boolean editable) {
        this.option = option;
        this.originalValue = option.getValue();
        String name = Messages.getName(option);
        String description = Messages.getShortDescription(option);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Messages.getName(option)));
        this.setModel(new DefaultBoundedRangeModel(option.getValue(), 0, 0, 100));
        this.setOrientation(0);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(new Integer(0), new JLabel("0 %"));
        labels.put(new Integer(25), new JLabel("25 %"));
        labels.put(new Integer(50), new JLabel("50 %"));
        labels.put(new Integer(75), new JLabel("75 %"));
        labels.put(new Integer(100), new JLabel("100 %"));
        this.setLabelTable(labels);
        this.setValue(option.getValue());
        this.setPaintLabels(true);
        this.setMajorTickSpacing(5);
        this.setExtent(0);
        this.setPaintTicks(true);
        this.setSnapToTicks(false);
        this.setPreferredSize(new Dimension(500, 50));
        this.setToolTipText(description != null ? description : name);
        this.setEnabled(editable);
        this.setOpaque(false);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (option.isPreviewEnabled() && option.getValue().intValue() != PercentageOptionUI.this.getValue()) {
                    option.setValue(PercentageOptionUI.this.getValue());
                }
            }
        });
        option.addPropertyChangeListener(this);
        this.setOpaque(false);
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        int value;
        if (event.getPropertyName().equals("value") && (value = ((Integer)event.getNewValue()).intValue()) != this.getValue()) {
            this.setValue(value);
            this.originalValue = value;
        }
    }

    public void updateOption() {
        this.option.setValue(this.getValue());
    }

    public void reset() {
        this.setValue(this.option.getValue());
    }
}

