/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.AudioMixerOptionUI;
import net.sf.freecol.client.gui.option.BooleanOptionUI;
import net.sf.freecol.client.gui.option.FileOptionUI;
import net.sf.freecol.client.gui.option.FreeColActionUI;
import net.sf.freecol.client.gui.option.IntegerOptionUI;
import net.sf.freecol.client.gui.option.LanguageOptionUI;
import net.sf.freecol.client.gui.option.ListOptionUI;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.client.gui.option.PercentageOptionUI;
import net.sf.freecol.client.gui.option.RangeOptionUI;
import net.sf.freecol.client.gui.option.SelectOptionUI;
import net.sf.freecol.client.gui.option.StringOptionUI;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.ListOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.SelectOption;
import net.sf.freecol.common.option.StringOption;

public final class OptionGroupUI
extends JPanel
implements OptionUpdater {
    private static final Logger logger = Logger.getLogger(OptionGroupUI.class.getName());
    public static final int H_GAP = 10;
    private final List<OptionUpdater> optionUpdaters = new ArrayList<OptionUpdater>();
    private final HashMap<String, JComponent> optionUIs;
    private final JTabbedPane tb;

    public OptionGroupUI(OptionGroup option) {
        this(option, true);
    }

    public OptionGroupUI(OptionGroup option, boolean editable) {
        super(new BorderLayout());
        JPanel northPanel = new JPanel();
        northPanel.setLayout((LayoutManager)new MigLayout("wrap 4", "[fill]related[fill]unrelated[fill]related[fill]"));
        northPanel.setOpaque(false);
        this.optionUIs = new HashMap();
        this.tb = new JTabbedPane(1);
        this.tb.setOpaque(false);
        Iterator<Option> it = option.iterator();
        while (it.hasNext()) {
            Option o = it.next();
            if (o instanceof OptionGroup) {
                OptionGroup group = (OptionGroup)o;
                JPanel groupPanel = new JPanel();
                groupPanel.setLayout((LayoutManager)new MigLayout("wrap 4", "[fill]related[fill]unrelated[fill]related[fill]"));
                groupPanel.setOpaque(true);
                this.addOptionGroupUI(group, groupPanel, editable);
                JScrollPane scroll = new JScrollPane(groupPanel, 20, 31);
                scroll.getVerticalScrollBar().setUnitIncrement(16);
                scroll.setBorder(BorderFactory.createEmptyBorder());
                groupPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
                this.tb.addTab(Messages.getName(group), null, scroll, Messages.getShortDescription(group));
                continue;
            }
            this.addOptionUI(o, northPanel, editable);
        }
        if (this.tb.getTabCount() > 0) {
            this.add((Component)this.tb, "Center");
        } else {
            this.add((Component)northPanel, "Center");
        }
        this.setOpaque(false);
    }

    private void addOptionGroupUI(OptionGroup group, JPanel panel, boolean editable) {
        Iterator<Option> iterator = group.iterator();
        while (iterator.hasNext()) {
            Option o = iterator.next();
            if (o instanceof OptionGroup) {
                OptionGroup subgroup = (OptionGroup)o;
                panel.add((Component)new JLabel(Messages.getName(subgroup)), "newline 20, span, split 2");
                panel.add((Component)new JSeparator(), "growx");
                this.addOptionGroupUI(subgroup, panel, editable);
                continue;
            }
            this.addOptionUI(o, panel, editable);
        }
    }

    private void addOptionUI(Option option, JPanel panel, boolean editable) {
        JComponent ui = null;
        String constraints = null;
        JLabel label = null;
        if (option instanceof BooleanOption) {
            BooleanOptionUI c = new BooleanOptionUI((BooleanOption)option, editable);
            constraints = c.getText().length() > 40 ? "newline, span" : "span 2";
            ui = c;
        } else if (option instanceof FileOption) {
            FileOptionUI iou = new FileOptionUI((FileOption)option, editable);
            constraints = "newline, span";
            ui = iou;
        } else if (option instanceof PercentageOption) {
            PercentageOptionUI c = new PercentageOptionUI((PercentageOption)option, editable);
            constraints = "newline, span";
            ui = c;
        } else if (option instanceof ListOption) {
            ListOptionUI c = new ListOptionUI((ListOption)option, editable);
            ui = c;
        } else if (option instanceof RangeOption) {
            RangeOptionUI c = new RangeOptionUI((RangeOption)option, editable);
            constraints = "newline, span";
            ui = c;
        } else if (option instanceof SelectOption) {
            SelectOptionUI c = new SelectOptionUI((SelectOption)option, editable);
            label = c.getLabel();
            ui = c;
        } else if (option instanceof IntegerOption) {
            IntegerOptionUI c = new IntegerOptionUI((IntegerOption)option, editable);
            label = c.getLabel();
            ui = c;
        } else if (option instanceof StringOption) {
            StringOptionUI soi = new StringOptionUI((StringOption)option, editable);
            label = soi.getLabel();
            ui = soi;
        } else if (option instanceof LanguageOption) {
            LanguageOptionUI c = new LanguageOptionUI((LanguageOption)option, editable);
            label = c.getLabel();
            ui = c;
        } else if (option instanceof AudioMixerOption) {
            AudioMixerOptionUI c = new AudioMixerOptionUI((AudioMixerOption)option, editable);
            label = c.getLabel();
            ui = c;
        } else if (option instanceof FreeColAction) {
            FreeColActionUI fau = new FreeColActionUI((FreeColAction)option, this);
            constraints = "newline, span";
            ui = fau;
        } else {
            logger.warning("Unknown option: " + option.getId() + " (" + option.getClass() + ")");
            return;
        }
        if (label != null) {
            if (label.getText().length() > 30) {
                panel.add((Component)label, "newline, span 3");
            } else {
                panel.add(label);
            }
        }
        panel.add((Component)ui, constraints);
        if (editable) {
            this.optionUpdaters.add((OptionUpdater)((Object)ui));
        }
        if (!option.getId().equals("NO_ID")) {
            this.optionUIs.put(option.getId(), ui);
        }
    }

    public void rollback() {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            optionUpdater.rollback();
        }
    }

    public void unregister() {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            optionUpdater.unregister();
        }
    }

    public void updateOption() {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            optionUpdater.updateOption();
        }
    }

    public JComponent getOptionUI(String key) {
        return this.optionUIs.get(key);
    }

    public void removeKeyStroke(KeyStroke keyStroke) {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            if (!(optionUpdater instanceof FreeColActionUI)) continue;
            ((FreeColActionUI)optionUpdater).removeKeyStroke(keyStroke);
        }
    }

    public void reset() {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            optionUpdater.reset();
        }
    }

    public String getUIClassID() {
        return "ReportPanelUI";
    }
}

