/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.FileOption;

public final class FileOptionUI
extends JPanel
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(FileOptionUI.class.getName());
    private final FileOption option;
    private final JTextField fileField;
    private File originalValue;

    public FileOptionUI(final FileOption option, boolean editable) {
        super(new FlowLayout(0));
        this.option = option;
        this.originalValue = option.getValue();
        String name = Messages.getName(option);
        String description = Messages.getShortDescription(option);
        JLabel label = new JLabel(name, 2);
        label.setToolTipText(description != null ? description : name);
        this.add(label);
        String value = option.getValue() != null ? option.getValue().getAbsolutePath() : "";
        this.fileField = new JTextField(value, 10);
        this.add(this.fileField);
        JButton browse = new JButton(Messages.message("file.browse"));
        if (editable) {
            browse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Canvas canvas = FreeCol.getFreeColClient().getCanvas();
                    File file = canvas.showLoadDialog(FreeCol.getSaveDirectory());
                    if (file == null) {
                        return;
                    }
                    if (!file.isFile()) {
                        canvas.errorMessage("fileNotFound");
                        return;
                    }
                    FileOptionUI.this.fileField.setText(file.getAbsolutePath());
                }
            });
        }
        this.add(browse);
        JButton remove = new JButton(Messages.message("option.remove"));
        if (editable) {
            remove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileOptionUI.this.fileField.setText("");
                }
            });
        }
        this.add(remove);
        browse.setEnabled(editable);
        remove.setEnabled(editable);
        this.fileField.setEnabled(false);
        label.setLabelFor(this.fileField);
        this.fileField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                this.editUpdate();
            }

            public void insertUpdate(DocumentEvent arg0) {
                this.editUpdate();
            }

            public void removeUpdate(DocumentEvent arg0) {
                this.editUpdate();
            }

            private void editUpdate() {
                if (option.isPreviewEnabled()) {
                    File value = new File(FileOptionUI.this.fileField.getText());
                    if (!option.getValue().equals(value)) {
                        option.setValue(value);
                    }
                }
            }
        });
        option.addPropertyChangeListener(this);
        this.setOpaque(false);
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        File value;
        if (event.getPropertyName().equals("value") && !(value = (File)event.getNewValue()).equals(new File(this.fileField.getText()))) {
            this.fileField.setText(value.getAbsolutePath());
            this.originalValue = value;
        }
    }

    public void updateOption() {
        if (this.fileField.getText().equals("")) {
            this.option.setValue(null);
        } else {
            this.option.setValue(new File(this.fileField.getText()));
        }
    }

    public void reset() {
        this.setValue(this.option.getValue());
    }

    public void setValue(File f) {
        if (f != null) {
            this.fileField.setText(f.getAbsolutePath());
        } else {
            this.fileField.setText("");
        }
    }
}

