/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.sound.sampled.Mixer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.client.gui.sound.SoundPlayer;
import net.sf.freecol.common.option.AudioMixerOption;

public final class AudioMixerOptionUI
extends JPanel
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(AudioMixerOptionUI.class.getName());
    private final FreeColClient client = FreeColClient.get();
    private final AudioMixerOption option;
    private AudioMixerOption.MixerWrapper originalValue;
    private JLabel label;
    private JComboBox cbox;
    private JButton button1;
    private JButton button2;
    private JLabel currentMixerLabel;
    ActionListener aHandler = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AudioMixerOptionUI.this.button1) {
                AudioMixerOptionUI.this.client.playSound("sound.event.buildingComplete");
            } else if (e.getSource() == AudioMixerOptionUI.this.button2) {
                AudioMixerOptionUI.this.client.playSound("sound.intro.general");
            } else if (e.getSource() == AudioMixerOptionUI.this.cbox) {
                AudioMixerOption.MixerWrapper value = (AudioMixerOption.MixerWrapper)AudioMixerOptionUI.this.cbox.getSelectedItem();
                if (AudioMixerOptionUI.this.option.getValue() != value) {
                    AudioMixerOptionUI.this.option.setValue(value);
                    AudioMixerOptionUI.this.updateMixerLabel();
                }
            }
        }
    };

    public AudioMixerOptionUI(AudioMixerOption option, boolean editable) {
        super(new BorderLayout());
        ((BorderLayout)this.getLayout()).setHgap(15);
        this.option = option;
        this.originalValue = option.getValue();
        this.cbox = new JComboBox();
        this.add((Component)this.cbox, "West");
        this.currentMixerLabel = new JLabel();
        this.add((Component)this.currentMixerLabel, "East");
        this.updateMixerLabel();
        JPanel panel = new JPanel();
        this.add(panel);
        this.button1 = new JButton("Test");
        panel.add(this.button1);
        this.button1.addActionListener(this.aHandler);
        this.button2 = new JButton("Music");
        panel.add(this.button2);
        this.button2.addActionListener(this.aHandler);
        String name = Messages.getName(option);
        String description = Messages.getShortDescription(option);
        this.label = new JLabel(name, 2);
        this.label.setToolTipText(description != null ? description : name);
        this.cbox.add(this.label);
        this.cbox.setModel(new DefaultComboBoxModel<AudioMixerOption.MixerWrapper>(option.getOptions()));
        this.reset();
        this.cbox.setEnabled(editable);
        this.cbox.addActionListener(this.aHandler);
        option.addPropertyChangeListener(this);
        this.setOpaque(false);
    }

    private void updateMixerLabel() {
        SoundPlayer soundPlayer = FreeColClient.get().getSoundPlayer();
        Mixer mixer = soundPlayer.getCurrentMixer();
        String text = mixer == null ? "-- NO ADAPTER --" : mixer.getMixerInfo().getName();
        this.currentMixerLabel.setText("Current:  ".concat(text));
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel newLabel) {
        this.label = newLabel;
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        AudioMixerOption.MixerWrapper value;
        if (event.getPropertyName().equals("value") && (value = (AudioMixerOption.MixerWrapper)event.getNewValue()) != this.cbox.getSelectedItem()) {
            this.cbox.setSelectedItem(value);
            this.originalValue = value;
        }
    }

    public void updateOption() {
        this.option.setValue((AudioMixerOption.MixerWrapper)this.cbox.getSelectedItem());
    }

    public void reset() {
        this.cbox.setSelectedItem(this.option.getValue());
    }
}

