/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.i18n;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Number;
import net.sf.freecol.client.gui.i18n.NumberRules;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.Mods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Messages {
    private static final Logger logger = Logger.getLogger(Messages.class.getName());
    public static final String STRINGS_DIRECTORY = "strings";
    public static final String FILE_PREFIX = "FreeColMessages";
    public static final String FILE_SUFFIX = ".properties";
    private static java.util.Map<String, String> messageBundle = new HashMap<String, String>();
    private static Number grammaticalNumber = NumberRules.OTHER_NUMBER_RULE;

    public static void setGrammaticalNumber(Number number) {
        grammaticalNumber = number;
    }

    public static void setMessageBundle(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Parameter locale must not be null");
        }
        if (!Locale.getDefault().equals(locale)) {
            Locale.setDefault(locale);
        }
        Messages.setMessageBundle(locale.getLanguage(), locale.getCountry(), locale.getVariant());
    }

    private static void setMessageBundle(String language, String country, String variant) {
        Number number;
        messageBundle = new HashMap<String, String>();
        List<String> filenames = FreeColModFile.getFileNames(FILE_PREFIX, FILE_SUFFIX, language, country, variant);
        if (!NumberRules.isInitialized()) {
            File stringDirectory = new File(FreeCol.getDataDirectory(), STRINGS_DIRECTORY);
            if (stringDirectory.exists()) {
                File cldr = new File(stringDirectory, "plurals.xml");
                if (cldr.exists()) {
                    try {
                        FileInputStream in = new FileInputStream(cldr);
                        NumberRules.load(in);
                        in.close();
                    }
                    catch (Exception e) {
                        logger.warning("Failed to read CLDR rules: " + e.toString());
                    }
                } else {
                    logger.warning("Could not find CLDR rules: " + cldr.getPath());
                }
            } else {
                logger.warning("Could not find string directory: " + stringDirectory.getName());
            }
        }
        if ((number = NumberRules.getNumberForLanguage(language)) != null) {
            grammaticalNumber = number;
        }
        for (String fileName : filenames) {
            File resourceFile = new File(Messages.getI18nDirectory(), fileName);
            Messages.loadResources(resourceFile);
            logger.finest("Loaded message bundle " + fileName + " from messages.");
        }
        ArrayList<FreeColModFile> allMods = new ArrayList<FreeColModFile>();
        allMods.addAll(Mods.getAllMods());
        allMods.addAll(Mods.getRuleSets());
        for (FreeColModFile fcmf : allMods) {
            for (String fileName : filenames) {
                try {
                    BufferedInputStream is = fcmf.getInputStream(fileName);
                    Messages.loadResources(is);
                    logger.finest("Loaded message bundle " + fileName + " from " + fcmf.getModInfo().getName() + ".");
                }
                catch (IOException e) {
                    logger.fine("No message bundle " + fileName + " in " + fcmf.getModInfo().getName() + ".");
                }
            }
        }
    }

    public static File getI18nDirectory() {
        return new File(FreeCol.getDataDirectory(), STRINGS_DIRECTORY);
    }

    public static String message(String messageId) {
        String message;
        if (messageId == null) {
            throw new NullPointerException("Message ID must not be null!");
        }
        if (messageBundle == null) {
            Messages.setMessageBundle(Locale.getDefault());
        }
        if ((message = messageBundle.get(messageId)) == null) {
            return messageId;
        }
        message = Messages.replaceChoices(message, null);
        return message.trim();
    }

    private static String replaceChoices(String input, StringTemplate template) {
        int openChoice = 0;
        int closeChoice = 0;
        int highWaterMark = 0;
        StringBuilder result = new StringBuilder();
        while ((openChoice = input.indexOf("{{", highWaterMark)) >= 0) {
            int end;
            String replacement;
            result.append(input.substring(highWaterMark, openChoice));
            closeChoice = Messages.findMatchingBracket(input, openChoice + 2);
            if (closeChoice < 0) {
                logger.warning("Mismatched brackets: " + input);
                return result.toString();
            }
            highWaterMark = closeChoice + 2;
            int colonIndex = input.indexOf(":", openChoice + 2);
            if (colonIndex < 0 || colonIndex > closeChoice) {
                logger.warning("No tag found: " + input);
                continue;
            }
            String tag = input.substring(openChoice + 2, colonIndex);
            int pipeIndex = input.indexOf("|", colonIndex + 1);
            if (pipeIndex < 0 || pipeIndex > closeChoice) {
                logger.warning("No choices found: " + input);
                continue;
            }
            String selector = input.substring(colonIndex + 1, pipeIndex);
            if ("".equals(selector)) {
                selector = "default";
            } else if (selector.startsWith("%") && selector.endsWith("%")) {
                if (template == null) {
                    selector = "default";
                } else {
                    StringTemplate replacement2 = template.getReplacement(selector);
                    if (replacement2 == null) {
                        logger.warning("Failed to find replacement for " + selector);
                        continue;
                    }
                    selector = Messages.message(replacement2);
                    if ("plural".equalsIgnoreCase(tag)) {
                        selector = grammaticalNumber.getKey(selector);
                    }
                }
            } else if ("plural".equalsIgnoreCase(tag)) {
                selector = grammaticalNumber.getKey(selector);
            }
            int keyIndex = input.indexOf(selector, pipeIndex + 1);
            if (keyIndex < 0 || keyIndex > closeChoice) {
                String otherKey = input.substring(pipeIndex + 1, closeChoice);
                if (otherKey.startsWith("%") && otherKey.endsWith("%") && template != null) {
                    StringTemplate replacement3 = template.getReplacement(otherKey);
                    if (replacement3 == null) {
                        logger.warning("Failed to find replacement for " + otherKey);
                        continue;
                    }
                    if (replacement3.getTemplateType() == StringTemplate.TemplateType.KEY) {
                        otherKey = messageBundle.get(replacement3.getId());
                        keyIndex = otherKey.indexOf("{{");
                        if (keyIndex < 0) {
                            result.append(otherKey);
                            continue;
                        }
                        if ((keyIndex = otherKey.indexOf(selector, keyIndex)) < 0) {
                            logger.warning("Failed to find key " + selector + " in replacement " + replacement3.getId());
                            continue;
                        }
                        result.append(Messages.getChoice(otherKey, selector));
                        continue;
                    }
                    logger.warning("Choice substitution attempted, but template type was " + (Object)((Object)replacement3.getTemplateType()));
                    continue;
                }
                if (Messages.containsKey(otherKey)) {
                    otherKey = Messages.getChoice(messageBundle.get(otherKey), selector);
                    result.append(otherKey);
                    continue;
                }
                logger.warning("Unknown key or untagged choice: " + otherKey);
                continue;
            }
            int start = keyIndex + selector.length() + 1;
            int replacementIndex = input.indexOf("|", start);
            int nextOpenIndex = input.indexOf("{{", start);
            if (nextOpenIndex >= 0 && nextOpenIndex < replacementIndex) {
                replacementIndex = input.indexOf("|", Messages.findMatchingBracket(input, nextOpenIndex + 2) + 2);
            }
            if ((replacement = input.substring(start, end = replacementIndex < 0 || replacementIndex > closeChoice ? closeChoice : replacementIndex)).indexOf("{{") < 0) {
                result.append(replacement);
                continue;
            }
            result.append(Messages.replaceChoices(replacement, template));
        }
        result.append(input.substring(highWaterMark));
        return result.toString();
    }

    private static String getChoice(String input, String key) {
        int keyIndex = input.indexOf(key);
        if (keyIndex < 0) {
            return null;
        }
        int start = keyIndex + key.length() + 1;
        int end = input.indexOf("|", start);
        if (end < 0 && (end = input.indexOf("}}", start)) < 0) {
            logger.warning("Failed to find end of choice for key " + key + " in input " + input);
            return null;
        }
        return input.substring(start, end);
    }

    private static int findMatchingBracket(String input, int start) {
        int last = 0;
        int level = 0;
        block4: for (int index = start; index < input.length(); ++index) {
            switch (input.charAt(index)) {
                case '{': {
                    if (last == 123) {
                        last = 0;
                        ++level;
                        continue block4;
                    }
                    last = 123;
                    continue block4;
                }
                case '}': {
                    if (last == 125) {
                        if (level == 0) {
                            return index - 1;
                        }
                        last = 0;
                        --level;
                        continue block4;
                    }
                    last = 125;
                }
            }
        }
        return -1;
    }

    public static String message(StringTemplate template) {
        String result = "";
        switch (template.getTemplateType()) {
            case LABEL: {
                if (template.getReplacements() == null) {
                    return Messages.message(template.getId());
                }
                for (StringTemplate other : template.getReplacements()) {
                    result = result + template.getId() + Messages.message(other);
                }
                if (result.length() > template.getId().length()) {
                    return result.substring(template.getId().length());
                }
                logger.warning("Incorrect use of template with id " + template.getId());
                return result;
            }
            case TEMPLATE: {
                if (Messages.containsKey(template.getId())) {
                    result = messageBundle.get(template.getId());
                } else if (template.getDefaultId() != null) {
                    result = messageBundle.get(template.getDefaultId());
                }
                result = Messages.replaceChoices(result, template);
                for (int index = 0; index < template.getKeys().size(); ++index) {
                    result = result.replace(template.getKeys().get(index), Messages.message(template.getReplacements().get(index)));
                }
                return result;
            }
            case KEY: {
                String key = messageBundle.get(template.getId());
                if (key == null) {
                    return template.getId();
                }
                return Messages.replaceChoices(key, null);
            }
        }
        return template.getId();
    }

    public static boolean containsKey(String key) {
        if (messageBundle == null) {
            Messages.setMessageBundle(Locale.getDefault());
        }
        return messageBundle.get(key) != null;
    }

    public static String getKey(String preferredKey, String defaultKey) {
        if (Messages.containsKey(preferredKey)) {
            return preferredKey;
        }
        return defaultKey;
    }

    public static String getName(FreeColObject object) {
        return Messages.message(object.getId() + ".name");
    }

    public static String getDescription(FreeColObject object) {
        return Messages.message(object.getId() + ".description");
    }

    public static String getShortDescription(FreeColObject object) {
        return Messages.message(object.getId() + ".shortDescription");
    }

    public static StringTemplate getLabel(Unit unit) {
        String typeKey = null;
        String infoKey = null;
        if (unit.canCarryTreasure()) {
            typeKey = unit.getType().getNameKey();
            infoKey = Integer.toString(unit.getTreasureAmount());
        } else {
            String key = unit.getRole() == Unit.Role.DEFAULT ? "name" : unit.getRole().toString().toLowerCase();
            String messageID = unit.getType().getId() + "." + key;
            if (Messages.containsKey(messageID)) {
                typeKey = messageID;
                if ((unit.getEquipment() == null || unit.getEquipment().isEmpty()) && unit.getType().getDefaultEquipmentType() != null) {
                    infoKey = unit.getType().getDefaultEquipmentType().getId() + ".none";
                }
            } else {
                typeKey = "model.unit.role." + key;
                infoKey = unit.getType().getNameKey();
            }
        }
        StringTemplate result = StringTemplate.label(" ").add(typeKey);
        if (unit.getName() != null) {
            result.addName(unit.getName());
        }
        if (infoKey != null) {
            result.addStringTemplate(StringTemplate.label("").addName("(").add(infoKey).addName(")"));
        }
        return result;
    }

    public static String getLabel(UnitType someType, Unit.Role someRole) {
        String messageID;
        String key = someRole.toString().toLowerCase();
        if (someRole == Unit.Role.DEFAULT) {
            key = "name";
        }
        if (Messages.containsKey(messageID = someType.getId() + "." + key)) {
            return Messages.message(messageID);
        }
        return Messages.message(StringTemplate.template("model.unit." + key + ".name").addName("%unit%", someType));
    }

    public static String getLabel(AbstractUnit unit) {
        String messageID;
        String key = unit.getRole().toString().toLowerCase();
        if (unit.getRole() == Unit.Role.DEFAULT) {
            key = "name";
        }
        if (Messages.containsKey(messageID = unit.getId() + "." + key)) {
            return Messages.message(messageID);
        }
        return Messages.message(StringTemplate.template("model.unit." + key + ".name").addName("%unit%", unit));
    }

    public static String getStanceAsString(Player.Stance stance) {
        return Messages.message("model.stance." + stance.toString().toLowerCase());
    }

    public static String getTurnsText(int turns) {
        return turns == Integer.MIN_VALUE ? Messages.message("notApplicable.short") : (turns >= 0 ? Integer.toString(turns) : ">" + Integer.toString(-turns));
    }

    public static String getNewLandName(Player player) {
        if (player.getNewLandName() == null) {
            return Messages.message(player.getNationID() + ".newLandName");
        }
        return player.getNewLandName();
    }

    public static String getDefaultRegionName(Player player, Region.RegionType regionType) {
        String name;
        Map map = player.getGame().getMap();
        int index = player.getNameIndex(regionType.getNameIndexKey());
        if (index < 1) {
            index = 1;
        }
        String prefix = player.getNationID() + ".region." + regionType.toString().toLowerCase(Locale.US) + ".";
        do {
            name = null;
            if (!Messages.containsKey(prefix + Integer.toString(index))) continue;
            name = Messages.message(prefix + Integer.toString(index));
            ++index;
        } while (name != null && map.getRegionByName(name) != null);
        player.setNameIndex(regionType.getNameIndexKey(), index);
        if (name == null) {
            do {
                name = Messages.message(StringTemplate.template("model.region.default").addStringTemplate("%nation%", player.getNationName()).add("%type%", "model.region." + regionType.toString().toLowerCase() + ".name").addAmount("%index%", index));
                ++index;
            } while (map.getRegionByName(name) != null);
        }
        return name;
    }

    public static List<String> getSettlementNames(Player player) {
        String prefix = player.getNationID() + ".settlementName.";
        ArrayList<String> names = new ArrayList<String>();
        names.add(Messages.message(player.isEuropean() ? "Colony" : "Settlement"));
        int i = 0;
        while (Messages.containsKey(prefix + Integer.toString(i))) {
            names.add(Messages.message(prefix + Integer.toString(i)));
            ++i;
        }
        return names;
    }

    public static void loadResources(File resourceFile) {
        if (resourceFile != null && resourceFile.exists() && resourceFile.isFile() && resourceFile.canRead()) {
            try {
                Messages.loadResources(new FileInputStream(resourceFile));
            }
            catch (Exception e) {
                logger.warning("Unable to load resource file " + resourceFile.getPath());
            }
        }
    }

    public static void loadResources(InputStream is) {
        try {
            InputStreamReader inputReader = new InputStreamReader(is, "UTF-8");
            BufferedReader in = new BufferedReader(inputReader);
            String line = null;
            while ((line = in.readLine()) != null) {
                int index = (line = line.trim()).indexOf(35);
                if (index == 0 || (index = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, index).trim();
                String value = line.substring(index + 1).trim().replace("\\n", "\n").replace("\\t", "\t");
                messageBundle.put(key, value);
            }
        }
        catch (Exception e) {
            logger.warning("Unable to load resources from input stream.");
        }
    }
}

