/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.Point;
import java.awt.event.ActionEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.UnitAction;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public class GotoTileAction
extends UnitAction {
    public static final String id = "gotoTileAction";

    GotoTileAction(FreeColClient freeColClient) {
        super(freeColClient, id);
    }

    protected boolean shouldBeEnabled() {
        return super.shouldBeEnabled() && this.getFreeColClient().getGUI().getActiveUnit().getTile() != null;
    }

    public void actionPerformed(ActionEvent e) {
        GUI gui = this.getFreeColClient().getGUI();
        Unit unit = gui.getActiveUnit();
        if (unit != null) {
            if (gui.isGotoStarted()) {
                gui.stopGoto();
            } else {
                Tile tile;
                gui.startGoto();
                Point pt = this.getFreeColClient().getCanvas().getMousePosition();
                if (pt != null && (tile = gui.convertToMapTile(pt.x, pt.y)) != null && unit.getTile() != tile) {
                    PathNode dragPath = unit.findPath(tile);
                    gui.setGotoPath(dragPath);
                }
            }
        }
    }
}

