/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.UnitAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public class ChangeAction
extends UnitAction {
    public static final String id = "changeAction";

    ChangeAction(FreeColClient freeColClient) {
        super(freeColClient, id);
        this.update();
    }

    public void update() {
        Unit unit;
        super.update();
        GUI gui = this.getFreeColClient().getGUI();
        if (gui != null && (unit = gui.getActiveUnit()) != null && unit.getTile() != null) {
            if (unit.getColony() != null) {
                this.putValue("Name", Messages.message("changeAction.enterColony.name"));
            } else if (unit.isOnCarrier()) {
                this.putValue("Name", Messages.message("changeAction.selectCarrier.name"));
            } else {
                this.putValue("Name", Messages.message("changeAction.nextUnitOnTile.name"));
            }
        }
    }

    protected boolean shouldBeEnabled() {
        return super.shouldBeEnabled() && this.getFreeColClient().getGUI().getActiveUnit().getTile() != null;
    }

    public void actionPerformed(ActionEvent e) {
        Unit unit = this.getFreeColClient().getGUI().getActiveUnit();
        Tile tile = unit.getTile();
        if (tile.getColony() != null) {
            this.getFreeColClient().getCanvas().showColonyPanel(tile.getColony());
        } else if (unit.isOnCarrier()) {
            this.getFreeColClient().getGUI().setActiveUnit((Unit)unit.getLocation());
        } else {
            Unit u;
            Iterator<Unit> unitIterator = tile.getUnitIterator();
            boolean activeUnitFound = false;
            while (unitIterator.hasNext()) {
                u = unitIterator.next();
                if (u == unit) {
                    activeUnitFound = true;
                    continue;
                }
                if (!activeUnitFound || u.getState() != Unit.UnitState.ACTIVE || u.getMovesLeft() <= 0) continue;
                this.getFreeColClient().getGUI().setActiveUnit(u);
                return;
            }
            unitIterator = tile.getUnitIterator();
            while (unitIterator.hasNext()) {
                u = unitIterator.next();
                if (u == unit) {
                    return;
                }
                if (u.getState() != Unit.UnitState.ACTIVE || u.getMovesLeft() <= 0) continue;
                this.getFreeColClient().getGUI().setActiveUnit(u);
                return;
            }
        }
    }
}

