/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import net.sf.freecol.common.model.Tile;

public class TerrainCursor
implements ActionListener {
    public static final int OFF = 0;
    public static final int ON = 1;
    private Tile tile;
    private int canvasX;
    private int canvasY;
    private Timer blinkTimer;
    private boolean active = true;
    private EventListenerList listenerList;

    public TerrainCursor() {
        int blinkDelay = 500;
        this.blinkTimer = new Timer(500, this);
        this.listenerList = new EventListenerList();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean newState) {
        this.active = newState;
    }

    public void startBlinking() {
        if (!this.blinkTimer.isRunning()) {
            this.blinkTimer.start();
        }
    }

    public void stopBlinking() {
        if (this.blinkTimer.isRunning()) {
            this.blinkTimer.stop();
        }
    }

    public void setTile(Tile tile) {
        this.tile = tile;
    }

    public Tile getTile() {
        return this.tile;
    }

    public void setCanvasPos(int x, int y) {
        this.canvasX = x;
        this.canvasY = y;
    }

    public int getCanvasX() {
        return this.canvasX;
    }

    public int getCanvasY() {
        return this.canvasY;
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public void actionPerformed(ActionEvent timerEvent) {
        this.active = !this.active;
        int eventId = this.active ? 1 : 0;
        ActionEvent blinkEvent = new ActionEvent(this, eventId, "blink");
        this.fireActionEvent(blinkEvent);
    }

    public void fireActionEvent(ActionEvent event) {
        ActionListener[] listeners = (ActionListener[])this.listenerList.getListeners(ActionListener.class);
        for (int i = 0; i < this.listenerList.getListenerCount(); ++i) {
            listeners[i].actionPerformed(event);
        }
    }
}

