/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.EditSettlementDialog;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.panel.RiverStylePanel;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.server.generator.TerrainGenerator;

public final class CanvasMapEditorMouseListener
implements MouseListener,
MouseMotionListener {
    private static final Logger logger = Logger.getLogger(CanvasMapEditorMouseListener.class.getName());
    private final Canvas canvas;
    private final GUI gui;
    private ScrollThread scrollThread;
    private static final int DRAG_SCROLLSPACE = 100;
    private static final int AUTO_SCROLLSPACE = 1;
    private Point oldPoint;
    private Point startPoint;

    public CanvasMapEditorMouseListener(Canvas canvas, GUI g) {
        this.canvas = canvas;
        this.gui = g;
        this.scrollThread = null;
    }

    private Map getMap() {
        Map map = null;
        if (this.canvas.getClient().getGame() != null) {
            map = this.canvas.getClient().getGame().getMap();
        }
        return map;
    }

    public void mouseClicked(MouseEvent e) {
        if (this.getMap() == null) {
            return;
        }
        try {
            if (e.getClickCount() > 1) {
                Tile tile = this.gui.convertToMapTile(e.getX(), e.getY());
                this.canvas.showColonyPanel(tile);
            } else {
                this.canvas.requestFocus();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mouseClicked!", ex);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (!e.getComponent().isEnabled()) {
            return;
        }
        if (this.getMap() == null) {
            return;
        }
        try {
            if (e.getButton() == 3 || e.isPopupTrigger()) {
                Tile tile = this.gui.convertToMapTile(e.getX(), e.getY());
                if (tile != null) {
                    if (tile.hasRiver()) {
                        TileImprovement river = tile.getRiver();
                        int style = this.canvas.showFreeColDialog(new RiverStylePanel(this.canvas));
                        if (style != -1) {
                            if (style == 0) {
                                tile.getTileItemContainer().removeTileItem(river);
                            } else if (0 < style && style < 81) {
                                river.setStyle(style);
                            } else {
                                logger.warning("Unknown river style: " + style);
                            }
                        }
                    }
                    if (tile.getIndianSettlement() != null) {
                        this.canvas.showFreeColDialog(new EditSettlementDialog(this.canvas, tile.getIndianSettlement()));
                    }
                } else {
                    this.gui.setSelectedTile(null, true);
                }
            } else if (e.getButton() == 1) {
                this.startPoint = e.getPoint();
                this.oldPoint = e.getPoint();
                JComponent component = (JComponent)e.getSource();
                this.drawBox(component, this.startPoint, this.oldPoint);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mousePressed!", ex);
        }
    }

    public void mouseReleased(MouseEvent e) {
        boolean isTransformActive;
        if (this.getMap() == null) {
            return;
        }
        JComponent component = (JComponent)e.getSource();
        MapEditorController controller = this.canvas.getClient().getMapEditorController();
        boolean bl = isTransformActive = controller.getMapTransform() != null;
        if (this.startPoint == null) {
            this.startPoint = e.getPoint();
        }
        if (this.oldPoint == null) {
            this.oldPoint = e.getPoint();
        }
        this.drawBox(component, this.startPoint, this.oldPoint);
        if (this.gui.getFocus() != null) {
            int y;
            int x;
            int max_y;
            int min_y;
            int max_x;
            int min_x;
            Tile start;
            Tile end = start = this.gui.convertToMapTile(this.startPoint.x, this.startPoint.y);
            if (this.startPoint.x != this.oldPoint.x || this.startPoint.y != this.oldPoint.y) {
                end = this.gui.convertToMapTile(this.oldPoint.x, this.oldPoint.y);
            }
            if (!isTransformActive) {
                this.gui.setFocus(end);
                return;
            }
            if (start.getX() < end.getX()) {
                min_x = start.getX();
                max_x = end.getX();
            } else {
                min_x = end.getX();
                max_x = start.getX();
            }
            if (start.getY() < end.getY()) {
                min_y = start.getY();
                max_y = end.getY();
            } else {
                min_y = end.getY();
                max_y = start.getY();
            }
            Tile t = null;
            for (x = min_x; x <= max_x; ++x) {
                for (y = min_y; y <= max_y; ++y) {
                    t = this.getMap().getTile(x, y);
                    if (t == null) continue;
                    controller.transform(t);
                }
            }
            if (controller.getMapTransform() instanceof MapEditorTransformPanel.TileTypeTransform) {
                for (x = min_x - 2; x <= max_x + 2; ++x) {
                    for (y = min_y - 2; y <= max_y + 2; ++y) {
                        t = this.getMap().getTile(x, y);
                        if (t == null || !t.getType().isWater()) continue;
                        TerrainGenerator.encodeStyle(t);
                    }
                }
            }
            this.canvas.refresh();
            this.canvas.requestFocus();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.getMap() == null) {
            return;
        }
        if (e.getComponent().isEnabled() && this.canvas.getClient().getClientOptions().getBoolean("model.option.autoScroll")) {
            this.auto_scroll(e.getX(), e.getY());
        } else if (this.scrollThread != null) {
            this.scrollThread.stopScrolling();
            this.scrollThread = null;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.getMap() == null) {
            return;
        }
        JComponent component = (JComponent)e.getSource();
        this.drawBox(component, this.startPoint, this.oldPoint);
        this.oldPoint = e.getPoint();
        this.drawBox(component, this.startPoint, this.oldPoint);
        if (e.getComponent().isEnabled() && this.canvas.getClient().getClientOptions().getBoolean("model.option.mapScrollOnDrag")) {
            this.drag_scroll(e.getX(), e.getY());
        } else if (this.scrollThread != null) {
            this.scrollThread.stopScrolling();
            this.scrollThread = null;
        }
        this.canvas.refresh();
    }

    private void drawBox(JComponent component, Point startPoint, Point endPoint) {
        if (startPoint == null || endPoint == null) {
            return;
        }
        if (startPoint.distance(endPoint) == 0.0) {
            return;
        }
        MapEditorController controller = this.canvas.getClient().getMapEditorController();
        if (controller.getMapTransform() == null) {
            return;
        }
        Graphics2D graphics = (Graphics2D)component.getGraphics();
        graphics.setColor(Color.WHITE);
        int x = Math.min(startPoint.x, endPoint.x);
        int y = Math.min(startPoint.y, endPoint.y);
        int width = Math.abs(startPoint.x - endPoint.x);
        int height = Math.abs(startPoint.y - endPoint.y);
        graphics.drawRect(x, y, width, height);
    }

    private void auto_scroll(int x, int y) {
        this.scroll(x, y, 1);
    }

    private void drag_scroll(int x, int y) {
        this.scroll(x, y, 100);
    }

    private void scroll(int x, int y, int scrollspace) {
        Map.Direction direction;
        if (this.getMap() == null) {
            return;
        }
        if (x < scrollspace && y < scrollspace) {
            direction = Map.Direction.NW;
        } else if (x >= this.gui.getWidth() - scrollspace && y < scrollspace) {
            direction = Map.Direction.NE;
        } else if (x >= this.gui.getWidth() - scrollspace && y >= this.gui.getHeight() - scrollspace) {
            direction = Map.Direction.SE;
        } else if (x < scrollspace && y >= this.gui.getHeight() - scrollspace) {
            direction = Map.Direction.SW;
        } else if (y < scrollspace) {
            direction = Map.Direction.N;
        } else if (x >= this.gui.getWidth() - scrollspace) {
            direction = Map.Direction.E;
        } else if (y >= this.gui.getHeight() - scrollspace) {
            direction = Map.Direction.S;
        } else if (x < scrollspace) {
            direction = Map.Direction.W;
        } else {
            if (this.scrollThread != null) {
                this.scrollThread.stopScrolling();
                this.scrollThread = null;
            }
            return;
        }
        if (this.scrollThread != null) {
            this.scrollThread.setDirection(direction);
        } else {
            this.scrollThread = new ScrollThread(this.gui);
            this.scrollThread.setDirection(direction);
            this.scrollThread.start();
        }
    }

    private class ScrollThread
    extends Thread {
        private final GUI gui;
        private Map.Direction direction;
        private boolean cont;

        public ScrollThread(GUI g) {
            super("FreeColClient:Mouse scroller");
            this.gui = g;
            this.cont = true;
        }

        public void setDirection(Map.Direction d) {
            this.direction = d;
        }

        public void stopScrolling() {
            this.cont = false;
        }

        public void run() {
            do {
                try {
                    ScrollThread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            try {
                                int x;
                                int y;
                                Tile t = ScrollThread.this.gui.getFocus();
                                if (t == null) {
                                    return;
                                }
                                if ((t = t.getNeighbourOrNull(ScrollThread.this.direction)) == null) {
                                    return;
                                }
                                if (ScrollThread.this.gui.isMapNearTop(t.getY()) && ScrollThread.this.gui.isMapNearTop(ScrollThread.this.gui.getFocus().getY())) {
                                    if (t.getY() > ScrollThread.this.gui.getFocus().getY()) {
                                        y = t.getY();
                                        while (ScrollThread.this.gui.isMapNearTop(y += 2)) {
                                        }
                                    } else {
                                        y = ScrollThread.this.gui.getFocus().getY();
                                    }
                                } else if (ScrollThread.this.gui.isMapNearBottom(t.getY()) && ScrollThread.this.gui.isMapNearBottom(ScrollThread.this.gui.getFocus().getY())) {
                                    if (t.getY() < ScrollThread.this.gui.getFocus().getY()) {
                                        y = t.getY();
                                        while (ScrollThread.this.gui.isMapNearBottom(y -= 2)) {
                                        }
                                    } else {
                                        y = ScrollThread.this.gui.getFocus().getY();
                                    }
                                } else {
                                    y = t.getY();
                                }
                                if (ScrollThread.this.gui.isMapNearLeft(t.getX(), t.getY()) && ScrollThread.this.gui.isMapNearLeft(ScrollThread.this.gui.getFocus().getX(), ScrollThread.this.gui.getFocus().getY())) {
                                    if (t.getX() > ScrollThread.this.gui.getFocus().getX()) {
                                        x = t.getX();
                                        while (ScrollThread.this.gui.isMapNearLeft(++x, y)) {
                                        }
                                    } else {
                                        x = ScrollThread.this.gui.getFocus().getX();
                                    }
                                } else if (ScrollThread.this.gui.isMapNearRight(t.getX(), t.getY()) && ScrollThread.this.gui.isMapNearRight(ScrollThread.this.gui.getFocus().getX(), ScrollThread.this.gui.getFocus().getY())) {
                                    if (t.getX() < ScrollThread.this.gui.getFocus().getX()) {
                                        x = t.getX();
                                        while (ScrollThread.this.gui.isMapNearRight(--x, y)) {
                                        }
                                    } else {
                                        x = ScrollThread.this.gui.getFocus().getX();
                                    }
                                } else {
                                    x = t.getX();
                                }
                                ScrollThread.this.gui.setFocus(CanvasMapEditorMouseListener.this.getMap().getTile(x, y));
                            }
                            catch (Exception e) {
                                logger.log(Level.WARNING, "Exception while scrolling!", e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    logger.log(Level.WARNING, "Scroll thread caught error", e);
                    this.cont = false;
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Scroll thread interrupted", e);
                    this.cont = false;
                }
            } while (this.cont);
        }
    }
}

