/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.Mods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.ListOption;
import net.sf.freecol.common.option.ListOptionSelector;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientOptions
extends OptionGroup {
    private static final Logger logger = Logger.getLogger(ClientOptions.class.getName());
    public static final String LANGUAGE = "model.option.languageOption";
    public static final String JUMP_TO_ACTIVE_UNIT = "model.option.jumpToActiveUnit";
    public static final String ALWAYS_CENTER = "model.option.alwaysCenter";
    public static final String MIN_NUMBER_FOR_DISPLAYING_GOODS = "model.option.guiMinNumberToDisplayGoods";
    public static final String MIN_NUMBER_FOR_DISPLAYING_GOODS_COUNT = "model.option.guiMinNumberToDisplayGoodsCount";
    public static final String MAX_NUMBER_OF_GOODS_IMAGES = "model.option.guiMaxNumberOfGoodsImages";
    public static final String DISPLAY_COMPASS_ROSE = "model.option.displayCompassRose";
    public static final String DISPLAY_MAP_CONTROLS = "model.option.displayMapControls";
    public static final String DISPLAY_GRID = "model.option.displayGrid";
    public static final String UNIT_LAST_MOVE_DELAY = "model.option.unitLastMoveDelay";
    public static final String DISPLAY_BORDERS = "model.option.displayBorders";
    public static final String DISPLAY_TILE_TEXT = "model.option.displayTileText";
    public static final int DISPLAY_TILE_TEXT_EMPTY = 0;
    public static final int DISPLAY_TILE_TEXT_NAMES = 1;
    public static final int DISPLAY_TILE_TEXT_OWNERS = 2;
    public static final int DISPLAY_TILE_TEXT_REGIONS = 3;
    public static final String MOVE_ANIMATION_SPEED = "model.option.moveAnimationSpeed";
    public static final String ENEMY_MOVE_ANIMATION_SPEED = "model.option.enemyMoveAnimationSpeed";
    public static final String MESSAGES_GROUP_BY = "model.option.guiMessagesGroupBy";
    public static final int MESSAGES_GROUP_BY_NOTHING = 0;
    public static final int MESSAGES_GROUP_BY_TYPE = 1;
    public static final int MESSAGES_GROUP_BY_SOURCE = 2;
    public static final String AUDIO_MIXER = "model.option.audioMixer";
    public static final String AUDIO_VOLUME = "model.option.audioVolume";
    public static final String SHOW_COLONY_WARNINGS = "model.option.guiShowColonyWarnings";
    public static final String SHOW_PRECOMBAT = "model.option.guiShowPreCombat";
    public static final String SHOW_NOT_BEST_TILE = "model.option.guiShowNotBestTile";
    public static final String SHOW_GOODS_MOVEMENT = "model.option.guiShowGoodsMovement";
    public static final String SHOW_SAVEGAME_SETTINGS = "model.option.showSavegameSettings";
    public static final int SHOW_SAVEGAME_SETTINGS_NEVER = 0;
    public static final int SHOW_SAVEGAME_SETTINGS_MULTIPLAYER = 1;
    public static final int SHOW_SAVEGAME_SETTINGS_ALWAYS = 2;
    public static final String AUTOSAVE_PERIOD = "model.option.autosavePeriod";
    public static final String AUTOSAVE_GENERATIONS = "model.option.autosaveGenerations";
    public static final String AUTOSAVE_VALIDITY = "model.option.autosaveValidity";
    public static final String AUTOSAVE_DELETE = "model.option.autosaveDelete";
    public static final String MAP_SCROLL_ON_DRAG = "model.option.mapScrollOnDrag";
    public static final String AUTO_SCROLL = "model.option.autoScroll";
    public static final String AUTOLOAD_EMIGRANTS = "model.option.autoloadEmigrants";
    public static final String SMOOTH_MINIMAP_RENDERING = "model.option.smoothRendering";
    public static final String DEFAULT_MINIMAP_ZOOM = "model.option.defaultZoomLevel";
    public static final String MINIMAP_BACKGROUND_COLOR = "model.option.color.background";
    public static final String USER_MODS = "userMods";
    public static final String CUSTOM_STOCK = "model.option.customStock";
    public static final String LOW_LEVEL = "model.option.lowLevel";
    public static final String HIGH_LEVEL = "model.option.highLevel";
    public static final String COLONY_COMPARATOR = "model.option.colonyComparator";
    public static final int COLONY_COMPARATOR_NAME = 0;
    public static final int COLONY_COMPARATOR_AGE = 1;
    public static final int COLONY_COMPARATOR_POSITION = 2;
    public static final int COLONY_COMPARATOR_SIZE = 3;
    public static final int COLONY_COMPARATOR_SOL = 4;
    public static final String AUTO_END_TURN = "model.option.autoEndTurn";
    public static final String LABOUR_REPORT = "model.option.labourReport";
    public static final int LABOUR_REPORT_CLASSIC = 0;
    public static final int LABOUR_REPORT_COMPACT = 1;
    public static final String INDIAN_DEMAND_RESPONSE = "model.option.indianDemandResponse";
    public static final int INDIAN_DEMAND_RESPONSE_ASK = 0;
    public static final int INDIAN_DEMAND_RESPONSE_ACCEPT = 1;
    public static final int INDIAN_DEMAND_RESPONSE_REJECT = 2;
    public static final String UNLOAD_OVERFLOW_RESPONSE = "model.option.unloadOverflowResponse";
    public static final int UNLOAD_OVERFLOW_RESPONSE_ASK = 0;
    public static final int UNLOAD_OVERFLOW_RESPONSE_NEVER = 1;
    public static final int UNLOAD_OVERFLOW_RESPONSE_ALWAYS = 2;
    public static final String COLONY_LABELS = "model.option.displayColonyLabels";
    public static final int COLONY_LABELS_NONE = 0;
    public static final int COLONY_LABELS_CLASSIC = 1;
    public static final int COLONY_LABELS_MODERN = 2;
    private static Comparator<Colony> colonyAgeComparator = new Comparator<Colony>(){

        @Override
        public int compare(Colony s1, Colony s2) {
            if (s1.getEstablished().getNumber() > 0 && s2.getEstablished().getNumber() > 0) {
                return s1.getEstablished().getNumber() - s2.getEstablished().getNumber();
            }
            return s1.getIntegerID().compareTo(s2.getIntegerID());
        }
    };
    private static Comparator<Colony> colonyNameComparator = new Comparator<Colony>(){

        @Override
        public int compare(Colony s1, Colony s2) {
            return s1.getName().compareTo(s2.getName());
        }
    };
    private static Comparator<Colony> colonySizeComparator = new Comparator<Colony>(){

        @Override
        public int compare(Colony s1, Colony s2) {
            int dsize = s2.getUnitCount() - s1.getUnitCount();
            if (dsize == 0) {
                return s2.getSoL() - s1.getSoL();
            }
            return dsize;
        }
    };
    private static Comparator<Colony> colonySoLComparator = new Comparator<Colony>(){

        @Override
        public int compare(Colony s1, Colony s2) {
            int dsol = s2.getSoL() - s1.getSoL();
            if (dsol == 0) {
                return s2.getUnitCount() - s1.getUnitCount();
            }
            return dsol;
        }
    };
    private static Comparator<Colony> colonyPositionComparator = new Comparator<Colony>(){

        @Override
        public int compare(Colony s1, Colony s2) {
            int dy = s1.getTile().getY() - s2.getTile().getY();
            if (dy == 0) {
                return s1.getTile().getX() - s2.getTile().getX();
            }
            return dy;
        }
    };
    private Comparator<ModelMessage> messageSourceComparator = new Comparator<ModelMessage>(){

        @Override
        public int compare(ModelMessage message1, ModelMessage message2) {
            String sourceId2;
            String sourceId1 = message1.getSourceId();
            if (sourceId1 == (sourceId2 = message2.getSourceId())) {
                return ClientOptions.this.messageTypeComparator.compare(message1, message2);
            }
            Game game = FreeCol.getFreeColClient().getGame();
            FreeColGameObject source1 = game.getMessageSource(message1);
            FreeColGameObject source2 = game.getMessageSource(message2);
            int base = this.getClassIndex(source1) - this.getClassIndex(source2);
            if (base == 0 && source1 instanceof Colony) {
                return ClientOptions.this.getColonyComparator().compare((Colony)source1, (Colony)source2);
            }
            return base;
        }

        private int getClassIndex(Object object) {
            if (object instanceof Player) {
                return 10;
            }
            if (object instanceof Colony) {
                return 20;
            }
            if (object instanceof Europe) {
                return 30;
            }
            if (object instanceof Unit) {
                return 40;
            }
            if (object instanceof FreeColGameObject) {
                return 50;
            }
            return 1000;
        }
    };
    private Comparator<ModelMessage> messageTypeComparator = new Comparator<ModelMessage>(){

        @Override
        public int compare(ModelMessage message1, ModelMessage message2) {
            return message1.getMessageType().ordinal() - message2.getMessageType().ordinal();
        }
    };

    public ClientOptions() {
        super(ClientOptions.getXMLElementTagName());
        this.addDefaultOptions();
    }

    protected void addDefaultOptions() {
        this.load(new File(new File(FreeCol.getDataDirectory(), "base"), "client-options.xml"), false);
        OptionGroup modsGroup = new OptionGroup("clientOptions.mods");
        ListOptionSelector<FreeColModFile.ModInfo> selector = new ListOptionSelector<FreeColModFile.ModInfo>(){
            private Map<String, FreeColModFile.ModInfo> mods = null;

            private void init() {
                if (this.mods == null) {
                    List<FreeColModFile> fcmfs = Mods.getAllMods();
                    this.mods = new HashMap<String, FreeColModFile.ModInfo>();
                    for (FreeColModFile f : fcmfs) {
                        FreeColModFile.ModInfo modInfo = f.getModInfo();
                        this.mods.put(modInfo.getId(), modInfo);
                    }
                }
            }

            @Override
            public String getId(FreeColModFile.ModInfo t) {
                return t.getId();
            }

            @Override
            public FreeColModFile.ModInfo getObject(String id) {
                this.init();
                return this.mods.get(id);
            }

            @Override
            public List<FreeColModFile.ModInfo> getOptions() {
                this.init();
                return new ArrayList<FreeColModFile.ModInfo>(this.mods.values());
            }

            @Override
            public String toString(FreeColModFile.ModInfo t) {
                return t.getName();
            }
        };
        new ListOption<FreeColModFile.ModInfo>(selector, USER_MODS, modsGroup, (T[])new FreeColModFile.ModInfo[0]);
        this.add(modsGroup);
    }

    public List<FreeColModFile> getActiveMods() {
        List<FreeColModFile> fcmfs = Mods.getAllMods();
        ArrayList<FreeColModFile> active = new ArrayList<FreeColModFile>();
        ListOption options = (ListOption)this.getOption(USER_MODS);
        Iterator i$ = options.getValue().iterator();
        block0: while (i$.hasNext()) {
            Object o = i$.next();
            FreeColModFile.ModInfo modInfo = (FreeColModFile.ModInfo)o;
            if (modInfo == null) continue;
            for (FreeColModFile f : fcmfs) {
                if (!modInfo.getId().equals(f.getModInfo().getId())) continue;
                active.add(f);
                continue block0;
            }
        }
        return active;
    }

    public void load(File loadFile) {
        this.load(loadFile, true);
    }

    public void load(File loadFile, boolean update) {
        if (loadFile == null || !loadFile.exists()) {
            logger.warning("Could not find the client options file.");
            return;
        }
        logger.finest((update ? "Updating" : "Loading") + " client options from " + loadFile.getPath());
        try {
            this.load(new BufferedInputStream(new FileInputStream(loadFile)), update);
        }
        catch (FileNotFoundException e) {
            logger.warning("Could not find the client options file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream in, boolean update) {
        try {
            XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(in, "UTF-8");
            xsr.nextTag();
            if (update) {
                logger.finest("Updating " + this.getId());
                this.updateFromXML(xsr);
            } else {
                logger.finest("Loading " + this.getId());
                this.readFromXML(xsr);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while loading options.", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception while closing stream.", e);
            }
        }
    }

    private void updateFromXML(XMLStreamReader in) throws XMLStreamException {
        while (in.nextTag() != 2) {
            Option o;
            if (in.getLocalName().equals(OptionGroup.getXMLElementTagName())) {
                this.updateFromXML(in);
                continue;
            }
            String idStr = in.getAttributeValue(null, "id");
            if (idStr == null) {
                idStr = in.getLocalName();
            }
            if ((o = this.getOption(idStr)) != null) {
                o.readFromXML(in);
                continue;
            }
            logger.info("Option \"" + idStr + "\" (" + in.getLocalName() + ") could not be found.");
            String ignoredTag = in.getLocalName();
            while (in.nextTag() != 2 || !in.getLocalName().equals(ignoredTag)) {
            }
        }
    }

    public int getDisplayTileText() {
        return this.getInteger(DISPLAY_TILE_TEXT);
    }

    public Comparator<Colony> getColonyComparator() {
        return ClientOptions.getColonyComparator(this.getInteger(COLONY_COMPARATOR));
    }

    public static Comparator<Colony> getColonyComparator(int type) {
        switch (type) {
            case 1: {
                return colonyAgeComparator;
            }
            case 2: {
                return colonyPositionComparator;
            }
            case 3: {
                return colonySizeComparator;
            }
            case 4: {
                return colonySoLComparator;
            }
            case 0: {
                return colonyNameComparator;
            }
        }
        throw new IllegalStateException("Unknown comparator");
    }

    public Comparator<ModelMessage> getModelMessageComparator() {
        switch (this.getInteger(MESSAGES_GROUP_BY)) {
            case 2: {
                return this.messageSourceComparator;
            }
            case 1: {
                return this.messageTypeComparator;
            }
        }
        return null;
    }

    public BooleanOption getBooleanOption(ModelMessage message) {
        return (BooleanOption)this.getOption(message.getMessageType().getOptionName());
    }

    protected boolean isCorrectTagName(String tagName) {
        return ClientOptions.getXMLElementTagName().equals(tagName);
    }

    public static String getXMLElementTagName() {
        return "clientOptions";
    }
}

