/*
 * Decompiled with CFR 0.152.
 */
package flexjson.test;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MockPhone {
    private String name;
    private String areaCode;
    private String exchange;
    private String number;
    private static final Pattern PHONE_PATTERN = Pattern.compile("\\(?(\\d{3})\\)?[\\s-](\\d{3})[\\s-](\\d{4})");

    public String getAreaCode() {
        return this.areaCode;
    }

    public MockPhone(String name, String number) {
        this.name = name;
        Matcher matcher = PHONE_PATTERN.matcher(number);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(number + " does not match one of these formats: (xxx) xxx-xxxx, xxx xxx-xxxx, or xxx xxx xxxx.");
        }
        this.areaCode = matcher.group(1);
        this.exchange = matcher.group(2);
        this.number = matcher.group(3);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getPhoneNumber() {
        return "(" + this.areaCode + ") " + this.exchange + "-" + this.number;
    }
}

