/*
 * Decompiled with CFR 0.152.
 */
package flexjson.test;

import flexjson.JSONSerializer;
import flexjson.test.MockAddress;
import flexjson.test.MockNetwork;
import flexjson.test.MockPerson;
import flexjson.test.MockPhone;
import flexjson.test.MockZipcode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class JSONSerializerTest
extends TestCase {
    private MockPerson charlie;
    private MockPerson ben;
    private Map colors;
    private List people;
    private MockNetwork network;

    public void setUp() {
        MockAddress home = new MockAddress("4132 Pluto Drive", "Atlanta", "Ga", new MockZipcode("33913"));
        MockAddress work = new MockAddress("44 Planetary St.", "Neptune", "Milkiway", new MockZipcode("30328-0764"));
        MockPhone pagerPhone = new MockPhone("pager", "404 555-1234");
        MockPhone cellPhone = new MockPhone("cell", "770 777 5432");
        Calendar cal = Calendar.getInstance();
        cal.set(1976, 3, 21, 8, 11);
        this.charlie = new MockPerson("Charlie", "Hubbard", cal.getTime(), home, work);
        this.charlie.getPhones().add(pagerPhone);
        this.charlie.getPhones().add(cellPhone);
        this.charlie.getHobbies().add("Shorting volatile stocks");
        this.charlie.getHobbies().add("Fixing Horse Races");
        this.charlie.getHobbies().add("Taking dives in the 3rd round");
        MockAddress benhome = new MockAddress("8735 Hilton Way", "Chattanooga", "Tn", new MockZipcode("82742"));
        MockAddress benwork = new MockAddress("44 Planetary St.", "Neptune", "Milkiway", new MockZipcode("12345"));
        Calendar benCal = Calendar.getInstance();
        benCal.set(1978, 7, 5, 8, 11);
        this.ben = new MockPerson("Ben", "Hubbard", benCal.getTime(), benhome, benwork);
        this.ben.getHobbies().add("Purse snatching");
        this.ben.getHobbies().add("Running sweat shops");
        this.ben.getHobbies().add("Fixing prices");
        this.colors = new HashMap();
        this.colors.put("blue", "#0000ff");
        this.colors.put("green", "#00ff00");
        this.colors.put("black", "#000000");
        this.colors.put("grey", "#888888");
        this.colors.put("yellow", "#00ffff");
        this.colors.put("purple", "#ff00ff");
        this.colors.put("white", "#ffffff");
        this.people = new ArrayList();
        this.people.add(this.charlie);
        this.people.add(this.ben);
        this.network = new MockNetwork("My Network", this.charlie, this.ben);
    }

    public void testObject() {
        JSONSerializer serializer = new JSONSerializer();
        String charlieJson = serializer.serialize(this.charlie);
        JSONSerializerTest.assertTrue((boolean)charlieJson.contains(MockPerson.class.getName()));
        JSONSerializerTest.assertTrue((boolean)charlieJson.contains("\"firstname\""));
        JSONSerializerTest.assertTrue((boolean)charlieJson.contains("\"Charlie\""));
        JSONSerializerTest.assertTrue((boolean)charlieJson.contains("\"lastname\""));
        JSONSerializerTest.assertTrue((boolean)charlieJson.contains("\"Hubbard\""));
        JSONSerializerTest.assertTrue((boolean)charlieJson.contains("work"));
        JSONSerializerTest.assertTrue((boolean)charlieJson.contains("home"));
        JSONSerializerTest.assertTrue((boolean)charlieJson.contains("street"));
        JSONSerializerTest.assertTrue((boolean)charlieJson.contains(MockAddress.class.getName()));
        JSONSerializerTest.assertTrue((boolean)charlieJson.contains("zipcode"));
        JSONSerializerTest.assertTrue((boolean)charlieJson.contains(MockZipcode.class.getName()));
        JSONSerializerTest.assertFalse((boolean)charlieJson.contains("phones"));
        JSONSerializerTest.assertFalse((boolean)charlieJson.contains(MockPhone.class.getName()));
        JSONSerializerTest.assertFalse((boolean)charlieJson.contains("hobbies"));
        JSONSerializer benSerializer = new JSONSerializer();
        benSerializer.exclude("home", "work");
        String benJson = benSerializer.serialize(this.ben);
        JSONSerializerTest.assertTrue((boolean)benJson.contains(MockPerson.class.getName()));
        JSONSerializerTest.assertTrue((boolean)benJson.contains("firstname"));
        JSONSerializerTest.assertTrue((boolean)benJson.contains("Ben"));
        JSONSerializerTest.assertTrue((boolean)benJson.contains("lastname"));
        JSONSerializerTest.assertTrue((boolean)benJson.contains("Hubbard"));
        JSONSerializerTest.assertTrue((boolean)benJson.contains("birthdate"));
        JSONSerializerTest.assertFalse((boolean)benJson.contains(MockAddress.class.getName()));
        JSONSerializerTest.assertFalse((boolean)benJson.contains("work"));
        JSONSerializerTest.assertFalse((boolean)benJson.contains("home"));
        JSONSerializerTest.assertFalse((boolean)benJson.contains("street"));
        JSONSerializerTest.assertFalse((boolean)benJson.contains("city"));
        JSONSerializerTest.assertFalse((boolean)benJson.contains("state"));
        JSONSerializerTest.assertFalse((boolean)benJson.contains(MockZipcode.class.getName()));
        JSONSerializerTest.assertFalse((boolean)benJson.contains("zipcode"));
        JSONSerializerTest.assertFalse((boolean)benJson.contains(MockPhone.class.getName()));
        JSONSerializerTest.assertFalse((boolean)benJson.contains("hobbies"));
        serializer.exclude("home.zipcode", "work.zipcode");
        String json2 = serializer.serialize(this.charlie);
        JSONSerializerTest.assertTrue((boolean)json2.contains(MockPerson.class.getName()));
        JSONSerializerTest.assertTrue((boolean)json2.contains("work"));
        JSONSerializerTest.assertTrue((boolean)json2.contains("home"));
        JSONSerializerTest.assertTrue((boolean)json2.contains("street"));
        JSONSerializerTest.assertTrue((boolean)json2.contains(MockAddress.class.getName()));
        JSONSerializerTest.assertFalse((boolean)json2.contains("zipcode"));
        JSONSerializerTest.assertFalse((boolean)json2.contains("phones"));
        JSONSerializerTest.assertFalse((boolean)json2.contains(MockZipcode.class.getName()));
        JSONSerializerTest.assertFalse((boolean)json2.contains(MockPhone.class.getName()));
        JSONSerializerTest.assertFalse((boolean)json2.contains("hobbies"));
        serializer.include("hobbies").exclude("phones.areaCode", "phones.exchange", "phones.number");
        String json3 = serializer.serialize(this.charlie);
        JSONSerializerTest.assertTrue((boolean)json3.contains(MockPerson.class.getName()));
        JSONSerializerTest.assertTrue((boolean)json3.contains("work"));
        JSONSerializerTest.assertTrue((boolean)json3.contains("home"));
        JSONSerializerTest.assertTrue((boolean)json3.contains("street"));
        JSONSerializerTest.assertTrue((boolean)json3.contains(MockAddress.class.getName()));
        JSONSerializerTest.assertTrue((boolean)json3.contains("phones"));
        JSONSerializerTest.assertTrue((boolean)json3.contains("phoneNumber"));
        JSONSerializerTest.assertTrue((boolean)json3.contains(MockPhone.class.getName()));
        JSONSerializerTest.assertTrue((boolean)json3.contains("hobbies"));
        JSONSerializerTest.assertFalse((boolean)json3.contains("zipcode"));
        JSONSerializerTest.assertFalse((boolean)json3.contains(MockZipcode.class.getName()));
        JSONSerializerTest.assertFalse((boolean)json3.contains("areaCode"));
        JSONSerializerTest.assertFalse((boolean)json3.contains("exchange"));
        JSONSerializerTest.assertFalse((boolean)json3.contains("number"));
        JSONSerializerTest.assertTrue((boolean)json3.startsWith("{"));
        JSONSerializerTest.assertTrue((boolean)json3.endsWith("}"));
    }

    public void testMap() {
        JSONSerializer serializer = new JSONSerializer();
        String colorsJson = serializer.serialize(this.colors);
        for (Map.Entry entry : this.colors.entrySet()) {
            JSONSerializerTest.assertTrue((boolean)colorsJson.contains(entry.getKey().toString()));
            JSONSerializerTest.assertTrue((boolean)colorsJson.contains(entry.getValue().toString()));
        }
        JSONSerializerTest.assertTrue((boolean)colorsJson.startsWith("{"));
        JSONSerializerTest.assertTrue((boolean)colorsJson.endsWith("}"));
    }

    public void testCollection() {
        JSONSerializer serializer = new JSONSerializer();
        String colorsJson = serializer.serialize(this.colors.values());
        for (Map.Entry entry : this.colors.entrySet()) {
            JSONSerializerTest.assertTrue((boolean)colorsJson.contains(entry.getValue().toString()));
            JSONSerializerTest.assertFalse((boolean)colorsJson.contains(entry.getKey().toString()));
        }
        JSONSerializerTest.assertTrue((boolean)colorsJson.startsWith("["));
        JSONSerializerTest.assertTrue((boolean)colorsJson.endsWith("]"));
    }

    public void testString() {
        this.assertSerializedTo("Hello", "\"Hello\"");
        this.assertSerializedTo("Hello World", "\"Hello World\"");
        this.assertSerializedTo("Hello\nWorld", "\"Hello\\nWorld\"");
        this.assertSerializedTo("Hello 'Charlie'", "\"Hello 'Charlie'\"");
        this.assertSerializedTo("Hello \"Charlie\"", "\"Hello \\\"Charlie\\\"\"");
    }

    public void testListOfObjects() {
        JSONSerializer serializer = new JSONSerializer();
        String peopleJson = serializer.serialize(this.people);
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains(MockPerson.class.getName()));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"firstname\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"Charlie\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"Ben\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"lastname\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"Hubbard\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains(MockAddress.class.getName()));
        serializer = new JSONSerializer().exclude("home", "work");
        peopleJson = serializer.serialize(this.people);
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains(MockPerson.class.getName()));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"firstname\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"Charlie\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"Ben\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"lastname\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"Hubbard\""));
        JSONSerializerTest.assertFalse((boolean)peopleJson.contains(MockAddress.class.getName()));
    }

    public void testDeepIncludes() {
        JSONSerializer serializer = new JSONSerializer();
        String peopleJson = serializer.include("people.hobbies").serialize(this.network);
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"name\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"My Network\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"firstname\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"Charlie\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"Ben\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"lastname\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"Hubbard\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"hobbies\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"Purse snatching\""));
    }

    public void testDates() {
        JSONSerializer serializer = new JSONSerializer();
        String peopleJson = serializer.exclude("home", "work").serialize(this.charlie);
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"firstname\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("\"Charlie\""));
        JSONSerializerTest.assertTrue((boolean)peopleJson.contains("new Date("));
        JSONSerializerTest.assertFalse((boolean)peopleJson.contains("java.util.Date"));
    }

    public void testRootName() {
        JSONSerializer serializer = new JSONSerializer();
        String peopleJson = serializer.serialize("people", this.people);
        JSONSerializerTest.assertTrue((boolean)peopleJson.startsWith("{\"people\":"));
    }

    public void testSetIncludes() {
        JSONSerializer serializer = new JSONSerializer();
        serializer.setIncludes(Arrays.asList("people.hobbies", "phones", "home", "people.resume"));
        List includes = serializer.getIncludes();
        JSONSerializerTest.assertFalse((boolean)includes.isEmpty());
        JSONSerializerTest.assertEquals((int)4, (int)includes.size());
        JSONSerializerTest.assertTrue((boolean)includes.contains("people.hobbies"));
        JSONSerializerTest.assertTrue((boolean)includes.contains("people.resume"));
        JSONSerializerTest.assertTrue((boolean)includes.contains("phones"));
        JSONSerializerTest.assertTrue((boolean)includes.contains("home"));
    }

    private void assertSerializedTo(String original, String expected) {
        JSONSerializer serializer = new JSONSerializer();
        String json = serializer.serialize(original);
        JSONSerializerTest.assertEquals((String)expected, (String)json);
    }

    public void tearDown() {
    }

    public static Test suite() {
        return new TestSuite(JSONSerializerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)JSONSerializerTest.suite());
    }
}

