/*
 * Decompiled with CFR 0.152.
 */
package flexjson;

import flexjson.JSON;
import flexjson.JSONException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSONSerializer {
    public static final char[] HEX = "0123456789ABCDEF".toCharArray();
    Map excludeFields = new HashMap();
    Map includeFields = new HashMap();

    public String serialize(String rootName, Object target) {
        return new ObjectVisitor().visit(rootName, target);
    }

    public String serialize(Object target) {
        return new ObjectVisitor().visit(target);
    }

    public JSONSerializer exclude(String ... fields) {
        this.addFieldsTo(this.excludeFields, fields);
        return this;
    }

    public JSONSerializer include(String ... fields) {
        this.addFieldsTo(this.includeFields, fields);
        return this;
    }

    public List getIncludes() {
        return this.renderFields(this.includeFields);
    }

    public List getExcludes() {
        return this.renderFields(this.excludeFields);
    }

    public void setIncludes(List fields) {
        for (Object field : fields) {
            this.addFieldsTo(this.includeFields, field.toString());
        }
    }

    public void setExcludes(List fields) {
        for (Object field : fields) {
            this.addFieldsTo(this.excludeFields, field.toString());
        }
    }

    private void addFieldsTo(Map root, String ... fields) {
        for (String field : fields) {
            Map current = root;
            String[] paths = field.split("\\.");
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                if (!current.containsKey(path) || current.get(path) == null) {
                    current.put(path, i + 1 < paths.length ? new HashMap() : null);
                }
                current = (Map)current.get(path);
            }
        }
    }

    private List renderFields(Map includeFields) {
        ArrayList<String> fields = new ArrayList<String>(includeFields.size());
        for (Object key : includeFields.keySet()) {
            Map children = (Map)includeFields.get(key);
            if (children != null) {
                List childrenFields = this.renderFields(children);
                for (Object child : childrenFields) {
                    fields.add(key + "." + child);
                }
                continue;
            }
            fields.add(key.toString());
        }
        return fields;
    }

    private class ObjectVisitor {
        private StringBuilder builder = new StringBuilder();

        public String visit(Object target) {
            this.json(target, JSONSerializer.this.includeFields, JSONSerializer.this.excludeFields);
            return this.builder.toString();
        }

        public String visit(String rootName, Object target) {
            this.add('{');
            this.string(rootName);
            this.add(':');
            this.json(target, JSONSerializer.this.includeFields, JSONSerializer.this.excludeFields);
            this.add('}');
            return this.builder.toString();
        }

        private void json(Object object, Map includes, Map excludes) {
            if (object == null) {
                this.add("null");
            } else if (object instanceof Class) {
                this.string(((Class)object).getName());
            } else if (object instanceof Boolean) {
                this.bool((Boolean)object);
            } else if (object instanceof Number) {
                this.add(object);
            } else if (object instanceof String) {
                this.string(object);
            } else if (object instanceof Character) {
                this.string(object);
            } else if (object instanceof Map) {
                this.map((Map)object, includes, excludes);
            } else if (object.getClass().isArray()) {
                this.array(object, includes, excludes);
            } else if (object instanceof Iterable) {
                this.array(((Iterable)object).iterator(), includes, excludes);
            } else if (object instanceof Date) {
                this.date((Date)object);
            } else {
                this.bean(object, includes, excludes);
            }
        }

        private void map(Map map, Map includes, Map excludes) {
            this.add('{');
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                this.add(key, map.get(key), includes, excludes);
                if (!it.hasNext()) continue;
                this.add(',');
            }
            this.add('}');
        }

        private void array(Iterator it, Map includes, Map excludes) {
            this.add('[');
            while (it.hasNext()) {
                this.json(it.next(), includes, excludes);
                if (!it.hasNext()) continue;
                this.add(',');
            }
            this.add(']');
        }

        private void array(Object object, Map includes, Map excludes) {
            this.add('[');
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                this.json(Array.get(object, i), includes, excludes);
                if (i >= length - 1) continue;
                this.add(',');
            }
            this.add(']');
        }

        private void bool(Boolean b) {
            this.add(b != false ? "true" : "false");
        }

        private void string(Object obj) {
            this.add('\"');
            StringCharacterIterator it = new StringCharacterIterator(obj.toString());
            char c = it.first();
            while (c != '\uffff') {
                if (c == '\"') {
                    this.add("\\\"");
                } else if (c == '\\') {
                    this.add("\\\\");
                } else if (c == '/') {
                    this.add("\\/");
                } else if (c == '\b') {
                    this.add("\\b");
                } else if (c == '\f') {
                    this.add("\\f");
                } else if (c == '\n') {
                    this.add("\\n");
                } else if (c == '\r') {
                    this.add("\\r");
                } else if (c == '\t') {
                    this.add("\\t");
                } else if (Character.isISOControl(c)) {
                    this.unicode(c);
                } else {
                    this.add(c);
                }
                c = it.next();
            }
            this.add('\"');
        }

        private void date(Date date) {
            this.builder.append("new Date( ");
            this.builder.append(date.getTime());
            this.builder.append(")");
        }

        private void bean(Object object, Map includes, Map excludes) {
            this.add('{');
            try {
                Field[] ff;
                BeanInfo info = Introspector.getBeanInfo(object.getClass());
                PropertyDescriptor[] props = info.getPropertyDescriptors();
                boolean firstField = true;
                for (PropertyDescriptor prop : props) {
                    String name = prop.getName();
                    Method accessor = prop.getReadMethod();
                    if (accessor == null || !this.isIncluded(prop, includes, excludes)) continue;
                    Object value = accessor.invoke(object, (Object[])null);
                    firstField = this.addComma(firstField);
                    this.add(name, value, includes, excludes);
                }
                for (Field field : ff = object.getClass().getDeclaredFields()) {
                    if (!this.isValidField(field)) continue;
                    firstField = this.addComma(firstField);
                    this.add(field.getName(), field.get(object), includes, excludes);
                }
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            this.add('}');
        }

        private boolean isIncluded(PropertyDescriptor prop, Map includes, Map excludes) {
            if (includes.containsKey(prop.getName())) {
                return true;
            }
            if (excludes.containsKey(prop.getName())) {
                return excludes.get(prop.getName()) != null;
            }
            Method accessor = prop.getReadMethod();
            if (accessor.isAnnotationPresent(JSON.class)) {
                return accessor.getAnnotation(JSON.class).include();
            }
            Class<?> propType = prop.getPropertyType();
            return !propType.isArray() && !Iterable.class.isAssignableFrom(propType) && !Map.class.isAssignableFrom(propType);
        }

        private boolean isValidField(Field field) {
            return !Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers());
        }

        private boolean addComma(boolean firstField) {
            if (!firstField) {
                this.add(',');
            } else {
                firstField = false;
            }
            return firstField;
        }

        private void add(char c) {
            this.builder.append(c);
        }

        private void add(Object value) {
            this.builder.append(value);
        }

        private void add(Object key, Object value, Map includes, Map excludes) {
            this.builder.append("\"");
            this.builder.append(key);
            this.builder.append("\"");
            this.builder.append(": ");
            Map nextIncludes = includes.containsKey(key) && includes.get(key) != null ? (Map)includes.get(key) : Collections.EMPTY_MAP;
            Map nextExcludes = excludes.containsKey(key) && excludes.get(key) != null ? (Map)excludes.get(key) : Collections.EMPTY_MAP;
            this.json(value, nextIncludes, nextExcludes);
        }

        private void unicode(char c) {
            this.add("\\u");
            int n = c;
            for (int i = 0; i < 4; ++i) {
                int digit = (n & 0xF000) >> 12;
                this.add(HEX[digit]);
                n <<= 4;
            }
        }
    }
}

