/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.border.ActiveBorder;
import com.l2fprod.gui.plaf.skin.SkinButton;
import com.l2fprod.gui.plaf.skin.SkinFrame;
import com.l2fprod.gui.plaf.skin.SkinPersonality;
import com.l2fprod.gui.plaf.skin.SkinProgress;
import com.l2fprod.gui.plaf.skin.SkinScrollbar;
import com.l2fprod.gui.plaf.skin.SkinSlider;
import com.l2fprod.gui.plaf.skin.SkinSplitPane;
import com.l2fprod.gui.plaf.skin.SkinTab;
import com.l2fprod.gui.plaf.skin.SkinUtils;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkin;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkButton;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkPersonality;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkProgress;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkScrollbar;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkSeparator;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkSkinNotFoundException;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkSlider;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkSplitPane;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkTab;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;

public final class GtkSkin
extends AbstractSkin {
    String[] colors;
    static String[] swingToGtk = new String[]{"desktop", "", "activeCaption", "", "activeCaptionText", "", "activeCaptionBorder", "", "inactiveCaption", "", "inactiveCaptionText", "", "inactiveCaptionBorder", "", "window", "window.bg[NORMAL]", "windowBorder", "window.bg[NORMAL]", "windowText", "window.fg[NORMAL]", "menu", "menu.bg[NORMAL]", "menuPressedItemB", "bg[ACTIVE]", "menuPressedItemF", "fg[ACTIVE]", "menuText", "fg[NORMAL]", "text", "bg[NORMAL]", "textText", "fg[NORMAL]", "textHighlight", "bg[SELECTED]", "textHighlightText", "fg[SELECTED]", "textInactiveText", "fg[INSENSITIVE]", "control", "button.bg[NORMAL]", "controlText", "button.fg[NORMAL]", "controlHighlight", "", "controlLtHighlight", "", "controlShadow", "", "controlDkShadow", "", "scrollbar", "", "info", "", "infoText", ""};
    Border textBorder;
    Border disabledTextBorder;

    public GtkSkin(String filename) throws Exception {
        this(SkinUtils.toURL(new File(filename)));
    }

    public GtkSkin(URL url) throws Exception {
        GtkParser parser = new GtkParser(url);
        parser.buildStructure();
        this.init(parser);
    }

    public GtkSkin(URL url, InputStream input) throws Exception {
        GtkParser parser = new GtkParser(input);
        parser.setDirectory(url);
        parser.buildStructure();
        this.init(parser);
    }

    public GtkSkin(GtkParser parser) throws Exception {
        this.init(parser);
    }

    public SkinPersonality getPersonality() {
        return this.personality;
    }

    public SkinButton getButton() {
        return this.button;
    }

    public SkinFrame getFrame() {
        return null;
    }

    public SkinTab getTab() {
        return this.tab;
    }

    public SkinProgress getProgress() {
        return this.progress;
    }

    public String[] getColors() {
        return this.colors;
    }

    public SkinScrollbar getScrollbar() {
        return this.scrollbar;
    }

    public SkinSplitPane getSplitPane() {
        return this.splitpane;
    }

    public SkinSlider getSlider() {
        return this.slider;
    }

    private void init(GtkParser parser) throws Exception {
        this.personality = new GtkPersonality(parser);
        this.button = new GtkButton(parser);
        this.tab = new GtkTab(parser);
        this.progress = new GtkProgress(parser);
        this.scrollbar = new GtkScrollbar(parser);
        this.splitpane = new GtkSplitPane(parser);
        this.slider = new GtkSlider(parser);
        this.separator = new GtkSeparator(parser);
        Vector<String> colorList = new Vector<String>();
        for (int i = 0; i < swingToGtk.length; i += 2) {
            String colorName = swingToGtk[i + 1];
            String color = null;
            if ("".equals(colorName)) continue;
            int index = colorName.indexOf(".");
            if (index != -1) {
                if (parser.getStyle(colorName.substring(0, index)) != null) {
                    color = (String)parser.getStyle(colorName.substring(0, index)).getProperty(colorName.substring(index + 1));
                }
                if (color == null) {
                    colorName = colorName.substring(index + 1);
                }
            }
            if (color == null) {
                color = (String)parser.getStyle("default").getProperty(colorName);
            }
            if (color == null) continue;
            colorList.addElement(swingToGtk[i]);
            colorList.addElement(SkinUtils.decodeColor(color));
        }
        this.colors = new String[colorList.size()];
        colorList.copyInto(this.colors);
        this.disabledTextBorder = GtkUtils.newButton(parser, "default", new String[]{"function", "state", "detail"}, new String[]{"FLAT_BOX", "INSENSITIVE", "text"}, true);
        this.textBorder = GtkUtils.newButton(parser, "default", new String[]{"function", "state", "detail"}, new String[]{"FLAT_BOX", null, "text"}, true);
        if (this.disabledTextBorder != null && this.textBorder != null) {
            this.textBorder = new BorderUIResource(new ActiveBorder(this.textBorder, this.disabledTextBorder));
        }
    }

    public void initComponentDefaults(UIDefaults table) {
        if (Boolean.TRUE.equals(UIManager.get("EnableBorders")) && this.textBorder != null) {
            table.put("TextField.border", this.textBorder);
            table.put("PasswordField.border", this.textBorder);
            table.put("ScrollPane.border", this.textBorder);
            table.put("Spinner.border", this.textBorder);
        }
    }

    public static String getDefaultSkinLocation() throws GtkSkinNotFoundException {
        String home = System.getProperty("user.home");
        if (home == null) {
            return null;
        }
        String gtkrc = home + File.separator + ".gtkrc";
        File f = new File(gtkrc);
        if (!f.exists()) {
            throw new GtkSkinNotFoundException();
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String s = br.readLine();
            while (s != null) {
                String s2;
                File f2;
                if (s.indexOf("gtkrc") != -1 && (f2 = new File(s2 = s.substring(9, s.length() - 1))).exists()) {
                    return f2.getCanonicalPath();
                }
                s = br.readLine();
            }
        }
        catch (Exception e) {
            throw new GtkSkinNotFoundException();
        }
        throw new GtkSkinNotFoundException();
    }
}

