////////////////////////////////////////////////////////////////////////////////
//
//  ADOBE SYSTEMS INCORPORATED
//  Copyright 2008 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE: Adobe permits you to use, modify, and distribute this file
//  in accordance with the terms of the license agreement accompanying it.
//
////////////////////////////////////////////////////////////////////////////////

package spark.components
{
/**
 *  Enumerated type for the <code>PopUpAnchor.popUpPosition</code> property.
 *  This type describes the position of the <code>popUp</code> control that is
 *  anchored by PopUpAnchor. The position is relative to the PopUpAnchor position.  
 *    
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 */
public final class PopUpPosition
{	
	/**
     *  Position above the target
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
	public static const ABOVE:String = "above";
	
	/**
     *  Position below the target
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
	public static const BELOW:String = "below";
	
	/**
     *  Position in the center of the target
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
	public static const CENTER:String = "center";
	
	/**
     *  Position at the upper left corner of the target
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
	public static const TOP_LEFT:String = "topLeft";
	
	/**
     *  Position to the left of the target
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
	public static const LEFT:String = "left";
	
	/**
     *  Position to the right of the target
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
	public static const RIGHT:String = "right";
	
}
}
