////////////////////////////////////////////////////////////////////////////////
//
//  ADOBE SYSTEMS INCORPORATED
//  Copyright 2005-2007 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE: Adobe permits you to use, modify, and distribute this file
//  in accordance with the terms of the license agreement accompanying it.
//
////////////////////////////////////////////////////////////////////////////////

/**
 *  Number of pixels between the component's left border
 *  and the left edge of its content area.
 *  <p>The default value is 0.</p>
 *  <p>The default value for a Button control in the Halo theme is 10
 *     and in the Spark theme is 6.</p>
 *  <p>The default value for the ComboBox control is 5.</p>
 *  <p>The default value for the Form container is 16.</p>
 *  <p>The default value for the Tree control is 2.</p>
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
[Style(name="paddingLeft", type="Number", format="Length", inherit="no")]

/**
 *  Number of pixels between the component's right border
 *  and the right edge of its content area.
 *  <p>The default value is 0.</p>
 *  <p>The default value for a Button control in the Halo theme is 10
 *     and in the Spark theme is 6.</p>
 *  <p>The default value for the ComboBox control is 5.</p>
 *  <p>The default value for the Form container is 16.</p>
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
[Style(name="paddingRight", type="Number", format="Length", inherit="no")]
