/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.jf.dexlib.Code.Analysis.ClassPath;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.TypeIdItem;

public class RegisterType {
    private static final HashMap<RegisterType, RegisterType> internedRegisterTypes = new HashMap();
    public final Category category;
    public final ClassPath.ClassDef type;

    private RegisterType(Category category, ClassPath.ClassDef type) {
        assert ((category == Category.Reference || category == Category.UninitRef || category == Category.UninitThis) && type != null || category != Category.Reference && category != Category.UninitRef && category != Category.UninitThis && type == null);
        this.category = category;
        this.type = type;
    }

    public String toString() {
        return "(" + this.category.name() + (this.type == null ? "" : "," + this.type.getClassType()) + ")";
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(40);
        writer.write(this.category.name());
        if (this.type != null) {
            writer.write(44);
            writer.write(this.type.getClassType());
        }
        writer.write(41);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterType that = (RegisterType)o;
        if (this.category != that.category) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.category.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public static RegisterType getRegisterTypeForType(String type) {
        switch (type.charAt(0)) {
            case 'V': {
                throw new ValidationException("The V type can only be used as a method return type");
            }
            case 'Z': {
                return RegisterType.getRegisterType(Category.Boolean, null);
            }
            case 'B': {
                return RegisterType.getRegisterType(Category.Byte, null);
            }
            case 'S': {
                return RegisterType.getRegisterType(Category.Short, null);
            }
            case 'C': {
                return RegisterType.getRegisterType(Category.Char, null);
            }
            case 'I': {
                return RegisterType.getRegisterType(Category.Integer, null);
            }
            case 'F': {
                return RegisterType.getRegisterType(Category.Float, null);
            }
            case 'J': {
                return RegisterType.getRegisterType(Category.LongLo, null);
            }
            case 'D': {
                return RegisterType.getRegisterType(Category.DoubleLo, null);
            }
            case 'L': 
            case '[': {
                return RegisterType.getRegisterType(Category.Reference, ClassPath.getClassDef(type));
            }
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    public static RegisterType getRegisterTypeForTypeIdItem(TypeIdItem typeIdItem) {
        return RegisterType.getRegisterTypeForType(typeIdItem.getTypeDescriptor());
    }

    public static RegisterType getWideRegisterTypeForTypeIdItem(TypeIdItem typeIdItem, boolean firstRegister) {
        if (typeIdItem.getRegisterCount() == 1) {
            throw new RuntimeException("Cannot use this method for non-wide register type: " + typeIdItem.getTypeDescriptor());
        }
        switch (typeIdItem.getTypeDescriptor().charAt(0)) {
            case 'J': {
                if (firstRegister) {
                    return RegisterType.getRegisterType(Category.LongLo, null);
                }
                return RegisterType.getRegisterType(Category.LongHi, null);
            }
            case 'D': {
                if (firstRegister) {
                    return RegisterType.getRegisterType(Category.DoubleLo, null);
                }
                return RegisterType.getRegisterType(Category.DoubleHi, null);
            }
        }
        throw new RuntimeException("Invalid type: " + typeIdItem.getTypeDescriptor());
    }

    public static RegisterType getRegisterTypeForLiteral(long literalValue) {
        if (literalValue < -32768L) {
            return RegisterType.getRegisterType(Category.Integer, null);
        }
        if (literalValue < -128L) {
            return RegisterType.getRegisterType(Category.Short, null);
        }
        if (literalValue < 0L) {
            return RegisterType.getRegisterType(Category.Byte, null);
        }
        if (literalValue == 0L) {
            return RegisterType.getRegisterType(Category.Null, null);
        }
        if (literalValue == 1L) {
            return RegisterType.getRegisterType(Category.One, null);
        }
        if (literalValue < 128L) {
            return RegisterType.getRegisterType(Category.PosByte, null);
        }
        if (literalValue < 32768L) {
            return RegisterType.getRegisterType(Category.PosShort, null);
        }
        if (literalValue < 65536L) {
            return RegisterType.getRegisterType(Category.Char, null);
        }
        return RegisterType.getRegisterType(Category.Integer, null);
    }

    public RegisterType merge(RegisterType type) {
        if (type == null || type == this) {
            return this;
        }
        Category mergedCategory = Category.mergeTable[this.category.ordinal()][type.category.ordinal()];
        ClassPath.ClassDef mergedType = null;
        if (mergedCategory == Category.Reference) {
            mergedType = ClassPath.getCommonSuperclass(this.type, type.type);
        }
        if (mergedCategory == Category.UninitRef || mergedCategory == Category.UninitThis) {
            if (this.category == Category.Unknown) {
                return type;
            }
            assert (type.category == Category.Unknown);
            return this;
        }
        return RegisterType.getRegisterType(mergedCategory, mergedType);
    }

    public boolean canBeAssignedTo(RegisterType slotType) {
        if (Category.assigmentTable[this.category.ordinal()][slotType.category.ordinal()]) {
            if (this.category == Category.Reference && slotType.category == Category.Reference && !slotType.type.isInterface()) {
                return this.type.extendsClass(slotType.type);
            }
            return true;
        }
        return false;
    }

    public static RegisterType getUnitializedReference(ClassPath.ClassDef classType) {
        return new RegisterType(Category.UninitRef, classType);
    }

    public static RegisterType getRegisterType(Category category, ClassPath.ClassDef classType) {
        RegisterType newRegisterType = new RegisterType(category, classType);
        RegisterType internedRegisterType = internedRegisterTypes.get(newRegisterType);
        if (internedRegisterType == null) {
            internedRegisterTypes.put(newRegisterType, newRegisterType);
            return newRegisterType;
        }
        return internedRegisterType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category {
        Unknown,
        Uninit,
        Null,
        One,
        Boolean,
        Byte,
        PosByte,
        Short,
        PosShort,
        Char,
        Integer,
        Float,
        LongLo,
        LongHi,
        DoubleLo,
        DoubleHi,
        UninitRef,
        UninitThis,
        Reference,
        Conflicted;

        protected static Category[][] mergeTable;
        protected static boolean[][] assigmentTable;

        static {
            mergeTable = new Category[][]{{Unknown, Uninit, Null, One, Boolean, Byte, PosByte, Short, PosShort, Char, Integer, Float, LongLo, LongHi, DoubleLo, DoubleHi, UninitRef, UninitThis, Reference, Conflicted}, {Uninit, Uninit, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Null, Conflicted, Null, Boolean, Boolean, Byte, PosByte, Short, PosShort, Char, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Reference, Conflicted}, {One, Conflicted, Boolean, One, Boolean, Byte, PosByte, Short, PosShort, Char, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Boolean, Conflicted, Boolean, Boolean, Boolean, Byte, PosByte, Short, PosShort, Char, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Byte, Conflicted, Byte, Byte, Byte, Byte, Byte, Short, Short, Integer, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {PosByte, Conflicted, PosByte, PosByte, PosByte, Byte, PosByte, Short, PosShort, Char, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Short, Conflicted, Short, Short, Short, Short, Short, Short, Short, Integer, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {PosShort, Conflicted, PosShort, PosShort, PosShort, Short, PosShort, Short, PosShort, Char, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Char, Conflicted, Char, Char, Char, Integer, Char, Integer, Char, Char, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Integer, Conflicted, Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Float, Conflicted, Float, Float, Float, Float, Float, Float, Float, Float, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {LongLo, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, LongLo, Conflicted, LongLo, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {LongHi, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, LongHi, Conflicted, LongHi, Conflicted, Conflicted, Conflicted, Conflicted}, {DoubleLo, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, LongLo, Conflicted, DoubleLo, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {DoubleHi, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, LongHi, Conflicted, DoubleHi, Conflicted, Conflicted, Conflicted, Conflicted}, {UninitRef, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {UninitThis, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, UninitThis, Conflicted, Conflicted}, {Reference, Conflicted, Reference, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Reference, Conflicted}, {Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}};
            assigmentTable = new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, false, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, false}, {false, false, false, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, true, false, true, true, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, true, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
        }
    }
}

