/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.Renderers.IntegerRenderer;
import org.jf.dexlib.Code.Format.PackedSwitchDataPseudoInstruction;
import org.jf.dexlib.CodeItem;
import org.jf.util.IndentingWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackedSwitchMethodItem
extends InstructionMethodItem<PackedSwitchDataPseudoInstruction>
implements Iterable<LabelMethodItem> {
    private final List<LabelMethodItem> labels;

    public PackedSwitchMethodItem(MethodDefinition methodDefinition, CodeItem codeItem, int codeAddress, PackedSwitchDataPseudoInstruction instruction) {
        super(codeItem, codeAddress, instruction);
        int baseCodeAddress = methodDefinition.getPackedSwitchBaseAddress(codeAddress);
        this.labels = new ArrayList<LabelMethodItem>();
        Iterator<PackedSwitchDataPseudoInstruction.PackedSwitchTarget> iterator = instruction.iterateKeysAndTargets();
        while (iterator.hasNext()) {
            PackedSwitchDataPseudoInstruction.PackedSwitchTarget target = iterator.next();
            LabelMethodItem label = new LabelMethodItem(baseCodeAddress + target.targetAddressOffset, "pswitch_");
            label = methodDefinition.getLabelCache().internLabel(label);
            this.labels.add(label);
        }
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        writer.write(".packed-switch ");
        IntegerRenderer.writeTo(writer, ((PackedSwitchDataPseudoInstruction)this.instruction).getFirstKey());
        writer.indent(4);
        writer.write(10);
        for (LabelMethodItem label : this.labels) {
            label.writeTo(writer);
            writer.write(10);
        }
        writer.deindent(4);
        writer.write(".end packed-switch");
        return true;
    }

    @Override
    public Iterator<LabelMethodItem> iterator() {
        return this.labels.iterator();
    }
}

