/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.net.Uri;
import com.adobe.air.ResourceIdMap;
import com.adobe.air.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class ResourceFileManager {
    private final Context mAppContext;
    private final Resources mAppResources;
    private ResourceIdMap mResourceIdMap = null;

    ResourceFileManager(Context context) {
        this.mAppContext = context;
        this.mAppResources = context.getResources();
        try {
            ClassLoader classLoader = this.mAppContext.getClassLoader();
            Class<?> clazz = classLoader.loadClass(this.mAppContext.getPackageName() + ".R");
            this.mResourceIdMap = new ResourceIdMap(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public InputStream getFileStreamFromRawRes(int n) throws Resources.NotFoundException {
        InputStream inputStream = this.mAppResources.openRawResource(n);
        if (inputStream == null) {
            // empty if block
        }
        return inputStream;
    }

    public String readFileFromRawRes(int n) {
        String string = new String();
        try {
            InputStream inputStream = this.getFileStreamFromRawRes(n);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Utils.writeThrough(inputStream, byteArrayOutputStream);
            string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public InputStream getStream(int n) throws Resources.NotFoundException {
        InputStream inputStream = this.mAppResources.openRawResource(n);
        return inputStream;
    }

    public void extractResource(int n, File file) throws IOException {
        InputStream inputStream = this.getStream(n);
        Utils.writeOut(inputStream, file);
        inputStream.close();
    }

    public boolean resExists(int n) {
        try {
            if (n <= 0) {
                return false;
            }
            InputStream inputStream = this.mAppResources.openRawResource(n);
            return inputStream != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int lookupResId(String string) {
        try {
            if (this.mResourceIdMap != null) {
                return this.mResourceIdMap.getId(string);
            }
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        return -1;
    }

    private String remapSpecialFileNames(String string) {
        if (string.equals("ss.cfg") || string.equals("ss.sgn") || string.equals("mms.cfg")) {
            return string.replace('.', '_');
        }
        return null;
    }

    private boolean resExists(String string) {
        boolean bl = false;
        String string2 = this.remapSpecialFileNames(string);
        if (string2 != null) {
            bl = this.resExists(this.lookupResId("raw." + string2));
        }
        return bl;
    }

    public AssetFileDescriptor GetAssetFileDescriptor(String string) {
        AssetFileDescriptor assetFileDescriptor = null;
        try {
            String string2 = this.remapSpecialFileNames(string);
            String string3 = string2 != null ? string2 : string;
            Uri uri = Uri.parse((String)("android.resource://" + this.mAppContext.getPackageName() + "/raw/" + string3));
            assetFileDescriptor = this.mAppContext.getContentResolver().openAssetFileDescriptor(uri, "r");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return assetFileDescriptor;
    }

    public String getResourceName(int n) {
        try {
            return this.mAppResources.getResourceName(n);
        }
        catch (Exception exception) {
            return "null";
        }
    }

    public String getResourceEntryName(int n) {
        try {
            return this.mAppResources.getResourceEntryName(n);
        }
        catch (Exception exception) {
            return "null";
        }
    }
}

