/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.adobe.air.AndroidActivityWrapper;
import com.adobe.air.AndroidLocale;

public final class ListenErrorDialog {
    private final Activity mActivity;
    private final int PADDING_LENGTH = 20;
    private final int ICON_ERROR = 2130837505;
    private final String mDebuggerPort;

    ListenErrorDialog(Activity activity, int n) {
        this.mActivity = activity;
        this.mDebuggerPort = Integer.toString(n);
    }

    public void createAndShowDialog() {
        LinearLayout linearLayout = new LinearLayout((Context)this.mActivity);
        linearLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        TextView textView = new TextView((Context)this.mActivity);
        textView.setText((CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_DEBUGGER_LISTEN_ERROR_MESSAGE).replaceFirst("%1", this.mDebuggerPort));
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
        textView.setPadding(20, 20, 20, 20);
        linearLayout.addView((View)textView);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.mActivity);
        builder.setIcon(2130837505);
        builder.setView((View)linearLayout);
        builder.setTitle((CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_DEBUGGER_LISTEN_ERROR_TITLE));
        builder.setPositiveButton((CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_CANCEL), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                ListenErrorDialog.this.gotResultFromDialog(false);
            }
        });
        builder.setNegativeButton((CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_CONTINUE), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                ListenErrorDialog.this.gotResultFromDialog(true);
            }
        });
        builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                ListenErrorDialog.this.gotResultFromDialog(false);
            }
        });
        builder.show();
    }

    public void gotResultFromDialog(boolean bl) {
        AndroidActivityWrapper androidActivityWrapper = AndroidActivityWrapper.GetAndroidActivityWrapper();
        if (bl) {
            androidActivityWrapper.gotResultFromDialog(false, "");
        } else {
            this.exitGracefully();
        }
    }

    private void exitGracefully() {
        System.exit(0);
    }
}

