/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.Activity;
import android.content.Context;
import com.adobe.air.AndroidConstants;
import com.adobe.air.ApplicationFileManager;
import com.adobe.air.ResourceFileManager;
import com.adobe.air.utils.AIRLogger;
import com.adobe.air.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;

class DeviceProfiling {
    private static final String PROFILER_HOST_ID = "raw.debugger";
    private static final String PROFILER_RES_ID = "raw.profileragent";
    private static final String LOG_TAG = "DeviceProfiling";
    private static final String PROFILE_CONFIG_FILENAME = "Profiling.cfg";
    private static final int BUFFER_SIZE = 8192;
    private static final String DEFAULT_PROFILER_PORT = "9999";
    private static final String PROFILER_SWF_NAME = "ProfilerAgent.swf";
    private static final String FLASH_TRUST_DIR = "FlashPlayerTrust";
    private static final String MM_DOT_CFG = "mm.cfg";
    private static final String DELIM_STRING = "=";
    private static final String META_INF = "META-INF" + File.separator + "AIR";
    private static ResourceFileManager mResManager;

    DeviceProfiling() {
    }

    public static boolean checkAndInitiateProfiler(Activity activity) {
        mResManager = new ResourceFileManager((Context)activity);
        boolean bl = mResManager.resExists(mResManager.lookupResId(PROFILER_HOST_ID));
        boolean bl2 = mResManager.resExists(mResManager.lookupResId(PROFILER_RES_ID));
        if (!bl || !bl2) {
            AIRLogger.d(LOG_TAG, "Preload SWF/debughost resource does not exist inside the APK" + bl + " " + bl2);
            return false;
        }
        DeviceProfiling.extractProfilerResource();
        DeviceProfiling.insertPreloadTagEntry();
        DeviceProfiling.insertTrustConfigEntry();
        return true;
    }

    private static void extractProfilerResource() {
        File file = new File(ApplicationFileManager.getAppRoot() + File.separator + META_INF + File.separator + PROFILER_SWF_NAME);
        file.getParentFile().mkdirs();
        try {
            mResManager.extractResource(mResManager.lookupResId(PROFILER_RES_ID), file);
        }
        catch (Exception exception) {
            AIRLogger.d(LOG_TAG, " Exception while writing/closing preloadSWF File " + exception.getMessage());
        }
    }

    private static void insertTrustConfigEntry() {
        File file = new File(ApplicationFileManager.getAppRoot() + File.separator + META_INF + File.separator + FLASH_TRUST_DIR);
        file.mkdir();
        File file2 = new File(Utils.GetExternalStorageDirectory() + File.separator + FLASH_TRUST_DIR);
        try {
            Utils.copyTo(file2, file);
        }
        catch (Exception exception) {
            AIRLogger.d(LOG_TAG, "Recursive Copy for FlashPlayerTrust folder failed." + exception.getMessage());
        }
        String string = ApplicationFileManager.getAppRoot() + File.separator + META_INF;
        try {
            File file3 = new File(ApplicationFileManager.getAppRoot() + File.separator + META_INF + File.separator + FLASH_TRUST_DIR + File.separator + PROFILE_CONFIG_FILENAME);
            Utils.writeStringToFile(string, file3);
        }
        catch (Exception exception) {
            AIRLogger.d(LOG_TAG, " Write to FlashPlayerTrust Failed" + exception.getMessage());
        }
    }

    private static void insertPreloadTagEntry() {
        File file = new File(Utils.GetExternalStorageDirectory() + File.separator + "." + "adobe" + File.separator + "AIR" + File.separator + MM_DOT_CFG);
        File file2 = new File(ApplicationFileManager.getAndroidAppDataPath() + File.separator + MM_DOT_CFG);
        File file3 = new File(ApplicationFileManager.getAndroidAppDataPath() + File.separator + AndroidConstants.DEBUGGER_INFO);
        String string = ApplicationFileManager.getAppRoot() + File.separator + META_INF + File.separator + PROFILER_SWF_NAME;
        try {
            mResManager.extractResource(mResManager.lookupResId(PROFILER_HOST_ID), file3);
        }
        catch (Exception exception) {
            AIRLogger.d(LOG_TAG, " Extracting Resource debugInfo failed " + exception.getMessage());
        }
        HashMap<Object, Object> hashMap = new HashMap();
        try {
            hashMap = Utils.parseKeyValuePairFile(file3, new String(DELIM_STRING));
        }
        catch (Exception exception) {
            AIRLogger.d(LOG_TAG, " Parsing for key-value pairs failed/mm.cfg not found " + exception.getMessage());
        }
        String string2 = new String("PreloadSwf=");
        string2 = string2.concat(string);
        string2 = string2.concat("?");
        StringBuffer stringBuffer = new StringBuffer();
        if (hashMap.get("Host") != null) {
            string2 = string2.concat("host=").concat((String)hashMap.get("Host"));
        }
        string2 = string2.concat("&");
        string2 = string2.concat("port=").concat(DEFAULT_PROFILER_PORT);
        if (file.exists()) {
            try {
                String string3;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 8192);
                boolean bl = false;
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.equals(string2)) {
                        bl = true;
                    }
                    stringBuffer.append(string3).append("\n");
                }
                if (!bl) {
                    stringBuffer.append(string2).append("\n");
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                AIRLogger.d(LOG_TAG, "Reading from Configuration file with path" + file.getAbsolutePath() + " failed." + exception.getMessage());
            }
        } else {
            stringBuffer.append(string2).append("\n");
        }
        try {
            Utils.writeBufferToFile(stringBuffer, file2);
        }
        catch (Exception exception) {
            AIRLogger.d(LOG_TAG, " Writing string buffer to file failed " + exception.getMessage());
        }
    }
}

