/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.MediaStore;
import com.adobe.air.AndroidActivityWrapper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class CameraUI
implements AndroidActivityWrapper.ActivityResultCallback {
    public static final int ERROR_CAMERA_BUSY = 1;
    public static final int ERROR_CAMERA_ERROR = 2;
    public static final int ERROR_CAMERA_UNAVAILABLE = 3;
    public static final int ERROR_ACTIVITY_DESTROYED = 4;
    public static final int REQUESTED_MEDIA_TYPE_INVALID = 0;
    public static final int REQUESTED_MEDIA_TYPE_IMAGE = 1;
    public static final int REQUESTED_MEDIA_TYPE_VIDEO = 2;
    private static final String LOG_TAG = "CameraUI";
    private static final String PHONE_STORAGE = "phoneStorage";
    private static String sCameraRollPath = null;
    private static CameraUI sCameraUI = null;
    private long mLastClientId = 0L;
    private boolean mCameraBusy = false;
    private String mImagePath = null;

    private native void nativeOnCameraError(long var1, int var3);

    private native void nativeOnCameraCancel(long var1);

    private native void nativeOnCameraResult(long var1, String var3, String var4, String var5);

    private void onCameraError(int n) {
        if (this.mLastClientId != 0L) {
            this.nativeOnCameraError(this.mLastClientId, n);
            this.mLastClientId = 0L;
        }
    }

    private void onCameraCancel() {
        if (this.mLastClientId != 0L) {
            this.nativeOnCameraCancel(this.mLastClientId);
            this.mLastClientId = 0L;
        }
    }

    private void onCameraResult(String string, String string2, String string3) {
        if (this.mLastClientId != 0L) {
            this.nativeOnCameraResult(this.mLastClientId, string, string2, string3);
            this.mLastClientId = 0L;
        }
    }

    private CameraUI() {
    }

    public static synchronized CameraUI getCameraUI() {
        if (sCameraUI == null) {
            sCameraUI = new CameraUI();
            AndroidActivityWrapper.GetAndroidActivityWrapper().addActivityResultListener(sCameraUI);
        }
        return sCameraUI;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void unregisterCallbacks(long l) {
        if (this.mLastClientId == l) {
            this.mLastClientId = 0L;
        }
    }

    private String toMediaType(String string) {
        String string2 = null;
        if (string != null) {
            if (string.startsWith("image/")) {
                string2 = new String("image");
            } else if (string.startsWith("video/")) {
                string2 = new String("video");
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileFromUri(Uri uri, Activity activity) {
        File file = null;
        String[] stringArray = new String[]{"_data"};
        Cursor cursor = this.getCursorFromUri(uri, activity, stringArray);
        if (cursor != null) {
            try {
                int n = cursor.getColumnIndexOrThrow("_data");
                String string = cursor.getString(n);
                file = new File(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                cursor.close();
                cursor = null;
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cursor getCursorFromUri(Uri uri, Activity activity, String[] stringArray) {
        Cursor cursor;
        block6: {
            boolean bl;
            Cursor cursor2;
            cursor = null;
            try {
                cursor = activity.getContentResolver().query(uri, stringArray, null, null, null);
                if (!cursor.moveToFirst()) break block6;
                cursor2 = cursor;
                bl = cursor != null;
            }
            catch (Throwable throwable) {
                if (cursor != null & !cursor.moveToFirst()) {
                    cursor.close();
                }
                throw throwable;
            }
            if (bl & !cursor.moveToFirst()) {
                cursor.close();
            }
            return cursor2;
        }
        cursor.close();
        Cursor cursor3 = null;
        boolean bl = cursor != null;
        if (bl & !cursor.moveToFirst()) {
            cursor.close();
        }
        return cursor3;
    }

    private void processImageSuccessResult() {
        String string = new String("image");
        File file = new File(this.mImagePath);
        String string2 = file.getName();
        String[] stringArray = new String[]{this.mImagePath};
        MediaScannerConnection.scanFile((Context)AndroidActivityWrapper.GetAndroidActivityWrapper().getDefaultContext(), (String[])stringArray, null, null);
        this.onCameraResult(this.mImagePath, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processVideoSuccessResult(Intent intent) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String[] stringArray = new String[]{"_data", "mime_type", "_display_name"};
        Cursor cursor = this.getCursorFromUri(intent.getData(), AndroidActivityWrapper.GetAndroidActivityWrapper().getActivity(), stringArray);
        if (cursor != null) {
            try {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                n = cursor.getColumnIndexOrThrow("_data");
                n2 = cursor.getColumnIndexOrThrow("mime_type");
                n3 = cursor.getColumnIndexOrThrow("_display_name");
                string = cursor.getString(n);
                if (string != null) {
                    string2 = cursor.getString(n2);
                    string4 = this.toMediaType(string2);
                    if (string4 == null) {
                        string4 = new String("video");
                    }
                    if ((string3 = cursor.getString(n3)) == null) {
                        string3 = new String("");
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                cursor.close();
                cursor = null;
            }
        }
        if (string4 != null && string4.equals("image") || string4.equals("video")) {
            this.onCameraResult(string, string4, string3);
        } else {
            this.onCameraError(2);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        if (n != 3 && n != 4) {
            return;
        }
        this.mCameraBusy = false;
        if (this.mLastClientId == 0L) {
            return;
        }
        switch (n2) {
            case -1: {
                if (n == 3) {
                    if (this.mImagePath != null) {
                        this.processImageSuccessResult();
                        this.mImagePath = null;
                        break;
                    }
                    this.onCameraCancel();
                    break;
                }
                if (n != 4) break;
                this.processVideoSuccessResult(intent);
                break;
            }
            case 0: {
                if (this.mImagePath != null) {
                    this.mImagePath = null;
                }
                this.onCameraCancel();
                break;
            }
            default: {
                if (this.mImagePath != null) {
                    this.mImagePath = null;
                }
                this.onCameraError(2);
            }
        }
    }

    public void launch(long l, int n) {
        if (l == 0L) {
            return;
        }
        if (this.mCameraBusy) {
            this.nativeOnCameraError(l, 1);
            return;
        }
        if (this.mLastClientId != 0L) {
            this.onCameraError(1);
        }
        this.mLastClientId = l;
        this.mCameraBusy = true;
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = this.stillPictureWork();
                break;
            }
            case 2: {
                n2 = this.videoCaptureWork();
                break;
            }
            default: {
                n2 = 3;
            }
        }
        if (n2 != 0) {
            this.mCameraBusy = false;
            this.onCameraError(n2);
        }
    }

    private int videoCaptureWork() {
        int n = 0;
        try {
            Activity activity = AndroidActivityWrapper.GetAndroidActivityWrapper().getActivity();
            if (activity == null) {
                n = 4;
            } else {
                Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
                intent.putExtra("android.intent.extra.videoQuality", 0);
                activity.startActivityForResult(intent, 4);
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            n = 3;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCameraRollDirectory(Activity activity) {
        if (sCameraRollPath != null) {
            return sCameraRollPath;
        }
        Uri uri = null;
        try {
            uri = activity.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new ContentValues());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uri == null) {
            try {
                uri = activity.getContentResolver().insert(MediaStore.Images.Media.getContentUri((String)PHONE_STORAGE), new ContentValues());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (uri != null) {
            try {
                File file = this.getFileFromUri(uri, activity);
                sCameraRollPath = file.getParent();
            }
            catch (ActivityNotFoundException activityNotFoundException) {
            }
            catch (NullPointerException nullPointerException) {
            }
            finally {
                activity.getContentResolver().delete(uri, null, null);
                uri = null;
            }
        }
        return sCameraRollPath;
    }

    private int stillPictureWork() {
        int n = 0;
        Activity activity = AndroidActivityWrapper.GetAndroidActivityWrapper().getActivity();
        if (activity == null) {
            return 4;
        }
        if (this.getCameraRollDirectory(activity) == null) {
            return 2;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("'IMG'_yyyyMMdd_HHmmss");
        String string = simpleDateFormat.format(new Date(System.currentTimeMillis()));
        String string2 = this.getCameraRollDirectory(activity) + "/" + string + ".jpg";
        File file = new File(string2);
        if (file.exists()) {
            return 2;
        }
        try {
            Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
            intent.putExtra("output", (Parcelable)Uri.fromFile((File)file));
            activity.startActivityForResult(intent, 3);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            n = 3;
            string2 = null;
        }
        catch (NullPointerException nullPointerException) {
            n = 2;
            string2 = null;
        }
        this.mImagePath = string2;
        return n;
    }
}

