/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.adobe.air.AndroidActivityWrapper;
import com.adobe.air.FileInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class ApplicationFileManager {
    private final int BUFFER_SIZE = 8192;
    private final int DEFAULT_SIZE = -1;
    private static final String APP_PREFIX = "app";
    private static final String APP_XML_PATH = "META-INF/AIR/application.xml";
    private static final String ASSET_STRING = "assets";
    public static String sAndroidPackageName;
    public static String sApkPath;
    public static String sAppDataPath;
    public static String sInitialContentName;
    private HashMap<Object, Object> mFileInfoMap = new HashMap();

    public static void setAndroidPackageName(String string) {
        sAndroidPackageName = string;
    }

    public static void setAndroidAPKPath(String string) {
        sApkPath = string;
    }

    private static void setAndroidDataPath(String string) {
        sAppDataPath = string;
    }

    public static String getAndroidApkPath() {
        return sApkPath;
    }

    public static String getAndroidAppDataPath() {
        return sAppDataPath;
    }

    public static String getAppXMLRoot() {
        return ApplicationFileManager.getAndroidUnzipContentPath() + File.separatorChar + APP_XML_PATH;
    }

    public static String getAppRoot() {
        return ApplicationFileManager.getAndroidUnzipContentPath() + File.separatorChar + ASSET_STRING;
    }

    public static String getAndroidUnzipContentPath() {
        return sAppDataPath;
    }

    private File getApkPathFile() {
        String string = ApplicationFileManager.getAndroidApkPath();
        File file = new File(string);
        return file;
    }

    private static void setInitialContentName(String string) {
        sInitialContentName = string;
    }

    ApplicationFileManager() {
        this.procZipContents(this.getApkPathFile());
    }

    public static boolean deleteUnzippedContents(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                ApplicationFileManager.deleteUnzippedContents(fileArray[i].getAbsolutePath());
            }
        }
        return file.delete();
    }

    public void deleteFile(String string) {
        File file = new File(string);
        file.delete();
    }

    public void procZipContents(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                FileInfo fileInfo;
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                if (!string.substring(0, ASSET_STRING.length()).equals(ASSET_STRING)) continue;
                FileInfo fileInfo2 = new FileInfo(zipEntry.getSize(), true, false);
                this.mFileInfoMap.put(string, fileInfo2);
                File file2 = new File(string);
                while (file2.getParent() != null && (fileInfo = (FileInfo)this.mFileInfoMap.get(file2.getParent())) == null) {
                    fileInfo = new FileInfo(-1L, false, true);
                    this.mFileInfoMap.put(file2.getParent(), fileInfo);
                    file2 = new File(file2.getParent());
                }
            }
            zipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean fileExists(String string) {
        String string2 = !string.equals("") ? ASSET_STRING + File.separator + string : ASSET_STRING;
        return this.mFileInfoMap.containsKey(string2);
    }

    public boolean isDirectory(String string) {
        String string2 = !string.equals("") ? ASSET_STRING + File.separator + string : ASSET_STRING;
        FileInfo fileInfo = (FileInfo)this.mFileInfoMap.get(string2);
        return fileInfo != null && fileInfo.mIsDirectory;
    }

    public long getLSize(String string) {
        String string2 = ASSET_STRING + File.separator + string;
        FileInfo fileInfo = (FileInfo)this.mFileInfoMap.get(string2);
        if (fileInfo != null && fileInfo.mFileSize != -1L) {
            return fileInfo.mFileSize;
        }
        return 0L;
    }

    public boolean addToCache(String string) {
        return sInitialContentName != null && string.indexOf(sInitialContentName) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readFileName(String string) {
        String string2 = ASSET_STRING + File.separator + string;
        String string3 = ApplicationFileManager.getAndroidUnzipContentPath() + File.separatorChar;
        File file = new File(string3 + string2);
        if (file.exists()) {
            return true;
        }
        File file2 = this.getApkPathFile();
        BufferedOutputStream bufferedOutputStream = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file2);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string4 = zipEntry.getName();
                if (!string4.substring(0, ASSET_STRING.length()).equals(ASSET_STRING)) continue;
                if (string4.equals(string2)) {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    File file3 = new File(file.getParent());
                    file3.mkdirs();
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 8192);
                    byte[] byArray = new byte[8192];
                    int n = 0;
                    while ((n = inputStream.read(byArray)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                    this.closeInputStream(inputStream);
                    this.closeOutputStream(bufferedOutputStream);
                } else {
                    if (!string4.startsWith(string2 + "/")) continue;
                    File file4 = new File(string3 + string2);
                    file4.mkdirs();
                }
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public void copyFolder(String string) {
        String string2 = !string.equals("") ? ASSET_STRING + File.separator + string : ASSET_STRING;
        String string3 = ApplicationFileManager.getAndroidUnzipContentPath() + File.separatorChar;
        File file = this.getApkPathFile();
        BufferedOutputStream bufferedOutputStream = null;
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file), 8192));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string4 = zipEntry.getName();
                if (!string4.substring(0, ASSET_STRING.length()).equals(ASSET_STRING) || !string4.startsWith(string2)) continue;
                File file2 = new File(string3 + string4);
                File file3 = new File(file2.getParent());
                file3.mkdirs();
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2), 8192);
                byte[] byArray = new byte[8192];
                int n = 0;
                while ((n = zipInputStream.read(byArray, 0, 8192)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                this.closeOutputStream(bufferedOutputStream);
            }
            this.closeInputStream(zipInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] appDirectoryNameList(String string) {
        String string2 = !string.equals("") ? ASSET_STRING + File.separator + string : ASSET_STRING;
        Iterator<Object> iterator = this.mFileInfoMap.keySet().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string3.equals(string2) || !string3.startsWith(string2) || -1 != string3.indexOf(File.separator, string2.length() + 1)) continue;
            String string4 = string3.substring(string2.length() + 1);
            arrayList.add(string4);
        }
        return arrayList.toArray(new String[0]);
    }

    public boolean[] appDirectoryTypeList(String string) {
        Object object;
        String string2 = !string.equals("") ? ASSET_STRING + File.separator + string : ASSET_STRING;
        Iterator<Object> iterator = this.mFileInfoMap.keySet().iterator();
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (((String)object).equals(string2) || !((String)object).startsWith(string2) || -1 != ((String)object).indexOf(File.separator, string2.length() + 1)) continue;
            FileInfo fileInfo = (FileInfo)this.mFileInfoMap.get(object);
            Boolean bl = new Boolean(fileInfo.mIsFile);
            arrayList.add(bl);
        }
        object = new boolean[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Boolean)arrayList.get(i);
        }
        arrayList = null;
        return object;
    }

    private static void RefreshAppCache(String string, String string2) {
        File file = new File(string + File.separator + string2);
        if (file.exists()) {
            return;
        }
        ApplicationFileManager.deleteDir(new File(string));
    }

    public static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (ApplicationFileManager.deleteDir(file2)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static void processAndroidDataPath(String string) {
        Object object;
        String string2 = APP_PREFIX;
        String string3 = string + File.separator + APP_PREFIX;
        String string4 = null;
        try {
            object = AndroidActivityWrapper.GetAndroidActivityWrapper().getActivity().getPackageManager().getActivityInfo(AndroidActivityWrapper.GetAndroidActivityWrapper().getActivity().getComponentName(), 128);
            Bundle bundle = ((ActivityInfo)object).metaData;
            if (bundle != null) {
                string2 = (String)bundle.get("uniqueappversionid");
                ApplicationFileManager.RefreshAppCache(string3, string2);
                string4 = (String)bundle.get("initialcontent");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ApplicationFileManager.setAndroidDataPath(string3 + File.separator + string2);
        object = new File(string3 + File.separator + string2);
        ((File)object).mkdirs();
        ApplicationFileManager.setInitialContentName(string4);
    }

    private void closeInputStream(InputStream inputStream) throws Exception {
        inputStream.close();
    }

    private void closeOutputStream(OutputStream outputStream) throws Exception {
        outputStream.flush();
        outputStream.close();
    }

    public static void checkAndCreateAppDataDir() {
        File file = new File(sAppDataPath);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }
}

