/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.SurfaceHolder;
import com.adobe.air.AIRWindowSurfaceView;
import com.adobe.air.AndroidActivityWrapper;
import com.adobe.air.DrawThread;
import java.util.concurrent.Semaphore;

public class AIRWindowThreadedSurfaceView
extends AIRWindowSurfaceView {
    private DrawThread thread = null;
    public final Semaphore drawSemaphore = new Semaphore(0);

    public AIRWindowThreadedSurfaceView(Context context, AndroidActivityWrapper androidActivityWrapper) {
        super(context, androidActivityWrapper);
        this.Init(context);
    }

    protected void Init(Context context) {
        this.thread = new DrawThread(this, this.mSurfaceHolder, context);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        super.surfaceCreated(surfaceHolder);
        this.thread.setRunning(true);
        if (!this.thread.isAlive()) {
            try {
                this.thread.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        super.surfaceChanged(surfaceHolder, n, n2, n3);
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        super.surfaceDestroyed(surfaceHolder);
        boolean bl = true;
        this.thread.setRunning(false);
        while (bl && this.thread.isAlive()) {
            try {
                this.thread.join();
                bl = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void drawBitmap(int n, int n2, int n3, int n4, Bitmap bitmap) {
        this.thread.requestDraw(n, n2, n3, n4, bitmap);
        try {
            this.drawSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawBitmap(int n, int n2, int n3, int n4, Bitmap bitmap, int n5, int n6, int n7, int n8, boolean bl, int n9) {
        this.thread.requestDraw(n, n2, n3, n4, bitmap, n5, n6, n7, n8, bl, n9);
        try {
            this.drawSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

