/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.ResultReceiver;
import android.provider.Settings;
import android.text.ClipboardManager;
import android.text.util.Linkify;
import android.view.ContextMenu;
import android.view.Display;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.adobe.air.AndroidActivityWrapper;
import com.adobe.air.AndroidInputConnection;
import com.adobe.air.AndroidLocale;
import com.adobe.air.AndroidStageText;
import com.adobe.air.AndroidWebView;
import com.adobe.air.Entrypoints;
import com.adobe.air.FlashEGL;
import com.adobe.air.OrientationManager;
import com.adobe.air.TouchEventData;
import com.adobe.air.gestures.AIRGestureListener;
import com.adobe.air.utils.AIRLogger;
import com.adobe.air.utils.Utils;

public class AIRWindowSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final String LOG_TAG = "AIRWindowSurfaceView";
    public final int kMultitouchNone = 0;
    public final int kMultitouchRaw = 1;
    public final int kMultitouchGesture = 2;
    private static final int kDefaultBitsPerPixel = 32;
    private final float kSampleSize = 4.0f;
    private int mWd = 0;
    private int mHt = 0;
    private boolean mSurfaceValid = false;
    private int mSkipHeightFromTop = 0;
    private AndroidActivityWrapper mActivityWrapper;
    protected SurfaceHolder mSurfaceHolder = null;
    protected FlashEGL mFlashEGL = null;
    private int mBoundHeight = 0;
    private int mBoundWidth = 0;
    private int mVisibleBoundWidth = 0;
    private int mVisibleBoundHeight = 0;
    private AIRGestureListener mGestureListener;
    private GestureDetector mGestureDetector;
    private ScaleGestureDetector mScaleGestureDetector;
    private int mMultitouchMode = 0;
    private Paint mPaint = null;
    private Paint mPaintScaled = null;
    private boolean mMaliWorkaround = false;
    private static final int kTouchActionMove = 1;
    private static final int kTouchActionBegin = 2;
    private static final int kTouchActionEnd = 4;
    private static final int kTouchActionHoverMove = 8;
    private static final int kTouchActionHoverBegin = 16;
    private static final int kTouchActionHoverEnd = 32;
    private boolean mHoverInProgress = false;
    private int mHoverMetaState = 0;
    private AndroidInputConnection mInputConnection;
    private int mCurrentOrientation = 0;
    private float mLastTouchedXCoord;
    private float mLastTouchedYCoord;
    private boolean mEatTouchRelease = false;
    private boolean mContextMenuVisible = false;
    private CheckLongPress mLongPressCheck = null;
    private boolean mIsFullScreen = false;
    private boolean mSurfaceChangedForSoftKeyboard = false;
    private boolean mDispatchUserTriggeredSkDeactivate = true;
    private boolean mHideSoftKeyboardOnWindowFocusChange = false;
    private boolean mTrackBallPressed = false;
    private boolean mWindowHasFocus = true;
    private float mDownX;
    private float mDownY;
    private int mScaledTouchSlop;
    private Rect mTextBoxBounds;
    private AndroidWebView mFocusedWebView = null;
    private AndroidWebView mResizedWebView = null;
    private AndroidStageText mFocusedStageText = null;
    private AndroidStageText mResizedStageText = null;
    static final int ID_SELECT_ALL = 0;
    static final int ID_CUT = 1;
    static final int ID_CUT_ALL = 2;
    static final int ID_COPY = 3;
    static final int ID_COPY_ALL = 4;
    static final int ID_PASTE = 5;
    static final int ID_SWITCH_INPUT_METHOD = 6;
    static final int ID_START_SELECTING = 7;
    static final int ID_STOP_SELECTING = 8;
    static final int LONG_PRESS_DELAY = 500;
    static final int MAX_MOVE_ACTION_ALLOWED = 4;
    static final int CURSOR_POS_START_LINE = 0;
    static final int CURSOR_POS_END_LINE = 1;
    static final int CURSOR_POS_START_DOCUMENT = 2;
    static final int CURSOR_POS_END_DOCUMENT = 3;
    static final int POST_TOUCH_MESSAGE_AFTER_DELAY = 0;
    private boolean inTouch = false;
    private MetaKeyState mMetaShiftState = MetaKeyState.INACTIVE;
    private MetaKeyState mMetaAltState = MetaKeyState.INACTIVE;
    private HoverTimeoutHandler mHoverTimeoutHandler = new HoverTimeoutHandler(this);
    InputMethodReceiver mInputMethodReceiver = new InputMethodReceiver();

    private native void nativeDispatchSelectionChangeEvent(boolean var1);

    public native boolean nativeOnDoubleClickListener(float var1, float var2);

    public native boolean nativeOnKeyListener(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6);

    private native void nativeOnSizeChangedListener(int var1, int var2, boolean var3);

    private native void nativeOnFormatChangeListener(int var1);

    public native void nativeShowOriginalRect();

    private native void nativeSetKeyboardVisible(boolean var1);

    private native int nativeGetMultitouchMode();

    private native String nativeGetSelectedText();

    private native void nativeSelectAllText();

    private native boolean nativeIsEditable();

    private native boolean nativeIsTextFieldSelectable();

    private native boolean nativeIsFullScreenInteractive();

    private native void nativeCutText(boolean var1);

    private native void nativeInsertText(String var1);

    public native boolean nativeIsTextSelected();

    private native Rect nativeGetTextBoxBounds();

    private native boolean nativePerformWindowPanning(int var1, int var2);

    private native boolean nativeIsPasswordField();

    private native boolean nativeIsMultiLineTextField();

    private native void nativeMoveCursor(int var1);

    private native void nativeDeleteTextLine();

    public native int nativeGetTextContentLength();

    public native ExtractedText nativeGetTextContent();

    private native boolean nativeIsTextFieldInSelectionMode();

    public native void nativeDispatchUserTriggeredSkDeactivateEvent();

    private native void nativeDispatchFullScreenEvent(boolean var1);

    private native void nativeForceReDraw();

    public AIRWindowSurfaceView(Context context, AndroidActivityWrapper androidActivityWrapper) {
        super(context);
        this.mSurfaceHolder = this.getHolder();
        int n = 1;
        if (androidActivityWrapper.useRGB565()) {
            n = 4;
        }
        this.mSurfaceHolder.setFormat(n);
        this.mActivityWrapper = androidActivityWrapper;
        this.mGestureListener = new AIRGestureListener(context, this);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.mGestureListener, null, false);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this.mGestureListener);
        this.setWillNotDraw(false);
        this.setClickable(true);
        this.setEnabled(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.mScaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.setZOrderMediaOverlay(true);
        this.mActivityWrapper.registerPlane(this, 3);
    }

    public AndroidActivityWrapper getActivityWrapper() {
        return this.mActivityWrapper;
    }

    public View returnThis() {
        return this;
    }

    public void onWindowFocusChanged(boolean bl) {
        this.mWindowHasFocus = bl;
        if (this.mLongPressCheck != null) {
            this.removeCallbacks(this.mLongPressCheck);
        }
        if (this.mHideSoftKeyboardOnWindowFocusChange) {
            InputMethodManager inputMethodManager = this.getInputMethodManager();
            if (inputMethodManager != null) {
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            }
            this.mHideSoftKeyboardOnWindowFocusChange = false;
        }
        if (bl) {
            this.mContextMenuVisible = false;
        }
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (this.AllowOSToHandleKeys(n)) {
            return false;
        }
        int n2 = keyEvent.getUnicodeChar();
        if (this.mMetaShiftState == MetaKeyState.ACTIVE || this.mMetaShiftState == MetaKeyState.LOCKED || this.mMetaAltState == MetaKeyState.ACTIVE || this.mMetaAltState == MetaKeyState.LOCKED) {
            n2 = this.GetMetaKeyCharacter(keyEvent);
        }
        this.HandleMetaKeyAction(keyEvent);
        if (!this.mTrackBallPressed && this.mLongPressCheck != null) {
            this.removeCallbacks(this.mLongPressCheck);
        }
        if (this.mActivityWrapper.isApplicationLaunched() && !this.HandleShortCuts(n, keyEvent)) {
            boolean bl = this.nativeOnKeyListener(keyEvent.getAction(), n, n2, keyEvent.isAltPressed(), keyEvent.isShiftPressed(), keyEvent.isSymPressed());
            if (this.mInputConnection != null) {
                this.mInputConnection.updateIMEText();
            }
            return bl;
        }
        return false;
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (this.AllowOSToHandleKeys(n)) {
            return false;
        }
        int n2 = keyEvent.getUnicodeChar();
        if (this.mMetaShiftState == MetaKeyState.ACTIVE || this.mMetaShiftState == MetaKeyState.LOCKED || this.mMetaAltState == MetaKeyState.ACTIVE || this.mMetaAltState == MetaKeyState.LOCKED) {
            n2 = this.GetMetaKeyCharacter(keyEvent);
        }
        if (this.mLongPressCheck != null) {
            this.removeCallbacks(this.mLongPressCheck);
        }
        if (n == 23) {
            this.mTrackBallPressed = false;
        }
        if (this.mActivityWrapper.isApplicationLaunched()) {
            boolean bl = this.nativeOnKeyListener(keyEvent.getAction(), n, n2, keyEvent.isAltPressed(), keyEvent.isShiftPressed(), keyEvent.isSymPressed());
            if (this.mInputConnection != null) {
                this.mInputConnection.updateIMEText();
            }
            if (!bl && keyEvent.getKeyCode() == 4 && keyEvent.isTracking() && !keyEvent.isCanceled()) {
                this.mActivityWrapper.getActivity().moveTaskToBack(false);
                return true;
            }
            return bl;
        }
        return false;
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 7) {
            return this.onTouchEvent(motionEvent);
        }
        return false;
    }

    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        AIRLogger.d(LOG_TAG, "*** *** onFocusChanged: AIR");
        if (bl && this.mFocusedStageText != null && !this.inTouch) {
            this.mDispatchUserTriggeredSkDeactivate = true;
            this.forceSoftKeyboardDown();
        }
        super.onFocusChanged(bl, n, rect);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n;
        int n2;
        RelativeLayout relativeLayout;
        boolean bl = true;
        this.inTouch = true;
        if (!this.hasFocus() && (relativeLayout = this.mActivityWrapper.getOverlaysLayout(false)) != null) {
            this.requestFocus();
            relativeLayout.clearFocus();
            n2 = relativeLayout.getChildCount();
            for (n = 0; n < n2; ++n) {
                View view = relativeLayout.getChildAt(n);
                if (view == null) continue;
                view.clearFocus();
            }
        }
        int n3 = motionEvent.getAction();
        if ((n3 &= 0xFF) == 5 || n3 == 0) {
            for (n2 = 0; n2 < motionEvent.getPointerCount(); ++n2) {
                n = motionEvent.getPointerId(n2);
                this.mGestureListener.setDownTouchPoint(motionEvent.getX(n2), motionEvent.getY(n2), n);
            }
        }
        if (n3 == 0) {
            this.mGestureListener.mayStartNewTransformGesture();
        }
        if (n3 == 5) {
            this.mGestureListener.setCouldBeTwoFingerTap(1);
            n2 = n3 >> 8;
            this.mGestureListener.setSecondaryPointOfTwoFingerTap(this.mGestureListener.getDownTouchPoint(n2));
        } else if (n3 == 6 && this.mGestureListener.getCouldBeTwoFingerTap() == 1) {
            this.mGestureListener.setCouldBeTwoFingerTap(2);
        } else if (n3 == 1 && this.mGestureListener.getCouldBeTwoFingerTap() == 2) {
            this.mGestureListener.setCouldBeTwoFingerTap(3);
        } else if (n3 != 2) {
            this.mGestureListener.setCouldBeTwoFingerTap(0);
        }
        if (this.mActivityWrapper.isApplicationLaunched()) {
            n2 = motionEvent.getPointerCount();
            n = 0;
            for (int i = 0; i < n2; ++i) {
                TouchEventData touchEventData;
                float f;
                float f2 = motionEvent.getX(i);
                float f3 = motionEvent.getY(i) + (float)this.mSkipHeightFromTop;
                this.mLastTouchedXCoord = f2;
                this.mLastTouchedYCoord = f3;
                int n4 = 1;
                int n5 = motionEvent.getAction();
                int n6 = motionEvent.getPointerId(i);
                boolean bl2 = false;
                int n7 = motionEvent.getMetaState();
                if (n != 0) {
                    n5 = 3;
                    n4 = 4;
                } else if (motionEvent.getPointerCount() == 1 || n6 == motionEvent.getPointerId((n5 & 0xFF00) >> 8)) {
                    switch (n5 &= 0xFF) {
                        case 7: {
                            n4 = 8;
                            this.mHoverTimeoutHandler.setLastMove(System.currentTimeMillis());
                            this.mHoverMetaState = n7;
                            if (this.mHoverInProgress) break;
                            this.mHoverTimeoutHandler.sendEmptyMessageDelayed(0, 500L);
                            bl2 = true;
                            this.mHoverInProgress = true;
                            break;
                        }
                        case 0: 
                        case 5: {
                            n4 = 2;
                            break;
                        }
                        case 3: {
                            n = 1;
                        }
                        case 1: 
                        case 6: {
                            n4 = 4;
                            this.mGestureListener.endTwoFingerGesture();
                            this.mGestureListener.setCheckForSwipe(true);
                            break;
                        }
                        default: {
                            this.mHoverTimeoutHandler.setLastMove(System.currentTimeMillis());
                            n4 = 1;
                        }
                    }
                }
                if (!this.IsTouchEventHandlingAllowed(n4, f2, f3)) continue;
                float f4 = f = motionEvent.getSize(i);
                boolean bl3 = n6 == 0;
                int n8 = motionEvent.getHistorySize();
                float[] fArray = new float[(n8 + 1) * 3];
                int n9 = 0;
                for (int j = 0; j < n8; ++j) {
                    fArray[n9++] = motionEvent.getHistoricalX(i, j);
                    fArray[n9++] = motionEvent.getHistoricalY(i, j);
                    fArray[n9++] = motionEvent.getHistoricalPressure(i, j);
                }
                float f5 = motionEvent.getPressure(i);
                fArray[n9] = f2;
                fArray[n9 + 1] = f3;
                fArray[n9 + 2] = f5;
                n7 &= 0xFFFFFFFE;
                int n10 = 0;
                switch (n4) {
                    case 8: {
                        n10 = 8;
                        if (!bl2) break;
                        n10 |= 0x10;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n10 = 1;
                        break;
                    }
                }
                if (n10 != 0) {
                    touchEventData = new TouchEventData(n10, f2, f3, f5, n6, f, f4, bl3, fArray, n7);
                    boolean bl4 = bl = bl && Entrypoints.registerTouchCallback(0, touchEventData);
                }
                if (n4 == 8 || n4 == 1) continue;
                if (n5 == 3) {
                    n7 |= 1;
                }
                touchEventData = new TouchEventData(n4, f2, f3, f5, n6, f, f4, bl3, null, n7);
                bl = bl && Entrypoints.registerTouchCallback(0, touchEventData);
            }
        } else {
            bl = false;
        }
        bl = bl && this.mScaleGestureDetector.onTouchEvent(motionEvent);
        bl = bl && this.mGestureDetector.onTouchEvent(motionEvent);
        this.inTouch = false;
        return bl;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
    }

    public void setMultitouchMode(int n) {
        this.mMultitouchMode = n;
    }

    public int getMultitouchMode() {
        return this.mMultitouchMode;
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mActivityWrapper.planeStepCascade();
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        Activity activity = this.mActivityWrapper.getActivity();
        Display display = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
        this.mBoundHeight = display.getHeight();
        this.mBoundWidth = display.getWidth();
        this.mVisibleBoundHeight = n3;
        this.mVisibleBoundWidth = n2;
        this.nativeOnFormatChangeListener(n);
        if (!this.mSurfaceValid) {
            this.mSurfaceValid = true;
            this.mActivityWrapper.onSurfaceInitialized();
            this.setMultitouchMode(this.nativeGetMultitouchMode());
        }
        if (this.mSurfaceValid) {
            Configuration configuration = this.getResources().getConfiguration();
            int n4 = configuration.orientation;
            if (n4 == this.mCurrentOrientation) {
                if ((n4 == 1 || n4 == 2) && n3 < this.mHt) {
                    if (n3 == 0) {
                        return;
                    }
                    int bl = this.mHt - n3;
                    if (this.nativePerformWindowPanning(n4, bl)) {
                        this.mSurfaceChangedForSoftKeyboard = true;
                        return;
                    }
                }
            } else {
                this.showSoftKeyboard(false);
                this.nativeDispatchUserTriggeredSkDeactivateEvent();
                this.mDispatchUserTriggeredSkDeactivate = false;
            }
            boolean bl = this.mCurrentOrientation != n4;
            this.mCurrentOrientation = n4;
            this.mWd = n2;
            this.mHt = n3;
            this.nativeOnSizeChangedListener(this.mWd, this.mHt, bl);
            OrientationManager orientationManager = OrientationManager.getOrientationManager();
            if (orientationManager.mDispatchOrientationChangePending) {
                orientationManager.nativeOrientationChanged(orientationManager.mBeforeOrientation, orientationManager.mAfterOrientation);
                orientationManager.mDispatchOrientationChangePending = false;
            }
            this.nativeForceReDraw();
            this.forceSoftKeyboardDown();
        }
    }

    public void forceSoftKeyboardDown() {
        this.nativeShowOriginalRect();
        this.setScrollTo(0);
        if (this.mDispatchUserTriggeredSkDeactivate && this.mSurfaceChangedForSoftKeyboard) {
            this.nativeDispatchUserTriggeredSkDeactivateEvent();
        }
        this.nativeSetKeyboardVisible(false);
        this.mDispatchUserTriggeredSkDeactivate = true;
        this.mSurfaceChangedForSoftKeyboard = false;
    }

    public boolean isSurfaceValid() {
        return this.mSurfaceValid;
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mSurfaceValid = false;
        if (this.mFlashEGL != null) {
            this.mFlashEGL.DestroyWindowSurface();
        }
        this.mActivityWrapper.onSurfaceDestroyed();
        this.mActivityWrapper.planeBreakCascade();
    }

    public void showSoftKeyboard(boolean bl, View view) {
        AIRLogger.d(LOG_TAG, "showSoftKeyboard show: " + bl);
        InputMethodManager inputMethodManager = this.getInputMethodManager();
        if (!bl) {
            if (this.mSurfaceChangedForSoftKeyboard) {
                this.mDispatchUserTriggeredSkDeactivate = false;
            }
            inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            if (this.mInputConnection != null) {
                this.mInputConnection.Reset();
            }
            this.nativeSetKeyboardVisible(false);
        } else {
            inputMethodManager.showSoftInput(view, 0, (ResultReceiver)this.mInputMethodReceiver);
        }
    }

    public void showSoftKeyboard(boolean bl) {
        this.showSoftKeyboard(bl, (View)this);
    }

    public void updateFocusedStageWebView(AndroidWebView androidWebView, boolean bl) {
        if (bl) {
            this.mFocusedWebView = androidWebView;
        } else if (this.mFocusedWebView == androidWebView) {
            this.mFocusedWebView = null;
        }
    }

    public boolean isStageWebViewInFocus() {
        if (this.mFocusedWebView != null) {
            return this.mFocusedWebView.isInTextEditingMode();
        }
        return false;
    }

    public long panStageWebViewInFocus() {
        if (this.mFocusedWebView == null) {
            return 0L;
        }
        this.mResizedWebView = this.mFocusedWebView;
        return this.mFocusedWebView.updateViewBoundsWithKeyboard(this.mHt);
    }

    public void updateFocusedStageText(AndroidStageText androidStageText, boolean bl) {
        if (bl) {
            this.mFocusedStageText = androidStageText;
        } else if (this.mFocusedStageText == androidStageText) {
            this.mFocusedStageText = null;
        }
    }

    public boolean isStageTextInFocus() {
        return this.mFocusedStageText != null;
    }

    public long panStageTextInFocus() {
        if (this.mFocusedStageText == null) {
            return 0L;
        }
        this.mResizedStageText = this.mFocusedStageText;
        return this.mFocusedStageText.updateViewBoundsWithKeyboard(this.mHt);
    }

    private boolean IsIMEInFullScreen() {
        InputMethodManager inputMethodManager = this.getInputMethodManager();
        return inputMethodManager.isFullscreenMode();
    }

    public boolean setScrollTo(final int n) {
        this.mSkipHeightFromTop = n;
        final RelativeLayout relativeLayout = this.mActivityWrapper.getOverlaysLayout(false);
        if (relativeLayout != null) {
            this.post(new Runnable(){

                public void run() {
                    if (n == 0 && AIRWindowSurfaceView.this.mResizedWebView != null) {
                        AIRWindowSurfaceView.this.mResizedWebView.resetGlobalBounds();
                        AIRWindowSurfaceView.this.mResizedWebView = null;
                    }
                    if (n == 0 && AIRWindowSurfaceView.this.mResizedStageText != null) {
                        AIRWindowSurfaceView.this.mResizedStageText.resetGlobalBounds();
                        AIRWindowSurfaceView.this.mResizedStageText = null;
                    }
                    relativeLayout.setPadding(0, -n, 0, 0);
                    relativeLayout.requestLayout();
                }
            });
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(int n, int n2, int n3, int n4, Bitmap bitmap) {
        Rect rect;
        Rect rect2;
        if (!this.mSurfaceValid) {
            return;
        }
        Rect rect3 = rect2 = new Rect(n, n2, n + n3, n2 + n4);
        Canvas canvas = null;
        int n5 = this.mSkipHeightFromTop;
        if (n5 != 0) {
            rect = new Rect(0, n5, this.mWd, this.mHt);
            if (!Rect.intersects((Rect)rect2, (Rect)rect)) {
                return;
            }
            rect3 = new Rect(rect2);
            rect3.intersect(rect);
            rect3.top -= n5;
            rect3.bottom -= n5;
            if (this.mIsFullScreen) {
                Rect rect4 = new Rect(0, rect3.bottom, this.mWd, this.mHt);
                rect3.union(rect4);
            }
            canvas = this.mSurfaceHolder.lockCanvas(rect3);
            if (!this.mIsFullScreen && rect3.bottom > this.mHt - n5) {
                rect3.bottom = this.mHt - n5;
            }
        } else {
            canvas = this.mSurfaceHolder.lockCanvas(rect3);
        }
        try {
            rect = this.mSurfaceHolder;
            synchronized (rect) {
                canvas.clipRect(rect3);
                if (n5 != 0 && this.mIsFullScreen) {
                    canvas.drawColor(-16777216);
                }
                if (this.mMaliWorkaround) {
                    this.mPaint = null;
                    canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                } else if (this.mPaint == null && !this.mActivityWrapper.useRGB565()) {
                    this.mPaint = new Paint();
                    this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
                    this.mPaint.setFilterBitmap(false);
                }
                canvas.drawBitmap(bitmap, 0.0f, (float)(-n5), this.mPaint);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (canvas != null) {
                this.mSurfaceHolder.unlockCanvasAndPost(canvas);
            }
        }
        if (this.mInputConnection != null) {
            this.mInputConnection.updateIMEText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void drawScaled(int var1_1, int var2_2, int var3_3, int var4_4, Bitmap var5_5, int var6_6, int var7_7, int var8_8, int var9_9, boolean var10_10, int var11_11) {
        block21: {
            block19: {
                block20: {
                    if (!this.mSurfaceValid) {
                        return;
                    }
                    var12_12 = null;
                    var13_13 = new Rect(var6_6, var7_7, var6_6 + var8_8, var7_7 + var9_9);
                    var14_15 = null;
                    var15_16 = var13_13;
                    var14_15 = var10_10 != false ? new Rect(0, 0, this.mWd, this.mHt) : new Rect(var6_6, var7_7, var6_6 + var8_8, var7_7 + var9_9);
                    if (this.mSkipHeightFromTop == 0) ** GOTO lbl29
                    var16_17 = this.mSkipHeightFromTop;
                    var17_19 = new Rect(0, var16_17, this.mWd, this.mHt);
                    if (Rect.intersects((Rect)var13_13, (Rect)var17_19)) break block19;
                    if (var12_12 == null) break block20;
                    this.mSurfaceHolder.unlockCanvasAndPost(var12_12);
                }
                return;
            }
            try {
                var15_16 = new Rect(var13_13);
                var15_16.intersect(var17_19);
                var15_16.top -= var16_17;
                var15_16.bottom -= var16_17;
                var13_13 = var15_16;
                if (!var10_10) {
                    var14_15 = var15_16;
                }
                if (!var10_10 && var15_16.bottom > this.mHt - var16_17) {
                    var15_16.bottom = this.mHt - var16_17;
                }
lbl29:
                // 4 sources

                var16_18 = new Rect(var1_1, var2_2, var1_1 + var3_3, var2_2 + var4_4);
                var12_12 = this.mSurfaceHolder.lockCanvas(var14_15);
                var17_19 = this.mSurfaceHolder;
                synchronized (var17_19) {
                    if (var10_10) {
                        var12_12.drawRGB(Color.red((int)var11_11), Color.green((int)var11_11), Color.blue((int)var11_11));
                    }
                    if (this.mMaliWorkaround) {
                        this.mPaint = null;
                        var12_12.drawColor(0, PorterDuff.Mode.CLEAR);
                    } else if (this.mPaintScaled == null && !this.mActivityWrapper.useRGB565()) {
                        this.mPaintScaled = new Paint();
                        this.mPaintScaled.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
                    }
                    var12_12.drawBitmap(var5_5, var16_18, var13_13, this.mPaintScaled);
                }
                ** if (var12_12 == null) goto lbl-1000
            }
            catch (Exception var13_14) {
                if (var12_12 != null) {
                    this.mSurfaceHolder.unlockCanvasAndPost(var12_12);
                }
                break block21;
                catch (Throwable var19_21) {
                    if (var12_12 != null) {
                        this.mSurfaceHolder.unlockCanvasAndPost(var12_12);
                    }
                    throw var19_21;
                }
            }
lbl-1000:
            // 1 sources

            {
                this.mSurfaceHolder.unlockCanvasAndPost(var12_12);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        if (this.mInputConnection != null) {
            this.mInputConnection.updateIMEText();
        }
    }

    public void drawBitmap(int n, int n2, int n3, int n4, Bitmap bitmap) {
        this.draw(n, n2, n3, n4, bitmap);
    }

    public void drawBitmap(int n, int n2, int n3, int n4, Bitmap bitmap, int n5, int n6, int n7, int n8, boolean bl, int n9) {
        this.drawScaled(n, n2, n3, n4, bitmap, n5, n6, n7, n8, bl, n9);
    }

    public boolean getIsFullScreen() {
        return this.mIsFullScreen;
    }

    private static boolean supportsSystemUiVisibilityAPI() {
        int n = Build.VERSION.SDK_INT;
        return n >= 11;
    }

    private static boolean supportsSystemUiFlags() {
        int n = Build.VERSION.SDK_INT;
        return n >= 14;
    }

    private void DoSetOnSystemUiVisibilityChangeListener() {
        final AIRWindowSurfaceView aIRWindowSurfaceView = this;
        this.setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

            public void onSystemUiVisibilityChange(int n) {
                aIRWindowSurfaceView.setOnSystemUiVisibilityChangeListener(null);
                if (aIRWindowSurfaceView.getIsFullScreen()) {
                    aIRWindowSurfaceView.nativeDispatchFullScreenEvent(true);
                } else {
                    aIRWindowSurfaceView.nativeDispatchFullScreenEvent(false);
                }
            }
        });
    }

    public void setFullScreen() {
        Activity activity;
        AIRWindowSurfaceView aIRWindowSurfaceView;
        this.mIsFullScreen = true;
        this.mActivityWrapper.setIsFullScreen(this.mIsFullScreen);
        if (AIRWindowSurfaceView.supportsSystemUiVisibilityAPI()) {
            int n = AIRWindowSurfaceView.supportsSystemUiFlags() ? 1 : 1;
            this.DoSetOnSystemUiVisibilityChangeListener();
            aIRWindowSurfaceView = this;
            aIRWindowSurfaceView.setSystemUiVisibility(n);
        }
        if ((activity = this.mActivityWrapper.getActivity()) != null) {
            aIRWindowSurfaceView = activity.getWindow();
            aIRWindowSurfaceView.setFlags(1024, 1024);
        }
    }

    public void clearFullScreen() {
        Activity activity;
        AIRWindowSurfaceView aIRWindowSurfaceView;
        this.mIsFullScreen = false;
        this.mActivityWrapper.setIsFullScreen(this.mIsFullScreen);
        if (AIRWindowSurfaceView.supportsSystemUiVisibilityAPI()) {
            int n = AIRWindowSurfaceView.supportsSystemUiFlags() ? 0 : 0;
            this.DoSetOnSystemUiVisibilityChangeListener();
            aIRWindowSurfaceView = this;
            aIRWindowSurfaceView.setSystemUiVisibility(n);
        }
        if ((activity = this.mActivityWrapper.getActivity()) != null) {
            aIRWindowSurfaceView = activity.getWindow();
            aIRWindowSurfaceView.clearFlags(1024);
        }
    }

    public int getBoundWidth() {
        return this.mBoundWidth;
    }

    public int getBoundHeight() {
        return this.mBoundHeight;
    }

    public int getVisibleBoundWidth() {
        return this.mVisibleBoundWidth;
    }

    public int getVisibleBoundHeight() {
        return this.mVisibleBoundHeight;
    }

    public int getColorDepth() {
        int n = 32;
        Activity activity = this.mActivityWrapper.getActivity();
        if (activity != null) {
            Display display = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
            PixelFormat pixelFormat = new PixelFormat();
            PixelFormat.getPixelFormatInfo((int)display.getPixelFormat(), (PixelFormat)pixelFormat);
            n = pixelFormat.bitsPerPixel;
        }
        return n;
    }

    public void showActionScript2Warning() {
        Activity activity = this.mActivityWrapper.getActivity();
        if (activity != null) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
            TextView textView = new TextView((Context)activity);
            textView.setText((CharSequence)"Your application is attempting to run ActionScript2.0, which is not supported on smart phone profile. \nSee the Adobe Developer Connection for more info www.adobe.com/devnet");
            Linkify.addLinks((TextView)textView, (int)1);
            builder.setView((View)textView);
            builder.setTitle((CharSequence)"Action Script 2.0");
            builder.setNeutralButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                }
            });
            builder.show();
        }
    }

    public boolean IsLandScape() {
        return this.mCurrentOrientation == 2;
    }

    public boolean onCheckIsTextEditor() {
        return true;
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        if (this.mActivityWrapper.isApplicationLaunched() && this.nativeIsEditable()) {
            editorInfo.imeOptions |= 0x40000000;
            editorInfo.imeOptions |= 6;
            editorInfo.inputType |= 1;
            if (this.nativeIsPasswordField()) {
                editorInfo.inputType |= 0x80;
            }
            if (this.nativeIsMultiLineTextField()) {
                editorInfo.inputType |= 0x20000;
            }
            this.mInputConnection = new AndroidInputConnection(this);
            editorInfo.initialSelStart = -1;
            editorInfo.initialSelEnd = -1;
            editorInfo.initialCapsMode = 0;
        } else {
            this.mInputConnection = null;
        }
        return this.mInputConnection;
    }

    public void RestartInput() {
        this.mMetaShiftState = MetaKeyState.INACTIVE;
        this.mMetaAltState = MetaKeyState.INACTIVE;
        InputMethodManager inputMethodManager = this.getInputMethodManager();
        if (inputMethodManager != null) {
            inputMethodManager.restartInput((View)this);
        }
        if (this.mInputConnection != null) {
            this.mInputConnection.Reset();
        }
    }

    public InputMethodManager getInputMethodManager() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        return inputMethodManager;
    }

    public boolean performLongClick() {
        Rect rect;
        if (this.mWindowHasFocus && (rect = this.nativeGetTextBoxBounds()) != null && (this.mLastTouchedXCoord > (float)rect.left && this.mLastTouchedXCoord < (float)rect.right && this.mLastTouchedYCoord > (float)rect.top && this.mLastTouchedYCoord < (float)rect.bottom || this.mTrackBallPressed)) {
            this.mTrackBallPressed = false;
            if (super.performLongClick()) {
                return true;
            }
        }
        return false;
    }

    protected void onCreateContextMenu(ContextMenu contextMenu) {
        super.onCreateContextMenu(contextMenu);
        if (this.mIsFullScreen && !this.nativeIsFullScreenInteractive()) {
            return;
        }
        ClipboardManager clipboardManager = (ClipboardManager)this.getContext().getSystemService("clipboard");
        MenuHandler menuHandler = new MenuHandler();
        boolean bl = this.nativeIsEditable();
        boolean bl2 = this.nativeIsTextFieldSelectable();
        if (!bl2 && !bl) {
            return;
        }
        if (bl2) {
            boolean bl3;
            boolean bl4 = bl3 = this.nativeGetTextContentLength() > 0;
            if (bl3) {
                contextMenu.add(0, 0, 0, (CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_SELECT_ALL)).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)menuHandler).setAlphabeticShortcut('a');
                if (this.nativeIsTextFieldInSelectionMode()) {
                    contextMenu.add(0, 8, 0, (CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_STOP_SELECTING_TEXT)).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)menuHandler);
                } else {
                    contextMenu.add(0, 7, 0, (CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_SELECT_TEXT)).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)menuHandler);
                }
            }
            if (!this.nativeIsPasswordField() && bl3) {
                boolean bl5 = this.nativeIsTextSelected();
                if (bl) {
                    if (bl5) {
                        contextMenu.add(0, 1, 0, (CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_CUT_STRING)).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)menuHandler).setAlphabeticShortcut('x');
                    } else {
                        contextMenu.add(0, 2, 0, (CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_CUT_ALL_STRING)).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)menuHandler);
                    }
                }
                if (bl5) {
                    contextMenu.add(0, 3, 0, (CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_COPY_STRING)).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)menuHandler).setAlphabeticShortcut('c');
                } else {
                    contextMenu.add(0, 4, 0, (CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_COPY_ALL_STRING)).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)menuHandler);
                }
            }
        }
        if (bl) {
            if (clipboardManager != null && clipboardManager.hasText()) {
                contextMenu.add(0, 5, 0, (CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_PASTE_STRING)).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)menuHandler).setAlphabeticShortcut('v');
            }
            contextMenu.add(0, 6, 0, (CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_INPUT_METHOD_STRING)).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)menuHandler);
        }
        this.mEatTouchRelease = true;
        this.mContextMenuVisible = true;
        contextMenu.setHeaderTitle((CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_CONTEXT_MENU_TITLE_STRING));
    }

    private void postCheckLongPress() {
        if (this.mLongPressCheck == null) {
            this.mLongPressCheck = new CheckLongPress();
        }
        this.postDelayed(this.mLongPressCheck, 500L);
    }

    public boolean onTextBoxContextMenuItem(int n) {
        ClipboardManager clipboardManager = (ClipboardManager)this.getContext().getSystemService("clipboard");
        switch (n) {
            case 0: {
                this.nativeSelectAllText();
                break;
            }
            case 3: {
                String string = this.nativeGetSelectedText();
                if (string != null) {
                    if (this.nativeIsPasswordField()) {
                        string = Utils.ReplaceTextContentWithStars(string);
                    }
                    clipboardManager.setText((CharSequence)string);
                }
                this.SetSelectionMode(false);
                break;
            }
            case 4: {
                CharSequence charSequence = this.nativeGetTextContent().text;
                if (charSequence == null) break;
                if (this.nativeIsPasswordField()) {
                    charSequence = Utils.ReplaceTextContentWithStars(((Object)charSequence).toString());
                }
                clipboardManager.setText(charSequence);
                break;
            }
            case 5: {
                CharSequence charSequence = clipboardManager.getText();
                if (charSequence != null) {
                    this.nativeInsertText(((Object)charSequence).toString());
                }
                this.SetSelectionMode(false);
                break;
            }
            case 7: {
                this.SetSelectionMode(true);
                break;
            }
            case 8: {
                this.SetSelectionMode(false);
                break;
            }
            case 1: {
                String string = this.nativeGetSelectedText();
                if (string != null) {
                    this.nativeCutText(false);
                    if (this.nativeIsPasswordField()) {
                        string = Utils.ReplaceTextContentWithStars(string);
                    }
                    clipboardManager.setText((CharSequence)string);
                }
                this.SetSelectionMode(false);
                break;
            }
            case 2: {
                CharSequence charSequence = this.nativeGetTextContent().text;
                if (charSequence == null) break;
                this.nativeCutText(true);
                if (this.nativeIsPasswordField()) {
                    charSequence = Utils.ReplaceTextContentWithStars(((Object)charSequence).toString());
                }
                clipboardManager.setText(charSequence);
                break;
            }
            case 6: {
                InputMethodManager inputMethodManager = this.getInputMethodManager();
                if (inputMethodManager == null) break;
                inputMethodManager.showInputMethodPicker();
                break;
            }
            default: {
                return false;
            }
        }
        if (this.mInputConnection != null) {
            this.mInputConnection.updateIMEText();
        }
        return true;
    }

    private boolean IsTouchEventHandlingAllowed(int n, float f, float f2) {
        boolean bl = true;
        boolean bl2 = this.IsPointInTextBox(f, f2, n);
        if (n == 2) {
            this.mDownX = f;
            this.mDownY = f2;
            this.mEatTouchRelease = false;
            if (bl2) {
                this.postCheckLongPress();
            }
        } else if (n == 1) {
            if (bl2) {
                if (this.IsTouchMove(f, f2)) {
                    if (this.mLongPressCheck != null) {
                        this.removeCallbacks(this.mLongPressCheck);
                    }
                } else {
                    bl = false;
                }
            }
        } else if (n == 4 && this.mLongPressCheck != null) {
            this.removeCallbacks(this.mLongPressCheck);
        }
        return bl;
    }

    private boolean IsTouchMove(float f, float f2) {
        float f3 = this.mDownX - f;
        float f4 = this.mDownY - f2;
        float f5 = (float)Math.sqrt(f3 * f3 + f4 * f4);
        return f5 >= (float)this.mScaledTouchSlop;
    }

    private boolean IsPointInTextBox(float f, float f2, int n) {
        boolean bl = false;
        if (n == 2) {
            this.mTextBoxBounds = this.nativeGetTextBoxBounds();
        }
        bl = this.mTextBoxBounds != null && (int)f > this.mTextBoxBounds.left && (int)f < this.mTextBoxBounds.right && (int)f2 > this.mTextBoxBounds.top && (int)f2 < this.mTextBoxBounds.bottom;
        if (n == 4) {
            this.mTextBoxBounds = null;
        }
        return bl;
    }

    private void HandleMetaKeyAction(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 59: 
            case 60: {
                if (keyEvent.getRepeatCount() != 0) break;
                this.mMetaShiftState = this.GetMetaKeyState(this.mMetaShiftState, keyEvent.isShiftPressed(), false);
                break;
            }
            case 57: 
            case 58: {
                if (keyEvent.getRepeatCount() != 0) break;
                this.mMetaAltState = this.GetMetaKeyState(this.mMetaAltState, keyEvent.isAltPressed(), false);
                break;
            }
            default: {
                this.mMetaShiftState = this.GetMetaKeyState(this.mMetaShiftState, keyEvent.isShiftPressed(), true);
                this.mMetaAltState = this.GetMetaKeyState(this.mMetaAltState, keyEvent.isAltPressed(), true);
            }
        }
    }

    private MetaKeyState GetMetaKeyState(MetaKeyState metaKeyState, boolean bl, boolean bl2) {
        if (bl2) {
            switch (metaKeyState) {
                case INACTIVE: 
                case PRESSED: {
                    return bl ? MetaKeyState.PRESSED : MetaKeyState.INACTIVE;
                }
                case ACTIVE: {
                    return bl ? MetaKeyState.PRESSED : MetaKeyState.INACTIVE;
                }
                case LOCKED: {
                    return MetaKeyState.LOCKED;
                }
            }
            return MetaKeyState.INACTIVE;
        }
        if (bl) {
            switch (metaKeyState) {
                case INACTIVE: 
                case PRESSED: {
                    return MetaKeyState.ACTIVE;
                }
                case ACTIVE: {
                    return MetaKeyState.LOCKED;
                }
            }
            return MetaKeyState.INACTIVE;
        }
        return MetaKeyState.INACTIVE;
    }

    int GetMetaKeyCharacter(KeyEvent keyEvent) {
        int n = 0;
        if (this.mMetaShiftState == MetaKeyState.LOCKED || this.mMetaShiftState == MetaKeyState.ACTIVE) {
            n |= 1;
        }
        if (this.mMetaAltState == MetaKeyState.LOCKED || this.mMetaAltState == MetaKeyState.ACTIVE) {
            n |= 2;
        }
        return keyEvent.getUnicodeChar(n);
    }

    private boolean AllowOSToHandleKeys(int n) {
        switch (n) {
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public void HideSoftKeyboardOnWindowFocusChange() {
        this.mHideSoftKeyboardOnWindowFocusChange = true;
    }

    private boolean HandleShortCuts(int n, KeyEvent keyEvent) {
        if (n == 23) {
            if (!this.mTrackBallPressed && !this.mContextMenuVisible) {
                this.mTrackBallPressed = true;
                this.postCheckLongPress();
                return false;
            }
            return true;
        }
        boolean bl = false;
        if (keyEvent.isAltPressed()) {
            bl = true;
            switch (n) {
                case 67: {
                    this.nativeDeleteTextLine();
                    break;
                }
                case 21: {
                    this.nativeMoveCursor(0);
                    break;
                }
                case 22: {
                    this.nativeMoveCursor(1);
                    break;
                }
                case 19: {
                    this.nativeMoveCursor(2);
                    break;
                }
                case 20: {
                    this.nativeMoveCursor(3);
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public void setInputConnection(AndroidInputConnection androidInputConnection) {
        this.mInputConnection = androidInputConnection;
    }

    public void setFlashEGL(FlashEGL flashEGL) {
        this.mFlashEGL = flashEGL;
    }

    public boolean IsPasswordVisibleSettingEnabled() {
        try {
            return Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"show_password") == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean IsTouchUpHandlingAllowed() {
        return !this.mEatTouchRelease;
    }

    public void SetSelectionMode(boolean bl) {
        this.nativeDispatchSelectionChangeEvent(bl);
    }

    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        if (n == 4 && keyEvent.getAction() == 0) {
            this.DispatchSoftKeyboardEventOnBackKey();
        }
        return false;
    }

    public void DispatchSoftKeyboardEventOnBackKey() {
        if (this.mIsFullScreen && !this.mSurfaceChangedForSoftKeyboard || this.mFlashEGL != null || this.IsIMEInFullScreen() || !this.mSurfaceChangedForSoftKeyboard && !this.nativeIsEditable()) {
            this.nativeDispatchUserTriggeredSkDeactivateEvent();
            if (!this.mSurfaceChangedForSoftKeyboard && !this.nativeIsEditable()) {
                this.nativeShowOriginalRect();
            }
        }
    }

    public boolean IsSurfaceChangedForSoftKeyboard() {
        return this.mSurfaceChangedForSoftKeyboard;
    }

    public int getKeyboardHeight() {
        return this.mHt - this.getVisibleBoundHeight();
    }

    public void SetSurfaceChangedForSoftKeyboard(boolean bl) {
        this.mSurfaceChangedForSoftKeyboard = bl;
    }

    public boolean gatherTransparentRegion(Region region) {
        int[] nArray = new int[2];
        this.getLocationInWindow(nArray);
        region.op(nArray[0], nArray[1], this.mVisibleBoundWidth, this.mVisibleBoundHeight, Region.Op.REPLACE);
        return false;
    }

    private class MenuHandler
    implements MenuItem.OnMenuItemClickListener {
        private MenuHandler() {
        }

        public boolean onMenuItemClick(MenuItem menuItem) {
            return AIRWindowSurfaceView.this.onTextBoxContextMenuItem(menuItem.getItemId());
        }
    }

    class CheckLongPress
    implements Runnable {
        CheckLongPress() {
        }

        public void run() {
            AIRWindowSurfaceView.this.performLongClick();
        }
    }

    class InputMethodReceiver
    extends ResultReceiver {
        public InputMethodReceiver() {
            super(AIRWindowSurfaceView.this.getHandler());
        }

        protected void onReceiveResult(int n, Bundle bundle) {
            if (n == 1 || n == 3) {
                AIRWindowSurfaceView.this.nativeShowOriginalRect();
            } else {
                AIRWindowSurfaceView.this.nativeSetKeyboardVisible(true);
            }
        }
    }

    class HoverTimeoutHandler
    extends Handler {
        static final int INTERVAL = 500;
        private long mLastMove;
        private AIRWindowSurfaceView mAIRWindowSurfaceView;

        public HoverTimeoutHandler(AIRWindowSurfaceView aIRWindowSurfaceView2) {
            this.mAIRWindowSurfaceView = aIRWindowSurfaceView2;
        }

        public void handleMessage(Message message) {
            if (System.currentTimeMillis() - this.mLastMove >= 500L) {
                AIRWindowSurfaceView.this.mHoverInProgress = false;
                TouchEventData touchEventData = new TouchEventData(32, this.mAIRWindowSurfaceView.mLastTouchedXCoord, this.mAIRWindowSurfaceView.mLastTouchedYCoord, 0.0f, 0, 0.0f, 0.0f, true, null, this.mAIRWindowSurfaceView.mHoverMetaState);
                Entrypoints.registerTouchCallback(0, touchEventData);
            } else {
                AIRWindowSurfaceView.this.mHoverTimeoutHandler.sendEmptyMessageDelayed(0, 500L);
            }
        }

        public void setLastMove(long l) {
            this.mLastMove = l;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MetaKeyState {
        INACTIVE,
        ACTIVE,
        PRESSED,
        LOCKED;

    }
}

