/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGSyntax;
import org.w3c.dom.Element;

public abstract class SwingSVGPrettyPrint
implements SVGSyntax {
    public static void print(JComponent jComponent, SVGGraphics2D sVGGraphics2D) {
        if (jComponent instanceof JComboBox || jComponent instanceof JScrollBar) {
            SwingSVGPrettyPrint.printHack(jComponent, sVGGraphics2D);
            return;
        }
        SVGGraphics2D sVGGraphics2D2 = (SVGGraphics2D)sVGGraphics2D.create();
        sVGGraphics2D2.setColor(jComponent.getForeground());
        sVGGraphics2D2.setFont(jComponent.getFont());
        Element element = sVGGraphics2D2.getTopLevelGroup();
        if (jComponent.getWidth() <= 0 || jComponent.getHeight() <= 0) {
            return;
        }
        Rectangle rectangle = sVGGraphics2D2.getClipBounds();
        if (rectangle == null) {
            sVGGraphics2D2.setClip(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        SwingSVGPrettyPrint.paintComponent(jComponent, sVGGraphics2D2);
        SwingSVGPrettyPrint.paintBorder(jComponent, sVGGraphics2D2);
        SwingSVGPrettyPrint.paintChildren(jComponent, sVGGraphics2D2);
        Element element2 = sVGGraphics2D2.getTopLevelGroup();
        element2.setAttributeNS(null, "id", sVGGraphics2D.getGeneratorContext().idGenerator.generateID(jComponent.getClass().getName()));
        element.appendChild(element2);
        sVGGraphics2D.setTopLevelGroup(element);
    }

    private static void printHack(JComponent jComponent, SVGGraphics2D sVGGraphics2D) {
        SVGGraphics2D sVGGraphics2D2 = (SVGGraphics2D)sVGGraphics2D.create();
        sVGGraphics2D2.setColor(jComponent.getForeground());
        sVGGraphics2D2.setFont(jComponent.getFont());
        Element element = sVGGraphics2D2.getTopLevelGroup();
        if (jComponent.getWidth() <= 0 || jComponent.getHeight() <= 0) {
            return;
        }
        Rectangle rectangle = sVGGraphics2D2.getClipBounds();
        if (rectangle == null) {
            sVGGraphics2D2.setClip(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        jComponent.paint(sVGGraphics2D2);
        Element element2 = sVGGraphics2D2.getTopLevelGroup();
        element2.setAttributeNS(null, "id", sVGGraphics2D.getGeneratorContext().idGenerator.generateID(jComponent.getClass().getName()));
        element.appendChild(element2);
        sVGGraphics2D.setTopLevelGroup(element);
    }

    private static void paintComponent(JComponent jComponent, SVGGraphics2D sVGGraphics2D) {
        ComponentUI componentUI = UIManager.getUI(jComponent);
        if (componentUI != null) {
            componentUI.installUI(jComponent);
            componentUI.update(sVGGraphics2D, jComponent);
        }
    }

    private static void paintBorder(JComponent jComponent, SVGGraphics2D sVGGraphics2D) {
        Border border = jComponent.getBorder();
        if (border != null) {
            if (jComponent instanceof AbstractButton || jComponent instanceof JPopupMenu || jComponent instanceof JToolBar || jComponent instanceof JMenuBar || jComponent instanceof JProgressBar) {
                if (jComponent instanceof AbstractButton && ((AbstractButton)jComponent).isBorderPainted() || jComponent instanceof JPopupMenu && ((JPopupMenu)jComponent).isBorderPainted() || jComponent instanceof JToolBar && ((JToolBar)jComponent).isBorderPainted() || jComponent instanceof JMenuBar && ((JMenuBar)jComponent).isBorderPainted() || jComponent instanceof JProgressBar && ((JProgressBar)jComponent).isBorderPainted()) {
                    border.paintBorder(jComponent, sVGGraphics2D, 0, 0, jComponent.getWidth(), jComponent.getHeight());
                }
            } else {
                border.paintBorder(jComponent, sVGGraphics2D, 0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
        }
    }

    private static void paintChildren(JComponent jComponent, SVGGraphics2D sVGGraphics2D) {
        boolean bl = false;
        Rectangle rectangle = new Rectangle();
        for (int i = jComponent.getComponentCount() - 1; i >= 0; --i) {
            Component component = jComponent.getComponent(i);
            if (component == null || !JComponent.isLightweightComponent(component) || !component.isVisible()) continue;
            Rectangle rectangle2 = null;
            bl = component instanceof JComponent;
            if (bl) {
                rectangle2 = rectangle;
                ((JComponent)component).getBounds(rectangle2);
            } else {
                rectangle2 = component.getBounds();
            }
            boolean bl2 = sVGGraphics2D.hitClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            if (!bl2) continue;
            SVGGraphics2D sVGGraphics2D2 = (SVGGraphics2D)sVGGraphics2D.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            sVGGraphics2D2.setColor(component.getForeground());
            sVGGraphics2D2.setFont(component.getFont());
            if (component instanceof JComponent) {
                SwingSVGPrettyPrint.print((JComponent)component, sVGGraphics2D2);
                continue;
            }
            component.paint(sVGGraphics2D2);
        }
    }
}

