/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.expression;

import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.expression.ASTBuilder;
import flash.tools.debugger.expression.Context;
import flash.tools.debugger.expression.ECMA;
import flash.tools.debugger.expression.ExpressionEvaluatorException;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;
import java.util.ArrayList;
import java.util.HashMap;
import macromedia.asc.parser.ApplyTypeExprNode;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryClassDefNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.BinaryFunctionDefinitionNode;
import macromedia.asc.parser.BinaryInterfaceDefinitionNode;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.BoxNode;
import macromedia.asc.parser.BreakStatementNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.CaseLabelNode;
import macromedia.asc.parser.CatchClauseNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ClassNameNode;
import macromedia.asc.parser.CoerceNode;
import macromedia.asc.parser.ConditionalExpressionNode;
import macromedia.asc.parser.ConfigNamespaceDefinitionNode;
import macromedia.asc.parser.ContinueStatementNode;
import macromedia.asc.parser.DefaultXMLNamespaceNode;
import macromedia.asc.parser.DeleteExpressionNode;
import macromedia.asc.parser.DoStatementNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.EmptyElementNode;
import macromedia.asc.parser.EmptyStatementNode;
import macromedia.asc.parser.ErrorNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FinallyClauseNode;
import macromedia.asc.parser.ForStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.HasNextNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.IfStatementNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.ImportNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.IncrementNode;
import macromedia.asc.parser.InheritanceNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.InvokeNode;
import macromedia.asc.parser.LabeledStatementNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralFieldNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralRegExpNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.LiteralVectorNode;
import macromedia.asc.parser.LiteralXMLNode;
import macromedia.asc.parser.LoadRegisterNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ParenExpressionNode;
import macromedia.asc.parser.ParenListExpressionNode;
import macromedia.asc.parser.PragmaExpressionNode;
import macromedia.asc.parser.PragmaNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedExpressionNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.RegisterNode;
import macromedia.asc.parser.RestExpressionNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.StoreRegisterNode;
import macromedia.asc.parser.SuperExpressionNode;
import macromedia.asc.parser.SuperStatementNode;
import macromedia.asc.parser.SwitchStatementNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.ThrowStatementNode;
import macromedia.asc.parser.ToObjectNode;
import macromedia.asc.parser.TryStatementNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.UnaryExpressionNode;
import macromedia.asc.parser.UntypedVariableBindingNode;
import macromedia.asc.parser.UseDirectiveNode;
import macromedia.asc.parser.UseNumericNode;
import macromedia.asc.parser.UsePrecisionNode;
import macromedia.asc.parser.UseRoundingNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.parser.WhileStatementNode;
import macromedia.asc.parser.WithStatementNode;
import macromedia.asc.semantics.ObjectValue;

class DebuggerEvaluator
implements Evaluator {
    DebuggerEvaluator() {
    }

    private Context eeContext(macromedia.asc.util.Context cx) {
        return ((ExpressionEvaluatorScope)cx.scope()).expressionEvaluatorContext;
    }

    public boolean checkFeature(macromedia.asc.util.Context cx, Node node) {
        return true;
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, Node node) {
        return null;
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, IncrementNode node) {
        try {
            Context debuggerContext = this.eeContext(cx);
            DebuggerValue expr = (DebuggerValue)this.getOrSet(cx, node);
            String memberName = ECMA.toString(debuggerContext.getSession(), debuggerContext.toValue(expr.debuggerValue));
            Object lookupResult = debuggerContext.lookup(memberName);
            double before = ECMA.toNumber(debuggerContext.getSession(), debuggerContext.toValue(lookupResult));
            assert (node.op == -3 || node.op == -43);
            double after = node.op == -3 ? before - 1.0 : before + 1.0;
            debuggerContext.assign(memberName, debuggerContext.toValue(new Double(after)));
            Double result = node.isPostfix ? new Double(before) : new Double(after);
            return new DebuggerValue(result);
        }
        catch (NoSuchVariableException e) {
            throw new ExpressionEvaluatorException(e);
        }
        catch (PlayerFaultException e) {
            throw new ExpressionEvaluatorException(e);
        }
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, DeleteExpressionNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("delete"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, IdentifierNode node) {
        String name = node.isAttr() ? "@" + node.name : node.name;
        return new DebuggerValue(name);
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, InvokeNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("expressionNotSupported"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ThisExpressionNode node) {
        try {
            return new DebuggerValue(this.eeContext(cx).lookup("this"));
        }
        catch (NoSuchVariableException e) {
            throw new ExpressionEvaluatorException(e);
        }
        catch (PlayerFaultException e) {
            throw new ExpressionEvaluatorException(e);
        }
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, QualifiedIdentifierNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, QualifiedExpressionNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, LiteralBooleanNode node) {
        return new DebuggerValue(new Boolean(node.value));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, LiteralNumberNode node) {
        String numberStr = node.value;
        if (numberStr != null && (numberStr.startsWith("0x") || numberStr.startsWith("0X"))) {
            numberStr = numberStr + "p0";
        }
        return new DebuggerValue(new Double(numberStr));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, LiteralStringNode node) {
        return new DebuggerValue(node.value);
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, LiteralNullNode node) {
        return new DebuggerValue(null);
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, LiteralRegExpNode node) {
        String flags;
        String re;
        if (node.value.length() > 0 && node.value.charAt(0) == '/') {
            int lastSlash = node.value.lastIndexOf(47);
            re = node.value.substring(1, lastSlash);
            flags = node.value.substring(lastSlash + 1);
        } else {
            re = node.value;
            flags = "";
        }
        try {
            return new DebuggerValue(this.callFunction(this.eeContext(cx), true, "RegExp", new Object[]{re, flags}));
        }
        catch (PlayerDebugException e) {
            throw new ExpressionEvaluatorException(e);
        }
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, LiteralXMLNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("xmlLiteralsNotSupported"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, FunctionCommonNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("functionDefinitionNotAllowed"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ParenExpressionNode node) {
        return node.expr.evaluate(cx, this);
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ParenListExpressionNode node) {
        return node.expr.evaluate(cx, this);
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, LiteralObjectNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("literalObjectsNotSupported"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, LiteralFieldNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("literalObjectsNotSupported"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, LiteralArrayNode node) {
        ArrayList<Object> arrayElements = new ArrayList<Object>();
        if (node.elementlist != null && node.elementlist.items != null) {
            for (Node arrayEntry : node.elementlist.items) {
                DebuggerValue dv = (DebuggerValue)arrayEntry.evaluate(cx, this);
                arrayElements.add(dv.debuggerValue);
            }
        }
        try {
            Context eeContext = this.eeContext(cx);
            Object array = this.callFunction(eeContext, true, "Array", new Object[0]);
            return new DebuggerValue(this.callFunction(eeContext.createContext(array), false, "concat", arrayElements.toArray()));
        }
        catch (PlayerDebugException e) {
            throw new ExpressionEvaluatorException(e);
        }
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, LiteralVectorNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, SuperExpressionNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("super"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, SuperStatementNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("super"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, MemberExpressionNode node) {
        DebuggerValue lhs = node.base != null ? (DebuggerValue)node.base.evaluate(cx, this) : null;
        Context context = this.eeContext(cx);
        boolean pushedScope = false;
        if (lhs != null) {
            Value lhsValue = context.toValue(lhs.debuggerValue);
            if (ECMA.equals(context.getSession(), lhsValue, context.toValue(null))) {
                throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("nullPointerException"));
            }
            Context newContext = context.createContext(lhs.debuggerValue);
            cx.pushScope(new ExpressionEvaluatorScope(newContext));
            pushedScope = true;
        }
        try {
            macromedia.asc.semantics.Value value = node.selector.evaluate(cx, this);
            return value;
        }
        finally {
            if (pushedScope) {
                cx.popScope();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, CallExpressionNode node) {
        assert (node.getMode() == -29 || node.getMode() == -13 || node.getMode() == -19 || node.getMode() == -133 || node.getMode() == -18);
        DebuggerValue func = null;
        Context context = this.eeContext(cx);
        func = (DebuggerValue)node.expr.evaluate(cx, this);
        int argcount = node.args != null ? node.args.items.size() : 0;
        ArrayList<Object> args = new ArrayList<Object>(argcount);
        if (argcount > 0) {
            boolean temporarilyRemoveTopScope = node.getMode() == -18;
            ObjectValue topScope = null;
            if (temporarilyRemoveTopScope) {
                topScope = cx.scope();
                cx.popScope();
            }
            try {
                for (Node argNode : node.args.items) {
                    DebuggerValue argValue = (DebuggerValue)argNode.evaluate(cx, this);
                    args.add(argValue.debuggerValue);
                }
            }
            finally {
                if (temporarilyRemoveTopScope) {
                    cx.pushScope(topScope);
                }
            }
        }
        try {
            return new DebuggerValue(this.callFunction(context, node.is_new, func.debuggerValue, args.toArray()));
        }
        catch (PlayerDebugException e) {
            throw new ExpressionEvaluatorException(e);
        }
    }

    private Object callFunction(Context cx, boolean isConstructor, Object function, Object[] args) throws PlayerDebugException {
        Session session = cx.getSession();
        Value thisObject = cx.toValue();
        if (thisObject == null) {
            thisObject = DValue.forPrimitive(null);
        }
        Value[] valueArgs = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            valueArgs[i] = cx.toValue(args[i]);
        }
        String functionName = function instanceof Variable ? ((Variable)function).getQualifiedName() : function.toString();
        if (isConstructor) {
            return session.callConstructor(functionName, valueArgs);
        }
        return session.callFunction(thisObject, functionName, valueArgs);
    }

    private boolean isXMLType(Value value) {
        String typename = value.getTypeName();
        int at = typename.indexOf(64);
        if (at != -1) {
            typename = typename.substring(0, at);
        }
        return typename.equals("XML") || typename.equals("XMLList");
    }

    private boolean isNumericIndex(GetExpressionNode node, Object index) {
        if (node.getMode() != -29) {
            return false;
        }
        if (index instanceof Double) {
            return true;
        }
        if (index instanceof String) {
            String s = (String)index;
            if (s.length() == 0) {
                return false;
            }
            try {
                Double.parseDouble(s);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, GetExpressionNode node) {
        Object lookupResult;
        DebuggerValue rhs = (DebuggerValue)this.getOrSet(cx, node);
        Context context = this.eeContext(cx);
        String name = ECMA.toString(context.getSession(), context.toValue(rhs.debuggerValue));
        Value contextValue = context.toValue();
        if (contextValue != null && this.isXMLType(contextValue) && !this.isNumericIndex(node, rhs.debuggerValue)) {
            Object arg;
            String function;
            if (name.length() > 0 && name.charAt(0) == '@') {
                function = "attribute";
                arg = name.substring(1);
            } else {
                arg = rhs.debuggerValue;
                function = node.getMode() == -19 ? "descendants" : "child";
            }
            try {
                return new DebuggerValue(this.callFunction(context, false, function, new Object[]{arg}));
            }
            catch (PlayerDebugException e) {
                throw new ExpressionEvaluatorException(e);
            }
        }
        if (contextValue != null && contextValue.getType() == 2 && name.equals("length")) {
            String valuestr = contextValue.getValueAsString();
            return new DebuggerValue(new Double(valuestr.length()));
        }
        try {
            lookupResult = context.lookup(ECMA.toString(this.eeContext(cx).getSession(), this.eeContext(cx).toValue(rhs.debuggerValue)));
        }
        catch (NoSuchVariableException e) {
            throw new ExpressionEvaluatorException(e);
        }
        catch (PlayerFaultException e) {
            throw new ExpressionEvaluatorException(e);
        }
        return new DebuggerValue(lookupResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public macromedia.asc.semantics.Value getOrSet(macromedia.asc.util.Context cx, SelectorNode node) {
        assert (node.getMode() == -29 || node.getMode() == -13 || node.getMode() == -19 || node.getMode() == -133 || node.getMode() == -18);
        cx.pushScope(cx.scope(0));
        try {
            macromedia.asc.semantics.Value value = node.expr.evaluate(cx, this);
            return value;
        }
        finally {
            cx.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, SetExpressionNode node) {
        Context eeContext = this.eeContext(cx);
        DebuggerValue rhs = (DebuggerValue)this.getOrSet(cx, node);
        Object variableToAssignTo = node.getMode() == -29 || node.getMode() == -133 ? ECMA.toString(eeContext.getSession(), eeContext.toValue(rhs.debuggerValue)) : rhs.debuggerValue;
        DebuggerValue newValue = null;
        cx.pushScope(cx.scope(0));
        try {
            newValue = (DebuggerValue)node.args.evaluate(cx, this);
        }
        finally {
            cx.popScope();
        }
        try {
            eeContext.assign(variableToAssignTo, eeContext.toValue(newValue.debuggerValue));
        }
        catch (NoSuchVariableException e) {
            throw new ExpressionEvaluatorException(e);
        }
        catch (PlayerFaultException e) {
            throw new ExpressionEvaluatorException(e);
        }
        return newValue;
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, UnaryExpressionNode node) {
        DebuggerValue arg = (DebuggerValue)node.expr.evaluate(cx, this);
        switch (node.op) {
            case -113: {
                this.eeContext(cx).toValue(arg.debuggerValue);
                return new DebuggerValue(Value.UNDEFINED);
            }
            case -110: {
                Value value = this.eeContext(cx).toValue(arg.debuggerValue);
                switch (value.getType()) {
                    case 7: {
                        return new DebuggerValue("undefined");
                    }
                    case 6: {
                        return new DebuggerValue("object");
                    }
                    case 1: {
                        return new DebuggerValue("boolean");
                    }
                    case 0: {
                        return new DebuggerValue("number");
                    }
                    case 2: {
                        return new DebuggerValue("string");
                    }
                    case 3: {
                        String typeName = value.getTypeName();
                        int at = typeName.indexOf(64);
                        if (at != -1) {
                            typeName = typeName.substring(0, at);
                        }
                        if (!typeName.equals("XML") && !typeName.equals("XMLList")) break;
                        return new DebuggerValue("xml");
                    }
                }
                return new DebuggerValue("object");
            }
            case -42: {
                return new DebuggerValue(new Double(ECMA.toNumber(this.eeContext(cx).getSession(), this.eeContext(cx).toValue(arg.debuggerValue))));
            }
            case -2: {
                return new DebuggerValue(new Double(-ECMA.toNumber(this.eeContext(cx).getSession(), this.eeContext(cx).toValue(arg.debuggerValue))));
            }
            case -41: {
                return new DebuggerValue(new Double(~ECMA.toInt32(this.eeContext(cx).getSession(), this.eeContext(cx).toValue(arg.debuggerValue))));
            }
            case -4: {
                return new DebuggerValue(new Boolean(!ECMA.toBoolean(this.eeContext(cx).toValue(arg.debuggerValue))));
            }
        }
        cx.internalError(ASTBuilder.getLocalizationManager().getLocalizedTextString("unrecognizedUnaryOperator"));
        return null;
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, BinaryExpressionNode node) {
        DebuggerValue lhs = (DebuggerValue)node.lhs.evaluate(cx, this);
        DebuggerValue rhs = null;
        if (node.op != -10 && node.op != -37) {
            rhs = (DebuggerValue)node.rhs.evaluate(cx, this);
        }
        Context eeContext = this.eeContext(cx);
        Session session = eeContext.getSession();
        switch (node.op) {
            case -15: {
                double d1 = ECMA.toNumber(session, eeContext.toValue(lhs.debuggerValue));
                double d2 = ECMA.toNumber(session, eeContext.toValue(rhs.debuggerValue));
                return new DebuggerValue(new Double(d1 * d2));
            }
            case -22: {
                double d1 = ECMA.toNumber(session, eeContext.toValue(lhs.debuggerValue));
                double d2 = ECMA.toNumber(session, eeContext.toValue(rhs.debuggerValue));
                return new DebuggerValue(new Double(d1 / d2));
            }
            case -7: {
                double d1 = ECMA.toNumber(session, eeContext.toValue(lhs.debuggerValue));
                double d2 = ECMA.toNumber(session, eeContext.toValue(rhs.debuggerValue));
                return new DebuggerValue(new Double(d1 % d2));
            }
            case -42: {
                Value v1 = eeContext.toValue(lhs.debuggerValue);
                Value v2 = eeContext.toValue(rhs.debuggerValue);
                boolean isXMLConcat = false;
                if (v1.getType() == 3 && v2.getType() == 3) {
                    String type1 = v1.getTypeName();
                    String type2 = v2.getTypeName();
                    int at = type1.indexOf(64);
                    if (at != -1) {
                        type1 = type1.substring(0, at);
                    }
                    if ((at = type2.indexOf(64)) != -1) {
                        type2 = type2.substring(0, at);
                    }
                    if ((type1.equals("XML") || type1.equals("XMLList")) && (type2.equals("XML") || type2.equals("XMLList"))) {
                        isXMLConcat = true;
                    }
                }
                if (isXMLConcat) {
                    try {
                        Value xml1 = session.callFunction(v1, "toXMLString", new Value[0]);
                        Value xml2 = session.callFunction(v2, "toXMLString", new Value[0]);
                        String allXML = xml1.getValueAsString() + xml2.getValueAsString();
                        DValue allXMLValue = DValue.forPrimitive(allXML);
                        Value retval = session.callConstructor("XMLList", new Value[]{allXMLValue});
                        return new DebuggerValue(retval);
                    }
                    catch (PlayerDebugException e) {
                        throw new ExpressionEvaluatorException(e);
                    }
                }
                v1 = ECMA.toPrimitive(session, v1, null);
                v2 = ECMA.toPrimitive(session, v2, null);
                if (v1.getType() == 2 || v2.getType() == 2) {
                    return new DebuggerValue(ECMA.toString(session, v1) + ECMA.toString(session, v2));
                }
                return new DebuggerValue(new Double(ECMA.toNumber(session, v1) + ECMA.toNumber(session, v2)));
            }
            case -2: {
                double d1 = ECMA.toNumber(session, eeContext.toValue(lhs.debuggerValue));
                double d2 = ECMA.toNumber(session, eeContext.toValue(rhs.debuggerValue));
                return new DebuggerValue(new Double(d1 - d2));
            }
            case -46: {
                int n1 = ECMA.toInt32(session, eeContext.toValue(lhs.debuggerValue));
                int n2 = (int)(ECMA.toUint32(session, eeContext.toValue(rhs.debuggerValue)) & 0x1FL);
                return new DebuggerValue(new Double(n1 << n2));
            }
            case -55: {
                int n1 = ECMA.toInt32(session, eeContext.toValue(lhs.debuggerValue));
                int n2 = (int)(ECMA.toUint32(session, eeContext.toValue(rhs.debuggerValue)) & 0x1FL);
                return new DebuggerValue(new Double(n1 >> n2));
            }
            case -57: {
                long n1 = ECMA.toUint32(session, eeContext.toValue(lhs.debuggerValue));
                long n2 = ECMA.toUint32(session, eeContext.toValue(rhs.debuggerValue)) & 0x1FL;
                return new DebuggerValue(new Double(n1 >>> (int)n2));
            }
            case -45: {
                Value lessThan = ECMA.lessThan(session, eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue));
                boolean result = lessThan.getType() == 7 ? false : ECMA.toBoolean(lessThan);
                return new DebuggerValue(result);
            }
            case -53: {
                Value greaterThan = ECMA.lessThan(session, eeContext.toValue(rhs.debuggerValue), eeContext.toValue(lhs.debuggerValue));
                boolean result = greaterThan.getType() == 7 ? false : ECMA.toBoolean(greaterThan);
                return new DebuggerValue(result);
            }
            case -48: {
                Value lessThan = ECMA.lessThan(session, eeContext.toValue(rhs.debuggerValue), eeContext.toValue(lhs.debuggerValue));
                boolean result = lessThan.getType() == 7 ? false : !ECMA.toBoolean(lessThan);
                return new DebuggerValue(result);
            }
            case -54: {
                Value lessThan = ECMA.lessThan(session, eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue));
                boolean result = lessThan.getType() == 7 ? false : !ECMA.toBoolean(lessThan);
                return new DebuggerValue(result);
            }
            case -86: {
                try {
                    return new DebuggerValue(session.evalInstanceof(eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue)));
                }
                catch (PlayerDebugException e) {
                    throw new ExpressionEvaluatorException(e);
                }
                catch (PlayerFaultException e) {
                    throw new ExpressionEvaluatorException(e);
                }
            }
            case -84: {
                try {
                    return new DebuggerValue(session.evalIn(eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue)));
                }
                catch (PlayerDebugException e) {
                    throw new ExpressionEvaluatorException(e);
                }
                catch (PlayerFaultException e) {
                    throw new ExpressionEvaluatorException(e);
                }
            }
            case -88: {
                try {
                    return new DebuggerValue(session.evalIs(eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue)));
                }
                catch (PlayerDebugException e) {
                    throw new ExpressionEvaluatorException(e);
                }
                catch (PlayerFaultException e) {
                    throw new ExpressionEvaluatorException(e);
                }
            }
            case -60: {
                try {
                    return new DebuggerValue(session.evalAs(eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue)));
                }
                catch (PlayerDebugException e) {
                    throw new ExpressionEvaluatorException(e);
                }
                catch (PlayerFaultException e) {
                    throw new ExpressionEvaluatorException(e);
                }
            }
            case -51: {
                return new DebuggerValue(new Boolean(ECMA.equals(session, eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue))));
            }
            case -5: {
                return new DebuggerValue(new Boolean(!ECMA.equals(session, eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue))));
            }
            case -52: {
                return new DebuggerValue(new Boolean(ECMA.strictEquals(eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue))));
            }
            case -6: {
                return new DebuggerValue(new Boolean(!ECMA.strictEquals(eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue))));
            }
            case -9: {
                return new DebuggerValue(new Double(ECMA.toInt32(session, eeContext.toValue(lhs.debuggerValue)) & ECMA.toInt32(session, eeContext.toValue(rhs.debuggerValue))));
            }
            case -31: {
                return new DebuggerValue(new Double(ECMA.toInt32(session, eeContext.toValue(lhs.debuggerValue)) ^ ECMA.toInt32(session, eeContext.toValue(rhs.debuggerValue))));
            }
            case -36: {
                return new DebuggerValue(new Double(ECMA.toInt32(session, eeContext.toValue(lhs.debuggerValue)) | ECMA.toInt32(session, eeContext.toValue(rhs.debuggerValue))));
            }
            case -10: {
                Value result = eeContext.toValue(lhs.debuggerValue);
                if (ECMA.toBoolean(result)) {
                    rhs = (DebuggerValue)node.rhs.evaluate(cx, this);
                    result = eeContext.toValue(rhs.debuggerValue);
                }
                return new DebuggerValue(result);
            }
            case -37: {
                Value result = eeContext.toValue(lhs.debuggerValue);
                if (!ECMA.toBoolean(result)) {
                    rhs = (DebuggerValue)node.rhs.evaluate(cx, this);
                    result = eeContext.toValue(rhs.debuggerValue);
                }
                return new DebuggerValue(result);
            }
            case -133: {
                return new DebuggerValue(null);
            }
        }
        cx.internalError(ASTBuilder.getLocalizationManager().getLocalizedTextString("unrecognizedBinaryOperator"));
        return new DebuggerValue(null);
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ConditionalExpressionNode node) {
        DebuggerValue condition = (DebuggerValue)node.condition.evaluate(cx, this);
        boolean b = ECMA.toBoolean(this.eeContext(cx).toValue(condition.debuggerValue));
        Node nodeToEval = b ? node.thenexpr : node.elseexpr;
        return nodeToEval.evaluate(cx, this);
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ArgumentListNode node) {
        macromedia.asc.semantics.Value retval = null;
        for (Node n : node.items) {
            retval = n.evaluate(cx, this);
        }
        return retval;
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ListNode node) {
        macromedia.asc.semantics.Value retval = null;
        for (Node item : node.items) {
            retval = item.evaluate(cx, this);
        }
        return retval;
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, StatementListNode node) {
        switch (node.items.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return ((Node)node.items.get(0)).evaluate(cx, this);
            }
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("StatementListNodeWIthMoreThanOneItem"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, EmptyElementNode node) {
        return null;
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, EmptyStatementNode node) {
        return null;
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ExpressionStatementNode node) {
        return node.expr.evaluate(cx, this);
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, LabeledStatementNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("labelsNotAllowed"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, IfStatementNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("if"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, SwitchStatementNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("switch"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, CaseLabelNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("case"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, DoStatementNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("do"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, WhileStatementNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("while"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ForStatementNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("for"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, WithStatementNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("with"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ContinueStatementNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("continue"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, BreakStatementNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("break"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ReturnStatementNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("return"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ThrowStatementNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("throw"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, TryStatementNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("try"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, CatchClauseNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("catch"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, FinallyClauseNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("finally"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, UseDirectiveNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("use"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, IncludeDirectiveNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("include"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ImportNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("import"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, MetaDataNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("whatIsMetaDataNode"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, DocCommentNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("whatIsDocCommentNode"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ImportDirectiveNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("import"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, AttributeListNode node) {
        return null;
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, VariableDefinitionNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("var"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, VariableBindingNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("var"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, UntypedVariableBindingNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("var"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, TypedIdentifierNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("var"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, TypeExpressionNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("typeNotExpected"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, FunctionDefinitionNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("functionDefinitionNotAllowed"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, BinaryFunctionDefinitionNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("functionDefinitionNotAllowed"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, FunctionNameNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("functionDefinitionNotAllowed"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, FunctionSignatureNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("functionDefinitionNotAllowed"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ParameterNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ParameterListNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, RestExpressionNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("functionDefinitionNotAllowed"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, RestParameterNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("functionDefinitionNotAllowed"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, InterfaceDefinitionNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("interfaceDefinitionNotAllowed"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ClassDefinitionNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("classDefinitionNotAllowed"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, BinaryClassDefNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("classDefinitionNotAllowed"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, BinaryInterfaceDefinitionNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("interfaceDefinitionNotAllowed"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ClassNameNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, InheritanceNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("classDefinitionNotAllowed"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, NamespaceDefinitionNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ConfigNamespaceDefinitionNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, PackageDefinitionNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, PackageIdentifiersNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, PackageNameNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ProgramNode node) {
        Node st = (Node)node.statements.items.get(node.statements.items.size() - 1);
        return st.evaluate(cx, this);
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, BinaryProgramNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("binaryProgramNodeUnexpected"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ErrorNode node) {
        throw new ExpressionEvaluatorException(node.errorArg);
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ToObjectNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, LoadRegisterNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, StoreRegisterNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, RegisterNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, HasNextNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, BoxNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, CoerceNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, PragmaNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, PragmaExpressionNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, DefaultXMLNamespaceNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("default xml namespace"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, UsePrecisionNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("use"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, UseNumericNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("use"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, UseRoundingNode node) {
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("use"));
    }

    public macromedia.asc.semantics.Value evaluate(macromedia.asc.util.Context cx, ApplyTypeExprNode node) {
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    private String keywordNotAllowed(String keyword) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("keyword", keyword);
        return ASTBuilder.getLocalizationManager().getLocalizedTextString("keywordNotAllowed", parameters);
    }

    public static class ExpressionEvaluatorScope
    extends ObjectValue {
        public Context expressionEvaluatorContext;

        public ExpressionEvaluatorScope(Context expressionEvaluatorContext) {
            this.expressionEvaluatorContext = expressionEvaluatorContext;
        }
    }

    public static class DebuggerValue
    extends macromedia.asc.semantics.Value {
        public Object debuggerValue;

        public DebuggerValue(Object v) {
            this.debuggerValue = v;
        }
    }
}

