/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem.internal;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flex2.compiler.CompilerAPI;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.DefaultsConfigurator;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcException;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.FlexMovie;
import flex2.tools.CompcConfiguration;
import flex2.tools.Mxmlc;
import flex2.tools.WebTierAPI;
import flex2.tools.oem.Library;
import flex2.tools.oem.Report;
import flex2.tools.oem.internal.OEMConfiguration;
import flex2.tools.oem.internal.OEMConsole;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LibraryCompiler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        OEMConsole console;
        block7: {
            console = new OEMConsole();
            try {
                try {
                    LibraryCompiler.init();
                    LibraryCompiler.run(console, args);
                }
                catch (ConfigurationException ex) {
                    Mxmlc.processConfigurationException(ex, "compc");
                    Object var4_3 = null;
                    LibraryCompiler.clean();
                    break block7;
                }
                catch (SwcException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var4_4 = null;
                    LibraryCompiler.clean();
                    break block7;
                }
                catch (Throwable t) {
                    ThreadLocalToolkit.logError(t.getMessage());
                    t.printStackTrace();
                    Object var4_5 = null;
                    LibraryCompiler.clean();
                    break block7;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                LibraryCompiler.clean();
                throw throwable;
            }
            LibraryCompiler.clean();
        }
        System.exit(console.errorCount());
    }

    public static void run(OEMConsole console, String[] args) throws ConfigurationException, IOException, URISyntaxException {
        ThreadLocalToolkit.setLogger(console);
        Library lib = new Library();
        lib.setLogger(console);
        OEMConfiguration c1 = (OEMConfiguration)lib.getDefaultConfiguration();
        CompcConfiguration c2 = LibraryCompiler.getCompcConfiguration(args);
        OEMConfiguration c3 = new OEMConfiguration(null, c2);
        c1.importDefaults(c3);
        lib.setConfiguration(c1);
        c1.enableDigestComputation(c2.getComputeDigest());
        Iterator<String> i = c2.getClasses().iterator();
        while (i.hasNext()) {
            lib.addComponent(i.next());
        }
        List<VirtualFile> fileList = CompilerAPI.getVirtualFileList(c2.getIncludeSources(), new HashSet<String>(Arrays.asList(WebTierAPI.getSourcePathMimeTypes())));
        Iterator<VirtualFile> i2 = fileList.iterator();
        while (i2.hasNext()) {
            lib.addComponent(new File(i2.next().getName()));
        }
        Map<String, VirtualFile> ss = c2.getStylesheets();
        for (String key : ss.keySet()) {
            lib.addStyleSheet(key, new File(ss.get(key).getName()));
        }
        Iterator<String> i3 = c2.getIncludeResourceBundles().iterator();
        while (i3.hasNext()) {
            lib.addResourceBundle(i3.next());
        }
        i3 = c2.getNamespaces().iterator();
        while (i3.hasNext()) {
            lib.addComponent(new URI(i3.next()));
        }
        Map<String, VirtualFile> m = c2.getFiles();
        for (String key : m.keySet()) {
            lib.addArchiveFile(key, new File(m.get(key).getName()));
        }
        try {
            lib.load(new BufferedInputStream(new FileInputStream(new File(c2.getOutput() + ".incr"))));
            ThreadLocalToolkit.setLogger(console);
        }
        catch (IOException ex) {
            // empty catch block
        }
        long size = 0L;
        size = lib.build(new BufferedOutputStream(new FileOutputStream(new File(c2.getOutput()))), true);
        if (size == 0L) {
            ThreadLocalToolkit.logError("Build unsuccessful.");
        } else {
            System.out.println(c2.getOutput() + " (" + size + " bytes)");
            if (c2.generateRBList() && c2.getRBListFileName() != null) {
                int l;
                Report r = lib.getReport();
                String[] rbNames = r.getResourceBundleNames();
                HashSet<String> set = new HashSet<String>();
                int n = l = rbNames == null ? 0 : rbNames.length;
                for (int i4 = 0; i4 < l; ++i4) {
                    set.add(rbNames[i4]);
                }
                String list = FlexMovie.dumpRBList(set);
                FileUtil.writeFile(c2.getRBListFileName(), list);
            }
        }
        lib.save(new BufferedOutputStream(new FileOutputStream(new File(c2.getOutput() + ".incr"))));
        lib.clean();
    }

    private static CompcConfiguration getCompcConfiguration(String[] args) throws ConfigurationException, IOException {
        ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CompcConfiguration.class, CompcConfiguration.getAliases());
        cfgbuf.setDefaultVar("include-classes");
        DefaultsConfigurator.loadCompcDefaults(cfgbuf);
        Configuration obj = Mxmlc.processConfiguration(ThreadLocalToolkit.getLocalizationManager(), "compc", args, cfgbuf, CompcConfiguration.class, "include-classes");
        return (CompcConfiguration)obj;
    }

    static final void init() {
        CompilerAPI.useAS3();
        CompilerAPI.usePathResolver();
        LibraryCompiler.setupLocalizationManager();
    }

    static final void clean() {
        CompilerAPI.removePathResolver();
        ThreadLocalToolkit.setLogger(null);
        ThreadLocalToolkit.setLocalizationManager(null);
    }

    static final LocalizationManager setupLocalizationManager() {
        LocalizationManager l10n = new LocalizationManager();
        l10n.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
        ThreadLocalToolkit.setLocalizationManager(l10n);
        return l10n;
    }
}

