/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerAPI;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.LicenseException;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SubCompiler;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.DefaultsConfigurator;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcAPI;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcException;
import flex2.compiler.util.Benchmark;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.LinkerAPI;
import flex2.linker.LinkerException;
import flex2.tools.CommandLineConfiguration;
import flex2.tools.Compc;
import flex2.tools.CompcConfiguration;
import flex2.tools.CompcPreLink;
import flex2.tools.Mxmlc;
import flex2.tools.PostLink;
import flex2.tools.PreLink;
import flex2.tools.SwcTarget;
import flex2.tools.Target;
import flex2.tools.Tool;
import flex2.tools.VersionInfo;
import flex2.tools.WebTierAPI;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Fcsh
extends Tool {
    private static int counter;
    private static boolean exit;
    private static Map<String, Target> targets;
    private static Map<String, Process> processes;

    public static void main(String[] args) throws IOException {
        String s;
        exit = false;
        counter = 1;
        targets = new HashMap<String, Target>();
        processes = new HashMap<String, Process>();
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        CompilerAPI.useAS3();
        LocalizationManager localizationManager = new LocalizationManager();
        localizationManager.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
        ThreadLocalToolkit.setLocalizationManager(localizationManager);
        Fcsh.intro();
        Fcsh.prompt();
        while ((s = r.readLine()) != null) {
            block4: {
                CompilerAPI.useConsoleLogger();
                if (s.trim().length() == 0) {
                    Fcsh.prompt();
                    continue;
                }
                try {
                    Fcsh.process(s);
                }
                catch (Throwable t) {
                    if (!Trace.error) break block4;
                    t.printStackTrace();
                }
            }
            if (exit) break;
            Fcsh.prompt();
        }
    }

    private static void process(String s) {
        block56: {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            if (s.startsWith("mxmlc")) {
                StringTokenizer t = new StringTokenizer(s.substring("mxmlc".length()).trim(), " ");
                String[] args = new String[t.countTokens()];
                int i = 0;
                while (t.hasMoreTokens()) {
                    args[i] = t.nextToken();
                    ++i;
                }
                if (args.length == 1) {
                    try {
                        int id = Integer.parseInt(args[0]);
                        Target target = targets.get("" + id);
                        if (target == null) {
                            ThreadLocalToolkit.logInfo(l10n.getLocalizedTextString((Object)new TargetNotFound("" + id)));
                            break block56;
                        }
                        Fcsh.mxmlc(target.args, id);
                    }
                    catch (NumberFormatException ex) {
                        ThreadLocalToolkit.logInfo(l10n.getLocalizedTextString((Object)new AssignTargetID(counter)));
                        Fcsh.mxmlc(args, counter++);
                    }
                } else {
                    ThreadLocalToolkit.logInfo(l10n.getLocalizedTextString((Object)new AssignTargetID(counter)));
                    Fcsh.mxmlc(args, counter++);
                }
            } else if (s.startsWith("compc")) {
                StringTokenizer t = new StringTokenizer(s.substring("compc".length()).trim(), " ");
                String[] args = new String[t.countTokens()];
                int i = 0;
                while (t.hasMoreTokens()) {
                    args[i] = t.nextToken();
                    ++i;
                }
                if (args.length == 1) {
                    try {
                        int id = Integer.parseInt(args[0]);
                        Target target = targets.get("" + id);
                        if (target == null) {
                            ThreadLocalToolkit.logInfo(l10n.getLocalizedTextString((Object)new TargetNotFound("" + id)));
                            break block56;
                        }
                        Fcsh.compc(target.args, id);
                    }
                    catch (NumberFormatException ex) {
                        ThreadLocalToolkit.logInfo(l10n.getLocalizedTextString((Object)new AssignTargetID(counter)));
                        Fcsh.compc(args, counter++);
                    }
                } else {
                    ThreadLocalToolkit.logInfo(l10n.getLocalizedTextString((Object)new AssignTargetID(counter)));
                    Fcsh.compc(args, counter++);
                }
            } else if (s.startsWith("compile")) {
                String id = s.substring("compile".length()).trim();
                if (targets.containsKey(id)) {
                    Fcsh.compile(id);
                    if (ThreadLocalToolkit.errorCount() == 0) {
                        Fcsh.link(id);
                    }
                } else {
                    ThreadLocalToolkit.logInfo(l10n.getLocalizedTextString((Object)new TargetNotFound(id)));
                }
            } else if (s.startsWith("clear")) {
                String id = s.substring("clear".length()).trim();
                if (id.length() == 0) {
                    HashSet<String> keys = new HashSet<String>(targets.keySet());
                    Iterator<String> i = keys.iterator();
                    while (i.hasNext()) {
                        Fcsh.clear(i.next());
                    }
                } else if (targets.containsKey(id)) {
                    Fcsh.clear(id);
                } else {
                    ThreadLocalToolkit.logInfo(l10n.getLocalizedTextString((Object)new TargetNotFound(id)));
                }
            } else if (s.startsWith("info")) {
                String id = s.substring("info".length()).trim();
                if (id.length() == 0) {
                    HashSet<String> keys = new HashSet<String>(targets.keySet());
                    Iterator<String> i = keys.iterator();
                    while (i.hasNext()) {
                        Fcsh.info(i.next());
                    }
                } else if (targets.containsKey(id)) {
                    Fcsh.info(id);
                } else {
                    ThreadLocalToolkit.logInfo(l10n.getLocalizedTextString((Object)new TargetNotFound(id)));
                }
            } else if (s.startsWith("touch")) {
                String args = s.substring("touch".length()).trim();
                StringTokenizer stok = new StringTokenizer(args);
                while (stok.hasMoreTokens()) {
                    String f = stok.nextToken();
                    if (!new File(f).canWrite()) {
                        ThreadLocalToolkit.logInfo("touch: cannot write " + f);
                        continue;
                    }
                    new File(f).setLastModified(System.currentTimeMillis());
                }
            } else if (s.startsWith("cp")) {
                String args = s.substring("cp".length()).trim();
                StringTokenizer stok = new StringTokenizer(args);
                if (stok.countTokens() != 2) {
                    ThreadLocalToolkit.logInfo("cp fileFrom fileTo");
                } else {
                    String copyFrom = stok.nextToken();
                    String copyTo = stok.nextToken();
                    try {
                        FileUtil.writeBinaryFile(new File(copyTo), FileUtil.openStream(copyFrom));
                    }
                    catch (IOException e) {
                        ThreadLocalToolkit.logInfo(e.getMessage());
                    }
                }
            } else if (s.startsWith("mv")) {
                String args = s.substring("mv".length()).trim();
                StringTokenizer stok = new StringTokenizer(args);
                if (stok.countTokens() != 2) {
                    ThreadLocalToolkit.logInfo("mv fileFrom fileTo");
                } else {
                    String moveFrom = stok.nextToken();
                    String moveTo = stok.nextToken();
                    new File(moveFrom).renameTo(new File(moveTo));
                }
            } else if (s.startsWith("rm")) {
                String args = s.substring("rm".length()).trim();
                StringTokenizer stok = new StringTokenizer(args);
                if (stok.countTokens() != 1) {
                    ThreadLocalToolkit.logInfo("rm file");
                } else {
                    String rmFile = stok.nextToken();
                    new File(rmFile).delete();
                }
            } else if (s.equals("quit")) {
                HashSet<String> names = new HashSet<String>(targets.keySet());
                Iterator i = names.iterator();
                while (i.hasNext()) {
                    Fcsh.process("clear " + (String)i.next());
                }
                exit = true;
            } else {
                Fcsh.cmdList();
            }
        }
    }

    private static void clear(String target) {
        Process p = processes.remove(target);
        if (p != null) {
            p.destroy();
        }
        targets.remove(target);
    }

    private static void info(String target) {
        Target s = targets.get(target);
        ThreadLocalToolkit.logInfo("id: " + s.id);
        StringBuilder b = new StringBuilder();
        int size = s.args.length;
        for (int i = 0; i < size; ++i) {
            b.append(s.args[i]);
            b.append(' ');
        }
        ThreadLocalToolkit.logInfo((s instanceof SwcTarget ? "compc: " : "mxmlc: ") + b);
    }

    private static void compile(String id) {
        Target s = targets.get(id);
        if (s instanceof SwcTarget) {
            Fcsh.compile_compc((SwcTarget)s);
        } else {
            Fcsh.compile_mxmlc(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void compile_compc(SwcTarget s) {
        block34: {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            Benchmark benchmark = null;
            try {
                try {
                    CompilerAPI.usePathResolver();
                    ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CompcConfiguration.class, CompcConfiguration.getAliases());
                    cfgbuf.setDefaultVar("include-classes");
                    DefaultsConfigurator.loadCompcDefaults(cfgbuf);
                    CompcConfiguration configuration = (CompcConfiguration)Mxmlc.processConfiguration(ThreadLocalToolkit.getLocalizationManager(), "compc", s.args, cfgbuf, CompcConfiguration.class, "include-classes");
                    CompilerAPI.setupHeadless(configuration);
                    if (configuration.benchmark()) {
                        benchmark = CompilerAPI.runBenchmark();
                        benchmark.startTime("precompile");
                    } else {
                        CompilerAPI.disableBenchmark();
                    }
                    s.sourcePath.clearCache();
                    s.bundlePath.clearCache();
                    s.resources.refresh();
                    CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
                    compilerConfig.setMetadataExport(true);
                    NameMappings mappings = CompilerAPI.getNameMappings(configuration);
                    Transcoder[] transcoders = WebTierAPI.getTranscoders(configuration);
                    SubCompiler[] compilers = WebTierAPI.getCompilers(compilerConfig, mappings, transcoders);
                    if (benchmark != null) {
                        benchmark.benchmark(l10n.getLocalizedTextString((Object)new Mxmlc.InitialSetup()));
                    }
                    CompilerSwcContext swcContext = new CompilerSwcContext(true);
                    swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), null, null, mappings, I18nUtils.getTranslationFormat(compilerConfig), s.swcCache);
                    configuration.addExterns(swcContext.getExterns());
                    boolean recompile = false;
                    int newChecksum = cfgbuf.checksum_ts() + swcContext.checksum();
                    if (newChecksum != s.checksum) {
                        ThreadLocalToolkit.logInfo(l10n.getLocalizedTextString((Object)new DetectConfigurationChange()));
                        s.checksum = newChecksum;
                        s.resources = new ResourceContainer();
                        recompile = true;
                    }
                    if (CompilerAPI.validateCompilationUnits(s.fileSpec, s.sourceList, s.sourcePath, s.bundlePath, s.resources, swcContext, s.classes, s.perCompileData, recompile, configuration) > 0) {
                        Map<String, String> licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
                        SymbolTable symbolTable = new SymbolTable(configuration, s.perCompileData);
                        s.configuration = configuration;
                        HashMap<String, Source> classes = new HashMap<String, Source>();
                        s.nsComponents = SwcAPI.setupNamespaceComponents(configuration, mappings, s.sourcePath, s.sourceList, classes);
                        SwcAPI.setupClasses(configuration, s.sourcePath, s.sourceList, classes);
                        s.classes = classes;
                        HashMap<String, VirtualFile> rbFiles = new HashMap<String, VirtualFile>();
                        if (benchmark != null) {
                            benchmark.stopTime("precompile", false);
                        }
                        List<CompilationUnit> units = CompilerAPI.compile(s.fileSpec, s.sourceList, s.classes.values(), s.sourcePath, s.resources, s.bundlePath, swcContext, symbolTable, mappings, configuration, compilers, new CompcPreLink(rbFiles, configuration.getIncludeResourceBundles()), licenseMap, new ArrayList<Source>());
                        if (benchmark != null) {
                            benchmark.startTime("postcompile");
                        }
                        s.units = units;
                        s.rbFiles = rbFiles;
                        s.sourcePath.clearCache();
                        s.bundlePath.clearCache();
                        s.resources.refresh();
                    } else {
                        ThreadLocalToolkit.logInfo(l10n.getLocalizedTextString((Object)new NoChange()));
                    }
                }
                catch (ConfigurationException ex) {
                    Compc.displayStartMessage();
                    Mxmlc.processConfigurationException(ex, "compc");
                    Object var18_23 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (LicenseException ex) {
                    ThreadLocalToolkit.logError(ex.getMessage());
                    Object var18_24 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (CompilerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var18_25 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (SwcException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var18_26 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (Throwable t) {
                    ThreadLocalToolkit.logError(t.getMessage());
                    if (Trace.error) {
                        t.printStackTrace();
                    }
                    Object var18_27 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                Object var18_22 = null;
                if (benchmark == null) break block34;
            }
            catch (Throwable throwable) {
                Object var18_28 = null;
                if (benchmark != null) {
                    if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                        benchmark.stopTime("postcompile", false);
                    }
                    benchmark.totalTime();
                    benchmark.peakMemoryUsage(true);
                }
                CompilerAPI.removePathResolver();
                throw throwable;
            }
            if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                benchmark.stopTime("postcompile", false);
            }
            benchmark.totalTime();
            benchmark.peakMemoryUsage(true);
        }
        CompilerAPI.removePathResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void compile_mxmlc(Target s) {
        block34: {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            Benchmark benchmark = null;
            try {
                try {
                    CompilerAPI.usePathResolver();
                    ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CommandLineConfiguration.class, Configuration.getAliases());
                    cfgbuf.setDefaultVar("file-specs");
                    DefaultsConfigurator.loadDefaults(cfgbuf);
                    CommandLineConfiguration configuration = (CommandLineConfiguration)Mxmlc.processConfiguration(ThreadLocalToolkit.getLocalizationManager(), "mxmlc", s.args, cfgbuf, CommandLineConfiguration.class, "file-specs");
                    CompilerAPI.setupHeadless(configuration);
                    if (configuration.benchmark()) {
                        benchmark = CompilerAPI.runBenchmark();
                        benchmark.startTime("precompile");
                    } else {
                        CompilerAPI.disableBenchmark();
                    }
                    s.sourcePath.clearCache();
                    s.bundlePath.clearCache();
                    s.resources.refresh();
                    CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
                    NameMappings mappings = CompilerAPI.getNameMappings(configuration);
                    Transcoder[] transcoders = WebTierAPI.getTranscoders(configuration);
                    SubCompiler[] compilers = WebTierAPI.getCompilers(compilerConfig, mappings, transcoders);
                    if (benchmark != null) {
                        benchmark.benchmark(l10n.getLocalizedTextString((Object)new Mxmlc.InitialSetup()));
                    }
                    CompilerSwcContext swcContext = new CompilerSwcContext(true);
                    swcContext.load(compilerConfig.getLibraryPath(), Configuration.getAllExcludedLibraries(compilerConfig, configuration), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat(compilerConfig), s.swcCache);
                    configuration.addExterns(swcContext.getExterns());
                    configuration.addIncludes(swcContext.getIncludes());
                    configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
                    boolean recompile = false;
                    int newChecksum = cfgbuf.checksum_ts() + swcContext.checksum();
                    if (newChecksum != s.checksum) {
                        ThreadLocalToolkit.logInfo(l10n.getLocalizedTextString((Object)new DetectConfigurationChange()));
                        s.checksum = newChecksum;
                        s.resources = new ResourceContainer();
                        recompile = true;
                    }
                    if (CompilerAPI.validateCompilationUnits(s.fileSpec, s.sourceList, s.sourcePath, s.bundlePath, s.resources, swcContext, s.perCompileData, recompile, configuration) > 0) {
                        Map<String, String> licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
                        SymbolTable symbolTable = new SymbolTable(configuration, s.perCompileData);
                        s.configuration = configuration;
                        VirtualFile projector = configuration.getProjector();
                        if (benchmark != null) {
                            benchmark.stopTime("precompile", false);
                        }
                        s.units = projector != null && projector.getName().endsWith("avmplus.exe") ? CompilerAPI.compile(s.fileSpec, s.sourceList, null, s.sourcePath, s.resources, s.bundlePath, swcContext, symbolTable, mappings, configuration, compilers, null, licenseMap, new ArrayList<Source>()) : CompilerAPI.compile(s.fileSpec, s.sourceList, null, s.sourcePath, s.resources, s.bundlePath, swcContext, symbolTable, mappings, configuration, compilers, new PreLink(), licenseMap, new ArrayList<Source>());
                        if (benchmark != null) {
                            benchmark.startTime("postcompile");
                        }
                        s.sourcePath.clearCache();
                        s.bundlePath.clearCache();
                        s.resources.refresh();
                    } else {
                        ThreadLocalToolkit.logInfo(l10n.getLocalizedTextString((Object)new NoChange()));
                    }
                }
                catch (ConfigurationException ex) {
                    Mxmlc.processConfigurationException(ex, "mxmlc");
                    Object var16_21 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (LicenseException ex) {
                    ThreadLocalToolkit.logError(ex.getMessage());
                    Object var16_22 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (CompilerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var16_23 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (SwcException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var16_24 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (Throwable t) {
                    ThreadLocalToolkit.logError(t.getMessage());
                    if (Trace.error) {
                        t.printStackTrace();
                    }
                    Object var16_25 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                Object var16_20 = null;
                if (benchmark == null) break block34;
            }
            catch (Throwable throwable) {
                Object var16_26 = null;
                if (benchmark != null) {
                    if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                        benchmark.stopTime("postcompile", false);
                    }
                    benchmark.totalTime();
                    benchmark.peakMemoryUsage(true);
                }
                CompilerAPI.removePathResolver();
                throw throwable;
            }
            if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                benchmark.stopTime("postcompile", false);
            }
            benchmark.totalTime();
            benchmark.peakMemoryUsage(true);
        }
        CompilerAPI.removePathResolver();
    }

    private static void link(String target) {
        Target s = targets.get(target);
        if (s instanceof SwcTarget) {
            Fcsh.link_compc((SwcTarget)s);
        } else {
            Fcsh.link_mxmlc(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void link_compc(SwcTarget s) {
        try {
            block11: {
                try {
                    ThreadLocalToolkit.resetBenchmark();
                    CompilerAPI.usePathResolver();
                    if (s.units == null) break block11;
                    SwcAPI.exportSwc((CompcConfiguration)s.configuration, s.units, s.nsComponents, s.swcCache, s.rbFiles);
                    if (s.outputName == null || ThreadLocalToolkit.errorCount() != 0) break block11;
                    File file = new File(s.outputName);
                    s.outputName = FileUtil.getCanonicalPath(file);
                    ThreadLocalToolkit.log(new Mxmlc.OutputMessage(s.outputName, Long.toString(file.length())));
                }
                catch (LinkerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var3_5 = null;
                    Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
                    if (benchmark != null) {
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (Throwable t) {
                    ThreadLocalToolkit.logError(t.getMessage());
                    if (Trace.error) {
                        t.printStackTrace();
                    }
                    Object var3_6 = null;
                    Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
                    if (benchmark != null) {
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
            }
            Object var3_4 = null;
            Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
            if (benchmark != null) {
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            CompilerAPI.removePathResolver();
            return;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
            if (benchmark != null) {
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            CompilerAPI.removePathResolver();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void link_mxmlc(Target s) {
        block25: {
            OutputStream swfOut = null;
            try {
                block24: {
                    ThreadLocalToolkit.resetBenchmark();
                    if (s.units == null) break block24;
                    VirtualFile projector = ((CommandLineConfiguration)s.configuration).getProjector();
                    PostLink postLink = null;
                    if (s.configuration.optimize() && !s.configuration.generateDebugTags()) {
                        postLink = new PostLink(s.configuration);
                    }
                    if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                        s.app = LinkerAPI.linkConsole(s.units, postLink, s.configuration);
                        File file = FileUtil.openFile(s.outputName, true);
                        swfOut = new BufferedOutputStream(new FileOutputStream(file));
                        Mxmlc.createProjector(projector, s.app, swfOut);
                        swfOut.flush();
                        swfOut.close();
                        ThreadLocalToolkit.log(new Mxmlc.OutputMessage(s.outputName, Long.toString(file.length())));
                        break block24;
                    }
                    s.movie = LinkerAPI.link(s.units, postLink, s.configuration);
                    File file = FileUtil.openFile(s.outputName, true);
                    swfOut = new BufferedOutputStream(new FileOutputStream(file));
                    if (projector != null) {
                        Mxmlc.createProjector(projector, s.movie, swfOut);
                    } else {
                        CompilerAPI.encode(s.movie, swfOut);
                    }
                    swfOut.flush();
                    swfOut.close();
                    ThreadLocalToolkit.log(new Mxmlc.OutputMessage(s.outputName, Long.toString(file.length())));
                }
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
                if (benchmark != null) {
                    benchmark.totalTime();
                    benchmark.peakMemoryUsage(true);
                }
                if (swfOut != null) {
                    try {
                        swfOut.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
            if (benchmark != null) {
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            if (swfOut != null) {
                try {
                    swfOut.close();
                }
                catch (IOException ioe) {}
            }
            break block25;
            {
                catch (LinkerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var6_9 = null;
                    benchmark = ThreadLocalToolkit.getBenchmark();
                    if (benchmark != null) {
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block25;
                }
                catch (Throwable t) {
                    ThreadLocalToolkit.logError(t.getMessage());
                    if (Trace.error) {
                        t.printStackTrace();
                    }
                    Object var6_10 = null;
                    benchmark = ThreadLocalToolkit.getBenchmark();
                    if (benchmark != null) {
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void mxmlc(String[] args, int id) {
        block62: {
            OutputStream swfOut;
            Benchmark benchmark;
            block61: {
                LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
                benchmark = null;
                swfOut = null;
                Target s = new Target();
                s.id = id;
                try {
                    block60: {
                        CompilerAPI.usePathResolver();
                        ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CommandLineConfiguration.class, Configuration.getAliases());
                        cfgbuf.setDefaultVar("file-specs");
                        DefaultsConfigurator.loadDefaults(cfgbuf);
                        CommandLineConfiguration configuration = (CommandLineConfiguration)Mxmlc.processConfiguration(ThreadLocalToolkit.getLocalizationManager(), "mxmlc", args, cfgbuf, CommandLineConfiguration.class, "file-specs");
                        s.configuration = configuration;
                        CompilerAPI.setupHeadless(configuration);
                        if (configuration.benchmark()) {
                            benchmark = CompilerAPI.runBenchmark();
                            benchmark.startTime("precompile");
                        } else {
                            CompilerAPI.disableBenchmark();
                        }
                        String target = configuration.getTargetFile();
                        targets.put("" + id, s);
                        s.args = args;
                        VirtualFile targetFile = CompilerAPI.getVirtualFile(target);
                        WebTierAPI.checkSupportedTargetMimeType(targetFile);
                        List<VirtualFile> virtualFileList = CompilerAPI.getVirtualFileList(configuration.getFileList());
                        CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
                        NameMappings mappings = CompilerAPI.getNameMappings(configuration);
                        Transcoder[] transcoders = WebTierAPI.getTranscoders(configuration);
                        SubCompiler[] compilers = WebTierAPI.getCompilers(compilerConfig, mappings, transcoders);
                        VirtualFile projector = configuration.getProjector();
                        if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                            s.outputName = configuration.getOutput();
                            if (s.outputName == null) {
                                s.outputName = targetFile.getName();
                                s.outputName = s.outputName.substring(0, s.outputName.lastIndexOf(46)) + ".exe";
                            }
                        } else {
                            s.outputName = configuration.getOutput();
                            if (s.outputName == null) {
                                s.outputName = targetFile.getName();
                                s.outputName = projector != null ? s.outputName.substring(0, s.outputName.lastIndexOf(46)) + ".exe" : s.outputName.substring(0, s.outputName.lastIndexOf(46)) + ".swf";
                            }
                        }
                        VirtualFile[] asClasspath = compilerConfig.getSourcePath();
                        s.fileSpec = new FileSpec(Collections.<VirtualFile>emptyList(), WebTierAPI.getFileSpecMimeTypes());
                        s.sourceList = new SourceList(virtualFileList, asClasspath, targetFile, WebTierAPI.getSourcePathMimeTypes());
                        s.sourcePath = new SourcePath(asClasspath, targetFile, WebTierAPI.getSourcePathMimeTypes(), compilerConfig.allowSourcePathOverlap());
                        s.resources = new ResourceContainer();
                        s.bundlePath = new ResourceBundlePath(configuration.getCompilerConfiguration(), targetFile);
                        if (benchmark != null) {
                            benchmark.benchmark(l10n.getLocalizedTextString((Object)new Mxmlc.InitialSetup()));
                        }
                        s.swcCache = new SwcCache();
                        CompilerSwcContext swcContext = new CompilerSwcContext(true);
                        swcContext.load(compilerConfig.getLibraryPath(), Configuration.getAllExcludedLibraries(compilerConfig, configuration), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat(compilerConfig), s.swcCache);
                        configuration.addExterns(swcContext.getExterns());
                        configuration.addIncludes(swcContext.getIncludes());
                        configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
                        s.checksum = cfgbuf.checksum_ts() + swcContext.checksum();
                        SymbolTable symbolTable = new SymbolTable(configuration);
                        s.perCompileData = symbolTable.perCompileData;
                        Map<String, String> licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
                        PostLink postLink = null;
                        if (configuration.optimize() && !configuration.generateDebugTags()) {
                            postLink = new PostLink(configuration);
                        }
                        if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                            if (benchmark != null) {
                                benchmark.stopTime("precompile", false);
                            }
                            List<CompilationUnit> units = CompilerAPI.compile(s.fileSpec, s.sourceList, null, s.sourcePath, s.resources, s.bundlePath, swcContext, symbolTable, mappings, configuration, compilers, null, licenseMap, new ArrayList<Source>());
                            if (benchmark != null) {
                                benchmark.startTime("postcompile");
                            }
                            s.units = units;
                            s.sourcePath.clearCache();
                            s.bundlePath.clearCache();
                            s.resources.refresh();
                            s.app = LinkerAPI.linkConsole(units, postLink, configuration);
                            File file = FileUtil.openFile(s.outputName, true);
                            swfOut = new BufferedOutputStream(new FileOutputStream(file));
                            Mxmlc.createProjector(projector, s.app, swfOut);
                            swfOut.flush();
                            swfOut.close();
                            ThreadLocalToolkit.log(new Mxmlc.OutputMessage(s.outputName, Long.toString(file.length())));
                            break block60;
                        }
                        if (benchmark != null) {
                            benchmark.stopTime("precompile", false);
                        }
                        List<CompilationUnit> units = CompilerAPI.compile(s.fileSpec, s.sourceList, null, s.sourcePath, s.resources, s.bundlePath, swcContext, symbolTable, mappings, configuration, compilers, new PreLink(), licenseMap, new ArrayList<Source>());
                        if (benchmark != null) {
                            benchmark.startTime("postcompile");
                        }
                        s.units = units;
                        s.sourcePath.clearCache();
                        s.bundlePath.clearCache();
                        s.resources.refresh();
                        s.movie = LinkerAPI.link(units, postLink, configuration);
                        File file = FileUtil.openFile(s.outputName, true);
                        swfOut = new BufferedOutputStream(new FileOutputStream(file));
                        if (projector != null) {
                            Mxmlc.createProjector(projector, s.movie, swfOut);
                        } else {
                            CompilerAPI.encode(s.movie, swfOut);
                        }
                        swfOut.flush();
                        swfOut.close();
                        ThreadLocalToolkit.log(new Mxmlc.OutputMessage(s.outputName, Long.toString(file.length())));
                    }
                    Object var24_31 = null;
                    if (benchmark == null) break block61;
                }
                catch (Throwable throwable) {
                    Object var24_38 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                    benchmark.stopTime("postcompile", false);
                }
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            CompilerAPI.removePathResolver();
            if (swfOut != null) {
                try {
                    swfOut.close();
                }
                catch (IOException ioe) {}
            }
            break block62;
            {
                catch (ConfigurationException ex) {
                    Mxmlc.processConfigurationException(ex, "mxmlc");
                    Object var24_32 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block62;
                }
                catch (LicenseException ex) {
                    ThreadLocalToolkit.logError(ex.getMessage());
                    Object var24_33 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block62;
                }
                catch (CompilerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var24_34 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block62;
                }
                catch (LinkerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var24_35 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block62;
                }
                catch (SwcException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var24_36 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block62;
                }
                catch (Throwable thr) {
                    ThreadLocalToolkit.logError(thr.getMessage());
                    if (Trace.error) {
                        thr.printStackTrace();
                    }
                    Object var24_37 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    if (swfOut != null) {
                        try {
                            swfOut.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void compc(String[] args, int id) {
        block35: {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            Benchmark benchmark = null;
            SwcTarget s = new SwcTarget();
            s.id = id;
            try {
                try {
                    File file;
                    CompilerAPI.usePathResolver();
                    ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CompcConfiguration.class, CompcConfiguration.getAliases());
                    cfgbuf.setDefaultVar("include-classes");
                    DefaultsConfigurator.loadCompcDefaults(cfgbuf);
                    CompcConfiguration configuration = (CompcConfiguration)Mxmlc.processConfiguration(ThreadLocalToolkit.getLocalizationManager(), "compc", args, cfgbuf, CompcConfiguration.class, "include-classes");
                    s.configuration = configuration;
                    CompilerAPI.setupHeadless(configuration);
                    if (configuration.benchmark()) {
                        benchmark = CompilerAPI.runBenchmark();
                        benchmark.startTime("precompile");
                    } else {
                        CompilerAPI.disableBenchmark();
                    }
                    targets.put("" + id, s);
                    s.args = args;
                    String[] sourceMimeTypes = WebTierAPI.getSourcePathMimeTypes();
                    CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
                    s.sourcePath = new SourcePath(sourceMimeTypes, compilerConfig.allowSourcePathOverlap());
                    s.sourcePath.addPathElements(compilerConfig.getSourcePath());
                    List<VirtualFile>[] array = CompilerAPI.getVirtualFileList(configuration.getIncludeSources(), configuration.getStylesheets().values(), new HashSet<String>(Arrays.asList(sourceMimeTypes)), s.sourcePath.getPaths());
                    NameMappings mappings = CompilerAPI.getNameMappings(configuration);
                    compilerConfig.setMetadataExport(true);
                    Transcoder[] transcoders = WebTierAPI.getTranscoders(configuration);
                    SubCompiler[] compilers = WebTierAPI.getCompilers(compilerConfig, mappings, transcoders);
                    s.outputName = FileUtil.getCanonicalPath(FileUtil.openFile(configuration.getOutput()));
                    s.fileSpec = new FileSpec(array[0], WebTierAPI.getFileSpecMimeTypes(), false);
                    s.sourceList = new SourceList(array[1], compilerConfig.getSourcePath(), null, WebTierAPI.getSourceListMimeTypes(), false);
                    s.resources = new ResourceContainer();
                    s.bundlePath = new ResourceBundlePath(configuration.getCompilerConfiguration(), null);
                    if (benchmark != null) {
                        benchmark.benchmark(l10n.getLocalizedTextString((Object)new Mxmlc.InitialSetup()));
                    }
                    s.swcCache = new SwcCache();
                    CompilerSwcContext swcContext = new CompilerSwcContext(true);
                    swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), null, null, mappings, I18nUtils.getTranslationFormat(compilerConfig), s.swcCache);
                    configuration.addExterns(swcContext.getExterns());
                    s.checksum = cfgbuf.checksum_ts() + swcContext.checksum();
                    SymbolTable symbolTable = new SymbolTable(configuration);
                    s.perCompileData = symbolTable.perCompileData;
                    Map<String, String> licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
                    s.classes = new HashMap<String, Source>();
                    s.nsComponents = SwcAPI.setupNamespaceComponents(configuration, mappings, s.sourcePath, s.sourceList, s.classes);
                    SwcAPI.setupClasses(configuration, s.sourcePath, s.sourceList, s.classes);
                    HashMap<String, VirtualFile> rbFiles = new HashMap<String, VirtualFile>();
                    if (benchmark != null) {
                        benchmark.stopTime("precompile", false);
                    }
                    List<CompilationUnit> units = CompilerAPI.compile(s.fileSpec, s.sourceList, s.classes.values(), s.sourcePath, s.resources, s.bundlePath, swcContext, symbolTable, mappings, configuration, compilers, new CompcPreLink(rbFiles, configuration.getIncludeResourceBundles()), licenseMap, new ArrayList<Source>());
                    if (benchmark != null) {
                        benchmark.startTime("postcompile");
                    }
                    s.units = units;
                    s.rbFiles = rbFiles;
                    s.sourcePath.clearCache();
                    s.bundlePath.clearCache();
                    s.resources.refresh();
                    SwcAPI.exportSwc(configuration, units, s.nsComponents, s.swcCache, s.rbFiles);
                    if (s.outputName != null && ThreadLocalToolkit.errorCount() == 0 && (file = FileUtil.openFile(s.outputName)) != null && file.exists() && file.isFile()) {
                        s.outputName = FileUtil.getCanonicalPath(file);
                        ThreadLocalToolkit.log(new Mxmlc.OutputMessage(s.outputName, Long.toString(file.length())));
                    }
                }
                catch (ConfigurationException ex) {
                    Compc.displayStartMessage();
                    Mxmlc.processConfigurationException(ex, "compc");
                    Object var20_26 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (LicenseException ex) {
                    ThreadLocalToolkit.logError(ex.getMessage());
                    Object var20_27 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (CompilerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var20_28 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (LinkerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var20_29 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (SwcException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var20_30 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                catch (Throwable t) {
                    ThreadLocalToolkit.logError(t.getMessage());
                    if (Trace.error) {
                        t.printStackTrace();
                    }
                    Object var20_31 = null;
                    if (benchmark != null) {
                        if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                            benchmark.stopTime("postcompile", false);
                        }
                        benchmark.totalTime();
                        benchmark.peakMemoryUsage(true);
                    }
                    CompilerAPI.removePathResolver();
                    return;
                }
                Object var20_25 = null;
                if (benchmark == null) break block35;
            }
            catch (Throwable throwable) {
                Object var20_32 = null;
                if (benchmark != null) {
                    if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                        benchmark.stopTime("postcompile", false);
                    }
                    benchmark.totalTime();
                    benchmark.peakMemoryUsage(true);
                }
                CompilerAPI.removePathResolver();
                throw throwable;
            }
            if (ThreadLocalToolkit.errorCount() == 0 && benchmark.hasStarted("postcompile")) {
                benchmark.stopTime("postcompile", false);
            }
            benchmark.totalTime();
            benchmark.peakMemoryUsage(true);
        }
        CompilerAPI.removePathResolver();
    }

    private static String getPlayer() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            return "SAFlashPlayer";
        }
        if (osName.startsWith("mac os x")) {
            return "SAFlashPlayer";
        }
        return "flashplayer";
    }

    private static void intro() {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        System.out.println(l10n.getLocalizedTextString((Object)new ShellMessage("fcsh", VersionInfo.buildMessage())));
    }

    private static void prompt() {
        System.out.print("(fcsh) ");
    }

    private static void cmdList() {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        System.out.println(l10n.getLocalizedTextString((Object)new CommandList()));
    }

    public static class CommandList
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -84561512138741212L;
    }

    public static class ShellMessage
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 6261274935205405965L;
        public final String program;
        public final String buildMessage;

        public ShellMessage(String program, String buildMessage) {
            this.program = program;
            this.buildMessage = buildMessage;
        }
    }

    public static class NoChange
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -8351736794365308893L;
    }

    public static class DetectConfigurationChange
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 1170261585837917433L;
    }

    public static class AssignTargetID
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 1870591829772910578L;
        public final int counter;

        public AssignTargetID(int counter) {
            this.counter = counter;
        }
    }

    public static class TargetNotFound
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 6927065187698595699L;
        public final String id;

        public TargetNotFound(String id) {
            this.id = id;
        }
    }
}

