/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.util.ThreadLocalToolkit;
import java.io.IOException;
import java.io.Writer;

class UTF8Encoder {
    protected static final String AMP = "&amp;";
    protected static final String QUOTE = "&quot;";
    protected static final String LESS = "&lt;";
    protected static final String GREATER = "&gt;";
    protected static final String LF = "\n";
    protected static final String CR = "\r";
    protected static final String TAB = "\t";

    UTF8Encoder() {
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public void writeEncoded(Writer writer, String xmlString) throws IOException {
        if (xmlString == null) {
            return;
        }
        int length = xmlString.length();
        block9: for (int i = 0; i < length; ++i) {
            char character = xmlString.charAt(i);
            switch (character) {
                case '&': {
                    writer.write(AMP);
                    continue block9;
                }
                case '\"': {
                    writer.write(QUOTE);
                    continue block9;
                }
                case '<': {
                    writer.write(LESS);
                    continue block9;
                }
                case '>': {
                    writer.write(GREATER);
                    continue block9;
                }
                case '\n': {
                    writer.write(LF);
                    continue block9;
                }
                case '\r': {
                    writer.write(CR);
                    continue block9;
                }
                case '\t': {
                    writer.write(TAB);
                    continue block9;
                }
                default: {
                    if (character < ' ') {
                        String errString = ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString("flex2.compiler.util.XMLStringSerializer.IllegalXMLChar");
                        errString = errString + ": " + Integer.toHexString(character);
                        throw new IllegalArgumentException(errString);
                    }
                    if (character > '\u007f') {
                        writer.write("&#x");
                        writer.write(Integer.toHexString(character).toUpperCase());
                        writer.write(";");
                        continue block9;
                    }
                    writer.write(character);
                }
            }
        }
    }
}

