/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flash.localization.LocalizationManager;
import flash.swf.tools.as3.EvaluatorAdapter;
import flex2.compiler.as3.AttributeInfo;
import flex2.compiler.as3.AttributeInfoCache;
import flex2.compiler.as3.SignatureRules;
import flex2.compiler.as3.reflect.NodeMagic;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import macromedia.asc.parser.ApplyTypeExprNode;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryClassDefNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.BinaryFunctionDefinitionNode;
import macromedia.asc.parser.BinaryInterfaceDefinitionNode;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.BoxNode;
import macromedia.asc.parser.BreakStatementNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.CaseLabelNode;
import macromedia.asc.parser.CatchClauseNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ClassNameNode;
import macromedia.asc.parser.CoerceNode;
import macromedia.asc.parser.ConditionalExpressionNode;
import macromedia.asc.parser.ConfigNamespaceDefinitionNode;
import macromedia.asc.parser.ContinueStatementNode;
import macromedia.asc.parser.DefaultXMLNamespaceNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.DeleteExpressionNode;
import macromedia.asc.parser.DoStatementNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.EmptyElementNode;
import macromedia.asc.parser.EmptyStatementNode;
import macromedia.asc.parser.ErrorNode;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FinallyClauseNode;
import macromedia.asc.parser.ForStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.HasNextNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.IfStatementNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.ImportNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.IncrementNode;
import macromedia.asc.parser.InheritanceNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.InvokeNode;
import macromedia.asc.parser.LabeledStatementNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralFieldNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralRegExpNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.LiteralXMLNode;
import macromedia.asc.parser.LoadRegisterNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ParenExpressionNode;
import macromedia.asc.parser.ParenListExpressionNode;
import macromedia.asc.parser.PragmaExpressionNode;
import macromedia.asc.parser.PragmaNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedExpressionNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.RegisterNode;
import macromedia.asc.parser.RestExpressionNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.StoreRegisterNode;
import macromedia.asc.parser.SuperExpressionNode;
import macromedia.asc.parser.SuperStatementNode;
import macromedia.asc.parser.SwitchStatementNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.ThrowStatementNode;
import macromedia.asc.parser.ToObjectNode;
import macromedia.asc.parser.Tokens;
import macromedia.asc.parser.TryStatementNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.UnaryExpressionNode;
import macromedia.asc.parser.UntypedVariableBindingNode;
import macromedia.asc.parser.UseDirectiveNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.parser.WhileStatementNode;
import macromedia.asc.parser.WithStatementNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureEvaluator
extends EvaluatorAdapter
implements Tokens {
    public static String NEWLINE = System.getProperty("line.separator");
    private StringBuilder out;
    private int indent;
    private final SignatureRules signatureRules;
    private final AttributeInfoCache attributeInfoCache = new AttributeInfoCache();
    private boolean humanReadable;
    private boolean insidePackage;
    private String indentCache;
    private int lastIndent;
    private PackageDefinitionNode currentPackage;

    public SignatureEvaluator(int suggestedBufferSize, boolean humanReadable) {
        this(suggestedBufferSize, humanReadable, new SignatureRules());
    }

    public SignatureEvaluator(int suggestedBufferSize, boolean humanReadable, SignatureRules signatureRules) {
        this.out = new StringBuilder(suggestedBufferSize);
        this.humanReadable = humanReadable;
        this.signatureRules = signatureRules;
    }

    public String getSignature() {
        return this.out.toString();
    }

    public String toString() {
        return this.getSignature();
    }

    private String indent() {
        assert (this.indent >= 0);
        if (this.lastIndent != this.indent) {
            this.indentCache = "";
            for (int i = 0; i < this.indent; ++i) {
                this.indentCache = this.indentCache + "    ";
            }
        }
        return this.indentCache;
    }

    @Override
    public boolean checkFeature(Context cx, Node node) {
        boolean result = true;
        if (node instanceof DefinitionNode) {
            AttributeInfo attInfo = this.attributeInfoCache.getAttributeInfo((DefinitionNode)node);
            if (node instanceof FunctionDefinitionNode) {
                boolean bl;
                if (attInfo.isPublic) {
                    this.signatureRules.getClass();
                }
                if (!attInfo.isPrivate) {
                    if (attInfo.isProtected) {
                        this.signatureRules.getClass();
                    }
                    if (attInfo.isUser) {
                        this.signatureRules.getClass();
                    }
                    if (attInfo.isInternal) {
                        this.signatureRules.getClass();
                    }
                    bl = true;
                } else {
                    this.signatureRules.getClass();
                    bl = false;
                }
                result = bl;
            } else if (node instanceof VariableDefinitionNode) {
                boolean bl;
                if (attInfo.isPublic) {
                    this.signatureRules.getClass();
                }
                if (!attInfo.isPrivate) {
                    if (attInfo.isProtected) {
                        this.signatureRules.getClass();
                    }
                    if (attInfo.isUser) {
                        this.signatureRules.getClass();
                    }
                    if (attInfo.isInternal) {
                        this.signatureRules.getClass();
                    }
                    bl = true;
                } else {
                    this.signatureRules.getClass();
                    bl = false;
                }
                result = bl;
            } else if (node instanceof ImportDirectiveNode) {
                this.signatureRules.getClass();
                result = true;
            } else if (node instanceof ClassDefinitionNode) {
                this.signatureRules.getClass();
                result = true;
            } else if (node instanceof InterfaceDefinitionNode) {
                this.signatureRules.getClass();
                result = true;
            } else if (node instanceof UseDirectiveNode) {
                this.signatureRules.getClass();
                result = true;
            }
        } else if (node instanceof MetaDataNode) {
            this.signatureRules.getClass();
            result = this.checkFeature(cx, ((MetaDataNode)node).def);
        }
        return result;
    }

    @Override
    public Value evaluate(Context unused_cx, ProgramNode node) {
        Context cx = node.cx;
        if (node.pkgdefs != null && !node.pkgdefs.isEmpty()) {
            PackageDefinitionNode mainPackage = node.pkgdefs.first();
            if (mainPackage.statements != null) {
                ++this.indent;
                mainPackage.statements.evaluate(cx, this);
                --this.indent;
            }
        }
        return null;
    }

    @Override
    public Value evaluate(Context unused_cx, ClassDefinitionNode node) {
        Context cx = node.cx;
        if (this.humanReadable) {
            this.out.append(this.indent());
        }
        if (node.attrs != null) {
            node.attrs.evaluate(cx, this);
        }
        assert (node.name != null) : "Sanity Failed";
        assert (node.name.name != null) : "Sanity Failed";
        if (this.humanReadable) {
            this.out.append("class ");
        } else {
            this.out.append("C");
        }
        this.out.append(NodeMagic.getUnqualifiedClassName(node));
        if (node.baseclass != null) {
            if (this.humanReadable) {
                this.out.append(" extends ");
            } else {
                this.out.append(" E");
            }
            node.baseclass.evaluate(cx, this);
        }
        if (node.interfaces != null) {
            if (this.humanReadable) {
                this.out.append(" implements ");
            } else {
                this.out.append(" I");
            }
            this.evaluateSorted(cx, node.interfaces);
        }
        if (this.humanReadable) {
            this.out.append(NEWLINE).append(this.indent()).append("{").append(NEWLINE);
        }
        assert (node.fexprs == null) : "Sanity Failed";
        assert (node.staticfexprs == null) : "Sanity Failed";
        assert (node.instanceinits == null) : "Sanity Failed";
        if (node.statements != null) {
            ++this.indent;
            node.statements.evaluate(cx, this);
            --this.indent;
        }
        if (this.humanReadable) {
            this.out.append(this.indent()).append("}").append(NEWLINE);
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, InterfaceDefinitionNode node) {
        if (this.humanReadable) {
            this.out.append(this.indent());
        }
        if (node.attrs != null) {
            node.attrs.evaluate(cx, this);
        }
        assert (node.name != null) : "Sanity Failed";
        assert (node.name.name != null) : "Sanity Failed";
        if (this.humanReadable) {
            this.out.append("interface ");
        } else {
            this.out.append("I");
        }
        this.out.append(NodeMagic.getUnqualifiedClassName(node));
        if (node.interfaces != null) {
            if (this.humanReadable) {
                this.out.append(" extends ");
            } else {
                this.out.append(" E");
            }
            this.evaluateSorted(cx, node.interfaces);
        }
        assert (node.baseclass == null) : "Sanity Failed";
        if (this.humanReadable) {
            this.out.append(NEWLINE).append(this.indent()).append("{").append(NEWLINE);
        }
        if (node.statements != null) {
            ++this.indent;
            node.statements.evaluate(cx, this);
            --this.indent;
        }
        if (this.humanReadable) {
            this.out.append(this.indent()).append("}").append(NEWLINE);
        }
        return null;
    }

    @Override
    public Value evaluate(Context unused_cx, FunctionDefinitionNode node) {
        Context cx = node.cx;
        TreeSet<String> sortedAttributeSet = NodeMagic.getSortedAttributes(node.attrs);
        if (node.attrs == null || this.attributeInfoCache.getAttributeInfo((DefinitionNode)node).isInternal) {
            sortedAttributeSet.add("internal");
        }
        if (this.humanReadable) {
            this.out.append(this.indent());
        }
        this.out.append(NodeMagic.setToString(sortedAttributeSet, " "));
        if (this.humanReadable) {
            this.out.append(" function ");
        } else {
            this.out.append("F");
        }
        if (NodeMagic.functionIsGetter(node)) {
            if (this.humanReadable) {
                this.out.append("get ");
            } else {
                this.out.append("G ");
            }
        } else if (NodeMagic.functionIsSetter(node)) {
            if (this.humanReadable) {
                this.out.append("set ");
            } else {
                this.out.append("S ");
            }
        }
        assert (node.name != null) : "Sanity Failed";
        assert (node.name.identifier != null) : "Sanity Failed";
        this.out.append(NodeMagic.getUnqualifiedFunctionName(node));
        assert (node.fexpr != null) : "Sanity Failed";
        if (this.humanReadable) {
            this.out.append("(");
        }
        if (NodeMagic.getFunctionParamCount(node) > 0) {
            Iterator iter = node.fexpr.signature.parameter.items.iterator();
            while (iter.hasNext()) {
                ParameterNode param = (ParameterNode)iter.next();
                assert (param.kind == -112) : "Sanity Failed";
                if (param instanceof RestParameterNode) {
                    this.out.append("...");
                    continue;
                }
                if (param.type != null) {
                    param.type.evaluate(cx, this);
                } else if (!param.no_anno) {
                    this.out.append("*");
                }
                if (param.init != null) {
                    this.signatureRules.getClass();
                    this.out.append("=...");
                }
                if (!iter.hasNext()) continue;
                this.out.append(", ");
            }
        }
        if (this.humanReadable) {
            this.out.append(")");
        }
        if (node.fexpr.signature.void_anno) {
            if (this.humanReadable) {
                this.out.append(":");
            }
            this.out.append("void");
        } else if (!node.fexpr.signature.no_anno) {
            if (node.fexpr.signature.result != null) {
                if (this.humanReadable) {
                    this.out.append(":");
                }
                node.fexpr.signature.result.evaluate(cx, this);
            } else {
                if (this.humanReadable) {
                    this.out.append(":");
                }
                this.out.append("*");
            }
        }
        if (this.humanReadable) {
            this.out.append(NEWLINE);
        }
        assert (node.fexpr.def == node) : "Sanity Failed";
        return null;
    }

    @Override
    public Value evaluate(Context cx, VariableDefinitionNode node) {
        String kind;
        TreeSet<String> sortedAttributeSet = NodeMagic.getSortedAttributes(node.attrs);
        if (node.attrs == null || this.attributeInfoCache.getAttributeInfo((DefinitionNode)node).isInternal) {
            sortedAttributeSet.add("internal");
        }
        if (this.humanReadable) {
            kind = node.kind == -65 ? "const " : (node.kind == -112 ? "var " : null);
        } else {
            String string = node.kind == -65 ? "C" : (kind = node.kind == -112 ? "V" : null);
        }
        assert (kind != null) : "Unknown VariableDefinitionNode.kind";
        for (VariableBindingNode variableBindingNode : node.list.items) {
            if (this.humanReadable) {
                this.out.append(this.indent());
            }
            this.out.append(NodeMagic.setToString(sortedAttributeSet, " "));
            if (this.humanReadable) {
                this.out.append(" ");
            }
            this.out.append(kind);
            this.out.append(variableBindingNode.variable.identifier.name);
            if (!variableBindingNode.variable.no_anno) {
                if (this.humanReadable) {
                    this.out.append(":");
                }
                if (variableBindingNode.variable.type != null) {
                    variableBindingNode.variable.type.evaluate(cx, this);
                } else {
                    this.out.append("*");
                }
            }
            if (variableBindingNode.initializer != null) {
                this.out.append("=...");
            }
            if (!this.humanReadable) continue;
            this.out.append(NEWLINE);
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, ImportDirectiveNode node) {
        assert (node.attrs == null) : "Sanity Failed";
        assert (node.name != null) : "Sanity Failed";
        assert (node.name.id.list != null) : "Sanity Failed";
        assert (!node.name.id.list.isEmpty()) : "Sanity Failed";
        if (this.humanReadable) {
            this.out.append(this.indent()).append("import ");
        } else {
            this.out.append("I ");
        }
        this.out.append(NodeMagic.getDottedImportName(node));
        if (this.humanReadable) {
            this.out.append(NEWLINE);
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, NamespaceDefinitionNode node) {
        if (this.humanReadable) {
            this.out.append(this.indent());
        }
        if (node.attrs != null) {
            node.attrs.evaluate(cx, this);
        }
        if (this.humanReadable) {
            this.out.append("namespace ");
        } else {
            this.out.append("N");
        }
        if (node.name != null) {
            node.name.evaluate(cx, this);
        }
        if (node.value != null) {
            this.out.append("=");
            node.value.evaluate(cx, this);
        }
        if (this.humanReadable) {
            this.out.append(NEWLINE);
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, ConfigNamespaceDefinitionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, PackageDefinitionNode node) {
        assert (node.attrs == null) : "Sanity Failed";
        if (this.currentPackage == null) {
            this.currentPackage = node;
            if (this.humanReadable) {
                this.out.append("package ");
            } else {
                this.out.append("P");
            }
            this.out.append(NodeMagic.getPackageName(node));
            if (this.humanReadable) {
                this.out.append(NEWLINE).append("{").append(NEWLINE);
            }
        } else {
            this.currentPackage = null;
            if (this.humanReadable) {
                this.out.append("}").append(NEWLINE);
            }
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, UseDirectiveNode node) {
        assert (node.attrs == null) : "Sanity Failed";
        if (this.humanReadable) {
            this.out.append(this.indent()).append("use namespace ");
        } else {
            this.out.append("U");
        }
        if (node.expr != null) {
            if (node.expr instanceof ListNode) {
                this.evaluateSorted(cx, (ListNode)node.expr);
            } else {
                node.expr.evaluate(cx, this);
            }
        }
        if (this.humanReadable) {
            this.out.append(NEWLINE);
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, MetaDataNode node) {
        if (node.data != null) {
            new MetaDataEvaluator().evaluate(cx, node);
        }
        assert (node.id != null) : "Sanity Failed";
        if (this.humanReadable) {
            this.out.append(this.indent()).append("[");
        }
        this.out.append(node.id).append(NodeMagic.getSortedMetaDataParamString(node));
        if (this.humanReadable) {
            this.out.append("]").append(NEWLINE);
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, ExpressionStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, DefaultXMLNamespaceNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, TryStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, CatchClauseNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ArgumentListNode node) {
        Iterator iter = node.items.iterator();
        while (iter.hasNext()) {
            Node item = (Node)iter.next();
            item.evaluate(cx, this);
            if (!iter.hasNext()) continue;
            if (this.humanReadable) {
                this.out.append(", ");
                continue;
            }
            this.out.append(" ");
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, ListNode node) {
        Iterator iter = node.items.iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).evaluate(cx, this);
            if (!iter.hasNext()) continue;
            if (this.humanReadable) {
                this.out.append(", ");
                continue;
            }
            this.out.append(" ");
        }
        return null;
    }

    public Value evaluateSorted(Context cx, ListNode list) {
        StringBuilder tempOut = this.out;
        TreeSet<String> sorted = new TreeSet<String>();
        for (Node node : list.items) {
            this.out = new StringBuilder();
            node.evaluate(cx, this);
            sorted.add(this.out.toString());
        }
        this.out = tempOut;
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            this.out.append((String)iter.next());
            if (!iter.hasNext()) continue;
            if (this.humanReadable) {
                this.out.append(", ");
                continue;
            }
            this.out.append(" ");
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, GetExpressionNode node) {
        if (node.expr != null) {
            if (node.expr instanceof ArgumentListNode) {
                this.out.append("[");
                node.expr.evaluate(cx, this);
                this.out.append("]");
            } else {
                node.expr.evaluate(cx, this);
            }
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, QualifiedIdentifierNode node) {
        if (node.qualifier != null) {
            node.qualifier.evaluate(cx, this);
            this.out.append("::");
        }
        this.evaluate(cx, (IdentifierNode)node);
        return null;
    }

    @Override
    public Value evaluate(Context cx, QualifiedExpressionNode node) {
        this.out.append("@");
        this.evaluate(cx, (QualifiedIdentifierNode)node);
        if (node.expr != null) {
            this.out.append("[");
            node.expr.evaluate(cx, this);
            this.out.append("]");
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, MemberExpressionNode node) {
        if (node.base != null) {
            node.base.evaluate(cx, this);
            if (node.selector instanceof GetExpressionNode && !(((GetExpressionNode)node.selector).expr instanceof ArgumentListNode)) {
                this.out.append(".");
            }
        }
        if (node.selector != null) {
            node.selector.evaluate(cx, this);
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, TypeExpressionNode node) {
        return super.evaluate(cx, node);
    }

    @Override
    public Value evaluate(Context cx, AttributeListNode node) {
        String attrs = NodeMagic.getSortedAttributeString(node, " ");
        if (attrs.length() > 0) {
            this.out.append(attrs).append(" ");
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, ApplyTypeExprNode node) {
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.out.append(".<");
        if (node.typeArgs != null) {
            node.typeArgs.evaluate(cx, this);
        }
        this.out.append(">");
        return null;
    }

    @Override
    public Value evaluate(Context cx, IdentifierNode node) {
        this.out.append(node.name);
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralArrayNode node) {
        this.out.append("[");
        super.evaluate(cx, node);
        this.out.append("]");
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralBooleanNode node) {
        this.out.append(node.value);
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralFieldNode node) {
        if (node.name != null) {
            node.name.evaluate(cx, this);
        }
        if (node.value != null) {
            this.out.append(':');
            node.value.evaluate(cx, this);
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralNullNode node) {
        this.out.append("null");
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralNumberNode node) {
        this.out.append(node.value);
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralObjectNode node) {
        this.out.append('{');
        if (node.fieldlist != null) {
            node.fieldlist.evaluate(cx, this);
        }
        this.out.append('}');
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralRegExpNode node) {
        this.out.append(node.value);
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralStringNode node) {
        this.out.append(node.value);
        return null;
    }

    @Override
    public Value evaluate(Context cx, Node node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, VariableBindingNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, UntypedVariableBindingNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, TypedIdentifierNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ParenExpressionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ParenListExpressionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, FunctionSignatureNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, FunctionCommonNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, PackageIdentifiersNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, PackageNameNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ClassNameNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, FunctionNameNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ImportNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ReturnStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, SuperExpressionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, SuperStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, SwitchStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ThisExpressionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ThrowStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, UnaryExpressionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, WhileStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, WithStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, DeleteExpressionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, DoStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, FinallyClauseNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ForStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, IfStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, IncrementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, RestParameterNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, BreakStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, CallExpressionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, CaseLabelNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ConditionalExpressionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ContinueStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, BinaryClassDefNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, BinaryExpressionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, BinaryFunctionDefinitionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, BinaryInterfaceDefinitionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, BinaryProgramNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, HasNextNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, LoadRegisterNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, StoreRegisterNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, RegisterNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, InheritanceNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, InvokeNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ParameterListNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ParameterNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, RestExpressionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, LabeledStatementNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, BoxNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, CoerceNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, ToObjectNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, PragmaNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, PragmaExpressionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, SetExpressionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, StatementListNode statementList) {
        StringBuilder originalOut = this.out;
        TreeSet<String> imports = null;
        TreeSet<String> useNamespaces = null;
        TreeMap<String, Set<String>> variables = null;
        TreeMap<String, Set<String>> functions = null;
        TreeMap<String, Set<String>> classes = null;
        TreeMap<String, Set<String>> interfaces = null;
        for (int i = 0; i < statementList.items.size(); ++i) {
            Node node = (Node)statementList.items.get(i);
            if (this.insidePackage && node instanceof ImportDirectiveNode) {
                if (imports == null) {
                    imports = new TreeSet<String>();
                }
                this.out = new StringBuilder();
                node.evaluate(cx, this);
                imports.add(this.out.toString());
                this.out = originalOut;
                continue;
            }
            if (this.insidePackage && node instanceof NamespaceDefinitionNode) {
                if (useNamespaces == null) {
                    useNamespaces = new TreeSet<String>();
                }
                this.out = new StringBuilder();
                node.evaluate(cx, this);
                useNamespaces.add(this.out.toString());
                this.out = originalOut;
                continue;
            }
            if (this.insidePackage && node instanceof ClassDefinitionNode) {
                if (classes == null) {
                    classes = new TreeMap<String, Set<String>>();
                }
                this.putDefinition(classes, cx, (DefinitionNode)node);
                continue;
            }
            if (this.insidePackage && node instanceof InterfaceDefinitionNode) {
                if (interfaces == null) {
                    interfaces = new TreeMap<String, Set<String>>();
                }
                this.putDefinition(interfaces, cx, (DefinitionNode)node);
                continue;
            }
            if (this.insidePackage && node instanceof FunctionDefinitionNode) {
                if (functions == null) {
                    functions = new TreeMap<String, Set<String>>();
                }
                this.putDefinition(functions, cx, (DefinitionNode)node);
                continue;
            }
            if (this.insidePackage && node instanceof VariableDefinitionNode) {
                if (variables == null) {
                    variables = new TreeMap<String, Set<String>>();
                }
                this.putDefinition(variables, cx, (DefinitionNode)node);
                continue;
            }
            if (node instanceof PackageDefinitionNode) {
                if (this.insidePackage) {
                    this.appendSorted(imports, useNamespaces, variables, functions, classes, interfaces);
                    imports = null;
                    useNamespaces = null;
                    variables = null;
                    functions = null;
                    classes = null;
                    interfaces = null;
                    node.evaluate(cx, this);
                    this.insidePackage = false;
                    continue;
                }
                node.evaluate(cx, this);
                this.insidePackage = true;
                continue;
            }
            if (node instanceof MetaDataNode) continue;
            node.evaluate(cx, this);
        }
        this.appendSorted(imports, useNamespaces, variables, functions, classes, interfaces);
        return null;
    }

    private void appendSorted(Set<String> imports, Set<String> useNamespaces, Map<String, Set<String>> variables, Map<String, Set<String>> functions, Map<String, Set<String>> classes, Map<String, Set<String>> interfaces) {
        this.appendSorted(imports);
        this.appendSorted(useNamespaces);
        this.appendSorted(variables);
        this.appendSorted(functions);
        this.appendSorted(classes);
        this.appendSorted(interfaces);
    }

    private void appendSorted(Set<String> statements) {
        if (statements != null) {
            for (String statement : statements) {
                this.out.append(statement);
            }
        }
    }

    private void appendSorted(Map<String, Set<String>> definitions) {
        if (definitions != null) {
            for (Map.Entry<String, Set<String>> entry : definitions.entrySet()) {
                if (entry.getValue() != null) {
                    for (String metaData : entry.getValue()) {
                        this.out.append(metaData);
                    }
                }
                this.out.append(entry.getKey());
            }
        }
    }

    private void putDefinition(Map<String, Set<String>> declarations, Context cx, DefinitionNode definition) {
        StringBuilder originalOut = this.out;
        this.out = new StringBuilder();
        definition.evaluate(cx, this);
        String declaration = this.out.toString();
        TreeSet<String> metaData = null;
        if (definition.metaData != null) {
            metaData = new TreeSet<String>();
            for (Node metaDataNode : definition.metaData.items) {
                this.out = new StringBuilder();
                metaDataNode.evaluate(cx, this);
                metaData.add(this.out.toString());
            }
        }
        declarations.put(declaration, metaData);
        this.out = originalOut;
    }

    @Override
    public void setLocalizationManager(LocalizationManager l10n) {
        super.setLocalizationManager(l10n);
    }

    @Override
    public Value evaluate(Context cx, DocCommentNode node) {
        return super.evaluate(cx, node);
    }

    @Override
    public Value evaluate(Context cx, EmptyStatementNode node) {
        return super.evaluate(cx, node);
    }

    @Override
    public Value evaluate(Context cx, EmptyElementNode node) {
        return super.evaluate(cx, node);
    }

    @Override
    public Value evaluate(Context cx, IncludeDirectiveNode node) {
        return super.evaluate(cx, node);
    }

    @Override
    public Value evaluate(Context cx, LiteralXMLNode node) {
        return super.evaluate(cx, node);
    }

    @Override
    public Value evaluate(Context cx, ErrorNode node) {
        return super.evaluate(cx, node);
    }
}

