/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.Assets;
import flex2.compiler.CompilerContext;
import flex2.compiler.Source;
import flex2.compiler.abc.AbcClass;
import flex2.compiler.abc.MetaData;
import flex2.compiler.css.Styles;
import flex2.compiler.css.StylesContainer;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.util.MultiNameMap;
import flex2.compiler.util.Name;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameList;
import flex2.compiler.util.QNameSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompilationUnit {
    public static final int Empty = 0;
    public static final int SyntaxTree = 1;
    public static final int abc = 2;
    public static final int Done = 4;
    static final String COMPILATION_UNIT = CompilationUnit.class.getName();
    private Source source;
    private Object syntaxTree;
    private CompilerContext context;
    private Assets assets;
    private int state;
    private int workflow;
    private StandardDefs standardDefs;
    public ByteList bytes;
    public Set<MetaDataNode> metadata;
    public MetaData swfMetaData;
    public MetaData iconFile;
    public String loaderClass;
    public String loaderClassBase;
    public Set<String> extraClasses;
    private Map<QName, Source> generatedSources;
    public Map<String, Object> auxGenerateInfo;
    private Set<String> accessibilityClasses;
    public Map<String, String> licensedClassReqs;
    public Map<String, String> remoteClassAliases;
    public Map<String, String> effectTriggers;
    public Set<String> mixins;
    public Set<String> resourceBundles;
    public Set<String> resourceBundleHistory;
    public QNameList topLevelDefinitions;
    public Set<Name> inheritance;
    public Set<Name> types;
    public Set<Name> expressions;
    public Set<Name> namespaces;
    public Set<String> importPackageStatements;
    public QNameSet importDefinitionStatements;
    public MultiNameMap inheritanceHistory;
    public MultiNameMap typeHistory;
    public MultiNameMap namespaceHistory;
    public MultiNameMap expressionHistory;
    public Styles styles;
    public String styleName;
    private StylesContainer stylesContainer;
    public boolean hasTypeInfo;
    public ObjectValue typeInfo;
    public Map<String, AbcClass> classTable;
    public MetaDataNode hostComponentMetaData;
    public String hostComponentOwnerClass;
    private Long signatureChecksum;
    public int checkBits = 0;

    CompilationUnit(Source source, Object syntaxTree, CompilerContext context) {
        this.source = source;
        this.syntaxTree = syntaxTree;
        this.context = context;
        this.reset();
    }

    public void setSignatureChecksum(Long signatureChecksum) {
        this.signatureChecksum = signatureChecksum;
    }

    public Long getSignatureChecksum() {
        return this.signatureChecksum;
    }

    public boolean hasSignatureChecksum() {
        return this.signatureChecksum != null;
    }

    void resetKeepTypeInfo() {
        this.assets = null;
        this.signatureChecksum = null;
        this.state = 0;
        this.workflow = 0;
        if (this.bytes == null) {
            this.bytes = new ByteList();
        } else {
            this.bytes.clear();
        }
        if (this.metadata == null) {
            this.metadata = new HashSet<MetaDataNode>();
        } else {
            this.metadata.clear();
        }
        this.swfMetaData = null;
        this.iconFile = null;
        this.loaderClass = null;
        if (this.extraClasses == null) {
            this.extraClasses = new HashSet<String>();
        } else {
            this.extraClasses.clear();
        }
        this.generatedSources = null;
        this.auxGenerateInfo = null;
        this.accessibilityClasses = null;
        if (this.remoteClassAliases == null) {
            this.remoteClassAliases = new HashMap<String, String>(1);
        } else {
            this.remoteClassAliases.clear();
        }
        if (this.licensedClassReqs == null) {
            this.licensedClassReqs = new HashMap<String, String>(1);
        } else {
            this.licensedClassReqs.clear();
        }
        if (this.effectTriggers == null) {
            this.effectTriggers = new HashMap<String, String>(1);
        } else {
            this.effectTriggers.clear();
        }
        this.mixins = new HashSet<String>(2);
        if (this.resourceBundles == null) {
            this.resourceBundles = new HashSet<String>(1);
            this.resourceBundleHistory = new HashSet<String>(1);
        } else {
            this.resourceBundles.clear();
            this.resourceBundleHistory.clear();
        }
        if (this.topLevelDefinitions == null) {
            this.topLevelDefinitions = new QNameList(this.source.isSourcePathOwner() || this.source.isSourceListOwner() ? 1 : 8);
        } else {
            this.topLevelDefinitions.clear();
        }
        if (this.inheritance == null) {
            this.inheritance = new HashSet<Name>(2);
            this.types = new HashSet<Name>(8);
            this.expressions = new HashSet<Name>(8);
            this.namespaces = new HashSet<Name>(2);
            this.importPackageStatements = new HashSet<String>(16);
            this.importDefinitionStatements = new QNameSet(16);
            this.inheritanceHistory = new MultiNameMap(2);
            this.typeHistory = new MultiNameMap(8);
            this.expressionHistory = new MultiNameMap(8);
            this.namespaceHistory = new MultiNameMap(2);
        } else {
            this.inheritance.clear();
            this.types.clear();
            this.expressions.clear();
            this.namespaces.clear();
            this.importPackageStatements.clear();
            this.importDefinitionStatements.clear();
            this.inheritanceHistory.clear();
            this.typeHistory.clear();
            this.expressionHistory.clear();
            this.namespaceHistory.clear();
        }
        if (this.styles == null) {
            this.styles = new Styles(2);
        } else {
            this.styles.clear();
        }
        this.checkBits = 0;
    }

    void reset() {
        this.resetKeepTypeInfo();
        this.removeTypeInfo();
    }

    void removeTypeInfo() {
        this.hasTypeInfo = false;
        this.typeInfo = null;
        if (this.classTable == null) {
            this.classTable = new HashMap<String, AbcClass>(this.source.isSourcePathOwner() || this.source.isSourceListOwner() ? 4 : 8);
        } else {
            this.classTable.clear();
        }
    }

    public boolean isRoot() {
        return this.source.isRoot();
    }

    public void addGeneratedSource(QName defName, Source source) {
        if (this.generatedSources == null) {
            this.generatedSources = new HashMap<QName, Source>();
        }
        this.generatedSources.put(defName, source);
    }

    public void addGeneratedSources(Map<QName, Source> generatedSources) {
        if (generatedSources != null) {
            if (this.generatedSources == null) {
                this.generatedSources = new HashMap<QName, Source>();
            }
            this.generatedSources.putAll(generatedSources);
        }
    }

    public void clearGeneratedSources() {
        this.generatedSources = null;
    }

    public Map<QName, Source> getGeneratedSources() {
        return this.generatedSources;
    }

    public Source getSource() {
        return this.source;
    }

    void setState(int flag) {
        this.state |= flag;
        if (flag == 2) {
            this.syntaxTree = null;
            if (!this.isRoot()) {
                this.source.disconnectLogger();
            }
        } else if (flag == 4) {
            this.hasTypeInfo = this.typeInfo != null;
            this.context.clear();
            this.metadata.clear();
            this.source.clearSourceFragments();
        }
    }

    int getState() {
        return this.state;
    }

    public boolean isBytecodeAvailable() {
        return (this.state & 2) != 0;
    }

    public boolean isDone() {
        return (this.state & 4) != 0;
    }

    void setWorkflow(int flag) {
        this.workflow |= flag;
    }

    int getWorkflow() {
        return this.workflow;
    }

    public Object getSyntaxTree() {
        return this.syntaxTree;
    }

    public void setSyntaxTree(Object syntaxTree) {
        this.syntaxTree = syntaxTree;
    }

    public CompilerContext getContext() {
        return this.context;
    }

    public Assets getAssets() {
        if (this.assets == null) {
            this.assets = new Assets();
        }
        return this.assets;
    }

    public boolean hasAssets() {
        return this.assets != null;
    }

    public void addAccessibilityClasses(CompilationUnit u) {
        if (u.accessibilityClasses != null) {
            if (this.accessibilityClasses == null) {
                this.accessibilityClasses = new HashSet<String>();
            }
            this.accessibilityClasses.addAll(u.accessibilityClasses);
        }
    }

    public void addAccessibilityClass(MetaData metadata) {
        String accessibilityClass;
        if (this.accessibilityClasses == null) {
            this.accessibilityClasses = new HashSet<String>();
        }
        if (!this.accessibilityClasses.contains(accessibilityClass = metadata.getValue("implementation"))) {
            this.accessibilityClasses.add(accessibilityClass);
        }
    }

    public Set<String> getAccessibilityClasses() {
        return this.accessibilityClasses;
    }

    public byte[] getByteCodes() {
        return this.bytes.toByteArray(false);
    }

    public StylesContainer getStylesContainer() {
        return this.stylesContainer;
    }

    public void setStylesContainer(StylesContainer stylesContainer) {
        this.stylesContainer = stylesContainer;
    }

    public StandardDefs getStandardDefs() {
        return this.standardDefs;
    }

    public void setStandardDefs(StandardDefs defs) {
        this.standardDefs = defs;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompilationUnit) {
            return ((CompilationUnit)obj).getSource() == this.getSource();
        }
        return false;
    }

    public String toString() {
        return this.source.getName();
    }
}

