/*
 * Decompiled with CFR 0.152.
 */
package flex.ant.types;

import flex.ant.config.OptionSource;
import flex.ant.config.OptionSpec;
import java.io.File;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class FlexFileSet
extends FileSet
implements OptionSource {
    protected final OptionSpec spec;
    protected final boolean includeDirs;
    protected boolean append;

    public FlexFileSet() {
        this(false);
    }

    public FlexFileSet(OptionSpec spec) {
        this(spec, false);
    }

    public FlexFileSet(boolean dirs) {
        this.spec = null;
        this.includeDirs = dirs;
        this.append = false;
    }

    public FlexFileSet(OptionSpec spec, boolean dirs) {
        this.spec = spec;
        this.includeDirs = dirs;
        this.append = false;
    }

    public void setAppend(boolean value) {
        this.append = value;
    }

    public void addToCommandline(Commandline cmdl) {
        if (this.hasSelectors() || this.hasPatterns()) {
            DirectoryScanner scanner = this.getDirectoryScanner(this.getProject());
            if (this.includeDirs) {
                this.addFiles(scanner.getBasedir(), scanner.getIncludedDirectories(), cmdl);
            }
            this.addFiles(scanner.getBasedir(), scanner.getIncludedFiles(), cmdl);
        } else if (this.spec != null) {
            cmdl.createArgument().setValue("-" + this.spec.getFullName() + "=");
        }
    }

    private void addFiles(File base, String[] files, Commandline cmdl) {
        FileUtils utils = FileUtils.getFileUtils();
        if (this.spec == null) {
            for (int i = 0; i < files.length; ++i) {
                cmdl.createArgument().setValue(utils.resolveFile(base, files[i]).getAbsolutePath());
            }
        } else {
            for (int i = 0; i < files.length; ++i) {
                cmdl.createArgument().setValue("-" + this.spec.getFullName() + this.equalString() + utils.resolveFile(base, files[i]).getAbsolutePath());
            }
        }
    }

    private String equalString() {
        return this.append ? "+=" : "=";
    }
}

