/*
 * Decompiled with CFR 0.152.
 */
package flex.ant.config;

import flex.ant.config.OptionSource;
import flex.ant.config.OptionSpec;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.types.Commandline;

public class NestedAttributeElement
implements DynamicAttribute,
OptionSource {
    private static final String COMMA = ",";
    private String[] attribs;
    private String[] values;
    private OptionSpec spec;
    private boolean valueHasComma;

    public NestedAttributeElement(String attrib, OptionSpec spec) {
        this(new String[]{attrib}, spec);
    }

    public NestedAttributeElement(String[] attribs, OptionSpec spec) {
        this.attribs = attribs;
        this.values = new String[attribs.length];
        this.spec = spec;
    }

    public void addText(String value) {
        this.values[0] = value;
        if (value.indexOf(COMMA) != -1) {
            this.valueHasComma = true;
        }
    }

    public void setDynamicAttribute(String name, String value) {
        boolean isSet = false;
        for (int i = 0; i < this.attribs.length && !isSet; ++i) {
            if (!this.attribs[i].equals(name)) continue;
            this.values[i] = value;
            isSet = true;
        }
        if (value.indexOf(COMMA) != -1) {
            this.valueHasComma = true;
        }
        if (!isSet) {
            throw new BuildException("The <" + this.spec.getFullName() + "> type doesn't support the \"" + name + "\" attribute.");
        }
    }

    public void addToCommandline(Commandline cmdl) {
        if (this.valueHasComma) {
            cmdl.createArgument().setValue("-" + this.spec.getFullName());
            for (int i = 0; i < this.attribs.length; ++i) {
                if (this.values[i] == null) continue;
                cmdl.createArgument().setValue(this.values[i].replaceAll("\\s*,\\s*", COMMA));
            }
        } else {
            StringBuilder stringBuffer = new StringBuilder();
            for (int i = 0; i < this.attribs.length; ++i) {
                if (this.values[i] == null) continue;
                stringBuffer.append(this.values[i]);
                if (i + 1 >= this.attribs.length) continue;
                stringBuffer.append(COMMA);
            }
            cmdl.createArgument().setValue("-" + this.spec.getFullName() + "=" + stringBuffer);
        }
    }
}

